/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.hist.JASHist;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.job.PageAccess;
import jas.job.PlotAccess;
import jas.plot.HasPopupItems;
import jas.plot.PrintHelper;
import jas.swingstudio.ChangableContainer;
import jas.swingstudio.Closable;
import jas.swingstudio.HasCommandProcessor;
import jas.swingstudio.JASCommandProcessor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.TreeData;
import jas.util.CommandProcessor;
import jas.util.FileTypeFileFilter;
import jas.util.JASMenuItem;
import jas.util.JASState;
import jas.util.encoder.GifEncoder;
import jas.util.layout.PercentLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.RepaintManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class JASPage
extends JPanel
implements HasCommandProcessor,
ChangableContainer,
HasPopupItems,
Closable {
    private Vector m_plots;
    private Border border = new PageBorder();
    private JASHist currentPlot;
    private PageCommandProcessor commandProcessor = new PageCommandProcessor();
    private static JavaAnalysisStudio jas = JavaAnalysisStudio.getApp();
    private MouseListener ml = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            JASHist jASHist = (JASHist)mouseEvent.getSource();
            if (JASPage.this.currentPlot != jASHist) {
                JASPage.this.currentPlot.deselected();
                JASPage.this.currentPlot.repaint();
                JASPage.this.currentPlot = jASHist;
                JASPage.this.currentPlotChanged();
                JASPage.this.currentPlot.repaint();
            }
        }
    };

    public JASPage(PageAccess pageAccess) {
        int n = pageAccess.getNPlots();
        if (n > 0) {
            boolean bl = pageAccess.getPlot(0).isConstrained();
            if (bl) {
                this.setLayout(new PercentLayout());
            } else {
                this.setLayout(n);
            }
            this.m_plots = new Vector(n);
            int n2 = 0;
            while (n2 < n) {
                PlotAccess plotAccess = pageAccess.getPlot(n2);
                JASHist jASHist = new JASHist();
                int n3 = plotAccess.getNDataSources();
                int n4 = 0;
                while (n4 < n3) {
                    jASHist.addData(plotAccess.getData(n4)).show(true);
                    ++n4;
                }
                JASPage.calculateTitlesAndLabels(jASHist);
                jASHist.setBorder(this.border);
                jASHist.addMouseListener(this.ml);
                this.m_plots.addElement(jASHist);
                if (plotAccess.isConstrained()) {
                    PercentLayout.Constraint constraint = new PercentLayout.Constraint(plotAccess.getX(), plotAccess.getY(), plotAccess.getWidth(), plotAccess.getHeight());
                    this.add((Component)jASHist, constraint);
                } else {
                    this.add(jASHist);
                }
                this.currentPlot = jASHist;
                ++n2;
            }
        } else {
            this.setLayout(1);
            this.m_plots = new Vector();
            this.currentPlot = this.addPlotToPage();
        }
        this.currentPlotChanged();
    }

    public JASPage(int n, int n2) {
        this.setLayout(new GridLayout(n, n2));
        this.m_plots = new Vector(n * n2);
        int n3 = 0;
        while (n3 < n * n2) {
            this.currentPlot = this.addPlotToPage();
            ++n3;
        }
        this.currentPlotChanged();
    }

    private JASHist addPlotToPage() {
        JASHist jASHist = new JASHist();
        jASHist.setBorder(this.border);
        jASHist.addMouseListener(this.ml);
        this.m_plots.addElement(jASHist);
        this.add(jASHist);
        return jASHist;
    }

    public void paintComponent(Graphics graphics) {
        if (this.isOpaque() && !PrintHelper.isPrinting()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void addPlot() {
        this.setLayout(this.m_plots.size() + 1);
        this.currentPlot = this.addPlotToPage();
        this.currentPlotChanged();
        this.commandProcessor.setChanged();
        this.validate();
    }

    private void removePlot() {
        this.remove(this.currentPlot);
        this.m_plots.removeElement(this.currentPlot);
        this.currentPlot.removeMouseListener(this.ml);
        this.currentPlot.destroy();
        this.currentPlot = (JASHist)this.m_plots.elementAt(0);
        this.currentPlotChanged();
        this.setLayout(this.m_plots.size());
        this.validate();
    }

    private void setLayout(int n) {
        GridLayout gridLayout;
        int n2;
        int n3;
        if (n == 1) {
            n3 = 1;
            n2 = 1;
        } else if (n == 2) {
            n2 = 2;
            n3 = 1;
        } else if (n == 3) {
            n2 = 3;
            n3 = 1;
        } else if (n == 4) {
            n2 = 2;
            n3 = 2;
        } else if (n <= 6) {
            n2 = 3;
            n3 = 2;
        } else if (n <= 9) {
            n2 = 3;
            n3 = 3;
        } else if (n <= 12) {
            n2 = 4;
            n3 = 3;
        } else if (n <= 16) {
            n2 = 4;
            n3 = 4;
        } else if (n <= 20) {
            n2 = 5;
            n3 = 4;
        } else if (n <= 25) {
            n2 = 5;
            n3 = 5;
        } else {
            throw new IllegalArgumentException("Too many plots on page");
        }
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof GridLayout) {
            gridLayout = (GridLayout)layoutManager;
        }
        gridLayout = new GridLayout();
        this.setLayout(gridLayout);
        if (n2 != gridLayout.getColumns()) {
            gridLayout.setColumns(n2);
        }
        if (n3 != gridLayout.getRows()) {
            gridLayout.setRows(n3);
        }
    }

    public boolean pleaseClose() {
        Enumeration enumeration = this.m_plots.elements();
        while (enumeration.hasMoreElements()) {
            JASHist jASHist = (JASHist)enumeration.nextElement();
            jASHist.removeMouseListener(this.ml);
            jASHist.destroy();
        }
        return true;
    }

    public void pageSelected(boolean bl) {
        if (bl) {
            this.currentPlotUpdated();
        } else {
            jas.setRebinModel(null, null);
        }
    }

    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public JASHist getCurrentPlot() {
        return this.currentPlot;
    }

    public void currentPlotUpdated() {
        this.currentPlotChanged();
    }

    private void currentPlotChanged() {
        JASHistAxis jASHistAxis;
        DefaultBoundedRangeModel defaultBoundedRangeModel = null;
        DefaultBoundedRangeModel defaultBoundedRangeModel2 = null;
        final JASHistAxis jASHistAxis2 = this.currentPlot.getXAxis();
        if (jASHistAxis2.isBinned() && !jASHistAxis2.isFixed()) {
            defaultBoundedRangeModel = new DefaultBoundedRangeModel(jASHistAxis2.getBins(), 0, 1, Math.max(200, 2 * jASHistAxis2.getBins())){

                public void fireStateChanged() {
                    jASHistAxis2.setBins(this.getValue());
                    super.fireStateChanged();
                }
            };
        }
        if ((jASHistAxis = this.currentPlot.getYAxis()).isBinned() && !jASHistAxis.isFixed()) {
            defaultBoundedRangeModel2 = new DefaultBoundedRangeModel(jASHistAxis.getBins(), 0, 1, Math.max(200, 2 * jASHistAxis.getBins())){

                public void fireStateChanged() {
                    jASHistAxis.setBins(this.getValue());
                    super.fireStateChanged();
                }
            };
        }
        jas.setRebinModel(defaultBoundedRangeModel, defaultBoundedRangeModel2);
    }

    public boolean hasChanged() {
        Enumeration enumeration = this.m_plots.elements();
        while (enumeration.hasMoreElements()) {
            if (!((JASHist)enumeration.nextElement()).isChanged()) continue;
            return true;
        }
        return false;
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(new JASMenuItem("Remove Plot", 'R'));
        jPopupMenu.add(new JASMenuItem("Print Page...", 'P'));
    }

    public static void calculateTitlesAndLabels(JASHist jASHist) {
        int n;
        int n2;
        CharSequence charSequence;
        Object object;
        if (jASHist.getNumberOfDataSources() == 0) {
            return;
        }
        String[][] stringArrayArray = new String[jASHist.getNumberOfDataSources()][];
        Enumeration enumeration = jASHist.getDataSources();
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        while (n3 < stringArrayArray.length) {
            object = (JASHistData)enumeration.nextElement();
            stringArrayArray[n3] = ((JASHistData)object).getDataSource() instanceof TreeData ? ((TreeData)((Object)((JASHistData)object).getDataSource())).getItem().path : new String[]{((JASHistData)object).getTitle()};
            n4 = Math.min(n4, stringArrayArray[n3].length);
            ++n3;
        }
        object = new boolean[n4];
        int n5 = 0;
        while (n5 < n4) {
            charSequence = stringArrayArray[0][n5];
            n2 = 1;
            n = 1;
            while (n < n3) {
                if (!((String)charSequence).equals(stringArrayArray[n][n5])) {
                    n2 = 0;
                    break;
                }
                ++n;
            }
            object[n5] = n2;
            ++n5;
        }
        charSequence = new StringBuffer();
        n2 = 0;
        while (n2 < n4) {
            if (!(object[n2] == false || n2 == 0 && stringArrayArray[0][0].equals("Histograms"))) {
                if (((StringBuffer)charSequence).length() > 0) {
                    ((StringBuffer)charSequence).append(" - ");
                }
                ((StringBuffer)charSequence).append(stringArrayArray[0][n2]);
            }
            ++n2;
        }
        jASHist.setTitle(((StringBuffer)charSequence).toString());
        enumeration = jASHist.getDataSources();
        n = 0;
        while (enumeration.hasMoreElements()) {
            JASHistData jASHistData = (JASHistData)enumeration.nextElement();
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = 0;
            while (n6 < stringArrayArray[n].length) {
                if (n6 >= n4 || object[n6] == false) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" - ");
                    }
                    stringBuffer.append(stringArrayArray[n][n6]);
                }
                ++n6;
            }
            jASHistData.setLegendText(stringBuffer.toString());
            ++n;
        }
    }

    private class PageCommandProcessor
    extends JASCommandProcessor {
        private PageCommandProcessor() {
        }

        public void onPrint() throws Exception {
            PrintHelper printHelper = PrintHelper.instance();
            printHelper.printTarget(JASPage.this);
        }

        public void onPrintPage() throws Exception {
            PrintHelper printHelper = PrintHelper.instance();
            printHelper.printTarget(JASPage.this);
        }

        public void onProperties() {
            JASPage.this.currentPlot.showProperties();
        }

        public void enableProperties(JASState jASState) {
            jASState.setEnabled(JASPage.this.currentPlot.supportsProperties());
        }

        public void onSaveAs() throws IOException {
            String string = jas.getUserProperties().getProperty("jas.swingstudio.JASPage.savedir");
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setFileFilter(new FileTypeFileFilter("gif", "Image Files (*.gif)"));
            int n = jFileChooser.showSaveDialog(jas);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                ((Hashtable)jas.getUserProperties()).put("jas.swingstudio.JASPage.savedir", file.toString());
                JASPage jASPage = JASPage.this;
                Image image = jASPage.createImage(jASPage.getWidth(), jASPage.getHeight());
                Graphics graphics = image.getGraphics();
                RepaintManager repaintManager = RepaintManager.currentManager(jASPage);
                boolean bl = repaintManager.isDoubleBufferingEnabled();
                repaintManager.setDoubleBufferingEnabled(false);
                jASPage.print(graphics);
                graphics.dispose();
                repaintManager.setDoubleBufferingEnabled(bl);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                GifEncoder gifEncoder = new GifEncoder(image, (OutputStream)bufferedOutputStream);
                gifEncoder.encode();
                ((OutputStream)bufferedOutputStream).close();
                image.flush();
            }
        }

        public void onRemovePlot() {
            JASPage.this.removePlot();
            this.setChanged();
        }

        public void enableRemovePlot(JASState jASState) {
            jASState.setEnabled(JASPage.this.m_plots.size() > 1);
        }

        public void setChanged() {
            super.setChanged();
        }
    }

    private class PageBorder
    extends AbstractBorder {
        private PageBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = RepaintManager.currentManager(component).isDoubleBufferingEnabled();
            graphics.setColor(component == JASPage.this.currentPlot && bl ? Color.blue : JASPage.this.getBackground());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }
    }
}

