/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.hist.FitterFactory;
import jas.hist.FitterRegistry;
import jas.swingstudio.ClassPathPanel;
import jas.swingstudio.JASAddRemovePanel;
import jas.swingstudio.JASClassPath;
import jas.swingstudio.JASJob;
import jas.swingstudio.JASSourcePath;
import jas.swingstudio.MustTestInput;
import jas.swingstudio.OptionsDialog;
import jas.swingstudio.OptionsPage;
import jas.swingstudio.ProgramPage;
import jas.swingstudio.ProgramTextArea;
import jas.swingstudio.SourcePathPanel;
import jas.util.ColorChooser;
import jas.util.FontChooserPanel;
import jas.util.JASEditableComboBox;
import jas.util.JASTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

final class JASOptionsDialog
extends OptionsDialog {
    JASOptionsDialog(Frame frame) {
        super(frame, "Options...");
        this.addPage("Defaults", new Defaults());
        this.addPage("Class Path", new ClassPath());
        this.addPage("Source Path", new SourcePath());
        this.addPage("Compiler", new Compiler());
        this.addPage("Timed Backup", new Backup());
        this.addPage("Source Code Text", new Text());
        this.addPage("Source Code Printing", new Printing());
        this.pack();
        this.m_init = true;
        this.show();
    }

    private final class Printing
    extends OptionsPage
    implements MustTestInput {
        private float m_leftValue;
        private float m_rightValue;
        private float m_topValue;
        private float m_bottomValue;
        private JASTextField m_left;
        private JASTextField m_right;
        private JASTextField m_top;
        private JASTextField m_bottom;
        private FontChooserPanel m_printingFontChooser;

        Printing() {
            super(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel(new GridLayout(4, 2));
            jPanel.add(new JLabel("Top margin:"));
            this.m_top = new JASTextField(String.valueOf(ProgramPage.getTopMargin()));
            jPanel.add(this.m_top);
            jPanel.add(new JLabel("Bottom margin:"));
            this.m_bottom = new JASTextField(String.valueOf(ProgramPage.getBottomMargin()));
            jPanel.add(this.m_bottom);
            jPanel.add(new JLabel("Left margin:"));
            this.m_left = new JASTextField(String.valueOf(ProgramPage.getLeftMargin()));
            jPanel.add(this.m_left);
            jPanel.add(new JLabel("Right margin:"));
            this.m_right = new JASTextField(String.valueOf(ProgramPage.getRightMargin()));
            jPanel.add(this.m_right);
            this.m_top.addKeyListener(JASOptionsDialog.this);
            this.m_bottom.addKeyListener(JASOptionsDialog.this);
            this.m_left.addKeyListener(JASOptionsDialog.this);
            this.m_right.addKeyListener(JASOptionsDialog.this);
            jPanel.setBorder(BorderFactory.createTitledBorder("Page margins (in inches)"));
            this.m_printingFontChooser = new FontChooserPanel(ProgramTextArea.getPrintingFont(), ProgramTextArea.getPrintingFontStyle(), ProgramTextArea.getPrintingFontSize());
            this.m_printingFontChooser.addItemListener(JASOptionsDialog.this);
            this.m_printingFontChooser.addChangeListener(JASOptionsDialog.this);
            this.m_printingFontChooser.addKeyListener(JASOptionsDialog.this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.insets.top = 10;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.fill = 1;
            this.m_printingFontChooser.setBorder(BorderFactory.createTitledBorder("Printing Font"));
            this.add((Component)this.m_printingFontChooser, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.add((Component)jPanel, gridBagConstraints);
        }

        String getHelpTopic() {
            return "userInterface.optionsDialog.sourceCodeStyle";
        }

        public boolean inputIsValid() {
            try {
                float f;
                float f2;
                float f3;
                float f4;
                String string = this.m_left.getText();
                this.m_leftValue = Float.valueOf(string).floatValue();
                if ((double)f4 < 0.0) {
                    throw new NumberFormatException(string);
                }
                string = this.m_right.getText();
                this.m_rightValue = Float.valueOf(string).floatValue();
                if ((double)f3 < 0.0) {
                    throw new NumberFormatException(string);
                }
                string = this.m_top.getText();
                this.m_topValue = Float.valueOf(string).floatValue();
                if ((double)f2 < 0.0) {
                    throw new NumberFormatException(string);
                }
                string = this.m_bottom.getText();
                this.m_bottomValue = Float.valueOf(string).floatValue();
                if ((double)f < 0.0) {
                    throw new NumberFormatException(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid margin value: " + numberFormatException.getMessage(), "Margin error", 0);
                return false;
            }
            return this.m_printingFontChooser.inputIsValid();
        }

        void apply() {
            Font font = this.m_printingFontChooser.getSpecifiedFont();
            ProgramPage.setLeftMargin(this.m_leftValue);
            ProgramPage.setRightMargin(this.m_rightValue);
            ProgramPage.setTopMargin(this.m_topValue);
            ProgramPage.setBottomMargin(this.m_bottomValue);
            ProgramTextArea.setPrintingFont(font.getName());
            ProgramTextArea.setPrintingFontStyle(font.getStyle());
            ProgramTextArea.setPrintingFontSize(font.getSize());
            ProgramPage.updateInstanceFonts();
            ProgramPage.updateInstanceStyles();
        }
    }

    private final class Text
    extends OptionsPage
    implements MustTestInput {
        private float m_tabSizeValue;
        private JCheckBox m_currentLineHighlight;
        private JCheckBox m_bracketHighlight;
        private JCheckBox m_syntaxHighlight;
        private JCheckBox m_blinkingCaret;
        private JCheckBox m_electricBorders;
        private JASTextField m_tabSize;
        private FontChooserPanel m_fontChooser = new FontChooserPanel(ProgramTextArea.getDisplayFont(), ProgramTextArea.getFontStyle(), ProgramTextArea.getFontSize());
        private final ColorChooser m_comment;
        private final ColorChooser m_string;
        private final ColorChooser m_keyword;
        private final ColorChooser m_number;
        private final ColorChooser m_line;
        private final ColorChooser m_bracket;
        private final ColorChooser m_foreground;
        private final ColorChooser m_background;
        private final ColorChooser m_caret;
        private final ColorChooser m_selection;

        Text() {
            super(new GridBagLayout());
            this.m_fontChooser.addItemListener(JASOptionsDialog.this);
            this.m_fontChooser.addChangeListener(JASOptionsDialog.this);
            this.m_fontChooser.addKeyListener(JASOptionsDialog.this);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets.bottom = 0;
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.insets.left = 0;
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(new JLabel("Tab Size:"));
            this.m_tabSize = new JASTextField(new Integer(JASOptionsDialog.this.m_app.getUserProperties().getInteger("tabSize", 4)).toString(), 5);
            jPanel2.add(this.m_tabSize);
            this.m_tabSize.addKeyListener(JASOptionsDialog.this);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            this.m_currentLineHighlight = new JCheckBox("Current line highlighting", ProgramTextArea.getCurrentLineHighlight());
            jPanel.add((Component)this.m_currentLineHighlight, gridBagConstraints);
            this.m_bracketHighlight = new JCheckBox("Bracket highlighting", ProgramTextArea.getTheBracketHighlight());
            jPanel.add((Component)this.m_bracketHighlight, gridBagConstraints);
            this.m_syntaxHighlight = new JCheckBox("Highlight syntax tokens", ProgramTextArea.getSyntaxHighlight());
            jPanel.add((Component)this.m_syntaxHighlight, gridBagConstraints);
            this.m_blinkingCaret = new JCheckBox("Blinking Caret", ProgramTextArea.getBlinkingCaret());
            jPanel.add((Component)this.m_blinkingCaret, gridBagConstraints);
            this.m_electricBorders = new JCheckBox("Electric (auto scroll) borders", ProgramTextArea.getTheElectricBorders());
            jPanel.add((Component)this.m_electricBorders, gridBagConstraints);
            jPanel.setBorder(BorderFactory.createTitledBorder("Editor Options"));
            this.m_currentLineHighlight.addChangeListener(JASOptionsDialog.this);
            this.m_bracketHighlight.addChangeListener(JASOptionsDialog.this);
            this.m_syntaxHighlight.addChangeListener(JASOptionsDialog.this);
            this.m_blinkingCaret.addChangeListener(JASOptionsDialog.this);
            this.m_electricBorders.addChangeListener(JASOptionsDialog.this);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.insets.bottom = 5;
            gridBagConstraints2.insets.top = 5;
            gridBagConstraints2.insets.right = 5;
            gridBagConstraints2.insets.left = 5;
            jPanel3.add((Component)new JLabel("String Color"), gridBagConstraints2);
            jPanel3.add((Component)new JLabel("Keyword Color"), gridBagConstraints2);
            jPanel3.add((Component)new JLabel("Comment Color"), gridBagConstraints2);
            jPanel3.add((Component)new JLabel("Number Color"), gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets.bottom = 0;
            gridBagConstraints2.insets.top = 0;
            gridBagConstraints2.insets.right = 0;
            gridBagConstraints2.insets.left = 0;
            this.m_string = new ColorChooser(ProgramTextArea.getStringColor());
            jPanel3.add((Component)this.m_string, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            this.m_keyword = new ColorChooser(ProgramTextArea.getKeywordColor());
            jPanel3.add((Component)this.m_keyword, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            this.m_comment = new ColorChooser(ProgramTextArea.getCommentColor());
            jPanel3.add((Component)this.m_comment, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            this.m_number = new ColorChooser(ProgramTextArea.getNumberColor());
            jPanel3.add((Component)this.m_number, gridBagConstraints2);
            jPanel3.setBorder(BorderFactory.createTitledBorder("Syntax Colors"));
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.insets.bottom = 5;
            gridBagConstraints3.insets.top = 5;
            gridBagConstraints3.insets.right = 5;
            gridBagConstraints3.insets.left = 5;
            jPanel4.add((Component)new JLabel("Line Highlight Color"), gridBagConstraints3);
            jPanel4.add((Component)new JLabel("Bracket Highlight Color"), gridBagConstraints3);
            jPanel4.add((Component)new JLabel("Foreground Color"), gridBagConstraints3);
            jPanel4.add((Component)new JLabel("Background Color"), gridBagConstraints3);
            jPanel4.add((Component)new JLabel("Caret Color"), gridBagConstraints3);
            jPanel4.add((Component)new JLabel("Selection Color"), gridBagConstraints3);
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets.bottom = 0;
            gridBagConstraints3.insets.top = 0;
            gridBagConstraints3.insets.right = 0;
            gridBagConstraints3.insets.left = 0;
            this.m_line = new ColorChooser(ProgramTextArea.getLineColor());
            jPanel4.add((Component)this.m_line, gridBagConstraints3);
            ++gridBagConstraints3.gridy;
            this.m_bracket = new ColorChooser(ProgramTextArea.getBracketColor());
            jPanel4.add((Component)this.m_bracket, gridBagConstraints3);
            ++gridBagConstraints3.gridy;
            this.m_foreground = new ColorChooser(ProgramTextArea.getForegroundColor());
            jPanel4.add((Component)this.m_foreground, gridBagConstraints3);
            ++gridBagConstraints3.gridy;
            this.m_background = new ColorChooser(ProgramTextArea.getBackgroundColor());
            jPanel4.add((Component)this.m_background, gridBagConstraints3);
            ++gridBagConstraints3.gridy;
            this.m_caret = new ColorChooser(ProgramTextArea.getTheCaretColor());
            jPanel4.add((Component)this.m_caret, gridBagConstraints3);
            ++gridBagConstraints3.gridy;
            this.m_selection = new ColorChooser(ProgramTextArea.getTheSelectionColor());
            jPanel4.add((Component)this.m_selection, gridBagConstraints3);
            jPanel4.setBorder(BorderFactory.createTitledBorder("Editor Colors"));
            this.m_string.addColorListener(JASOptionsDialog.this);
            this.m_keyword.addColorListener(JASOptionsDialog.this);
            this.m_comment.addColorListener(JASOptionsDialog.this);
            this.m_number.addColorListener(JASOptionsDialog.this);
            this.m_line.addColorListener(JASOptionsDialog.this);
            this.m_bracket.addColorListener(JASOptionsDialog.this);
            this.m_foreground.addColorListener(JASOptionsDialog.this);
            this.m_background.addColorListener(JASOptionsDialog.this);
            this.m_caret.addColorListener(JASOptionsDialog.this);
            this.m_selection.addColorListener(JASOptionsDialog.this);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets.bottom = 10;
            gridBagConstraints2.insets.top = 10;
            gridBagConstraints2.insets.right = 10;
            gridBagConstraints2.insets.left = 10;
            gridBagConstraints2.fill = 1;
            this.m_fontChooser.setBorder(BorderFactory.createTitledBorder("Display Font"));
            this.add((Component)this.m_fontChooser, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            this.add((Component)jPanel, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            gridBagConstraints2.gridy = 0;
            this.add((Component)jPanel3, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            this.add((Component)jPanel4, gridBagConstraints2);
        }

        String getHelpTopic() {
            return "userInterface.optionsDialog.sourceCodeStyle";
        }

        public boolean inputIsValid() {
            try {
                float f;
                String string = this.m_tabSize.getText();
                this.m_tabSizeValue = Float.valueOf(string).floatValue();
                if ((double)f < 0.0) {
                    throw new NumberFormatException(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid tab size value: " + numberFormatException.getMessage(), "Tab size error", 0);
                return false;
            }
            return this.m_fontChooser.inputIsValid();
        }

        void apply() {
            Font font = this.m_fontChooser.getSpecifiedFont();
            ProgramTextArea.setFontStyle(font.getStyle());
            ProgramTextArea.setFontSize(font.getSize());
            ProgramPage.setTabSize(new Integer(this.m_tabSize.getText().toString()));
            ProgramPage.updateInstanceFonts();
            ProgramTextArea.setKeywordColor(this.m_keyword.getColor());
            ProgramTextArea.setCommentColor(this.m_comment.getColor());
            ProgramTextArea.setStringColor(this.m_string.getColor());
            ProgramTextArea.setNumberColor(this.m_number.getColor());
            ProgramTextArea.setLineColor(this.m_line.getColor());
            ProgramTextArea.setBracketColor(this.m_bracket.getColor());
            ProgramTextArea.setForegroundColor(this.m_foreground.getColor());
            ProgramTextArea.setBackgroundColor(this.m_background.getColor());
            ProgramTextArea.setTheCaretColor(this.m_caret.getColor());
            ProgramTextArea.setTheSelectionColor(this.m_selection.getColor());
            ProgramTextArea.setCurrentLineHighlight(this.m_currentLineHighlight.isSelected());
            ProgramTextArea.setTheBracketHighlight(this.m_bracketHighlight.isSelected());
            ProgramTextArea.setSyntaxHighlight(this.m_syntaxHighlight.isSelected());
            ProgramTextArea.setBlinkingCaret(this.m_blinkingCaret.isSelected());
            ProgramTextArea.setTheElectricBorders(this.m_electricBorders.isSelected());
            ProgramPage.updateInstanceStyles();
        }
    }

    private final class Backup
    extends OptionsPage
    implements MustTestInput {
        private JASTextField m_backupTimeField;
        private JASTextField m_dirField;
        private JCheckBox m_doBackupsBox;
        private int m_backupInterval;

        Backup() {
            super(null);
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel(new FlowLayout(0));
            JLabel jLabel = new JLabel("Select the directory for timed backups ");
            jPanel.add(jLabel);
            this.m_dirField = new JASTextField(ProgramPage.getBackupDirectory(), 15);
            jPanel.add(this.m_dirField);
            this.m_dirField.addKeyListener(JASOptionsDialog.this);
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            int n = ProgramPage.getBackupInterval();
            float f = (float)n / 60000.0f;
            String string = String.valueOf(f);
            this.m_backupTimeField = new JASTextField(string, 10);
            this.m_backupTimeField.addKeyListener(JASOptionsDialog.this);
            JLabel jLabel2 = new JLabel("Set timing interval in minutes: ");
            jPanel2.add(jLabel2);
            jPanel2.add(this.m_backupTimeField);
            this.m_doBackupsBox = new JCheckBox("Do timed backups of text pages", ProgramPage.timerIsRunning());
            this.m_doBackupsBox.addActionListener(new ActionListener(this, jLabel, jLabel2){
                private final /* synthetic */ JLabel val$dirLabel;
                private final /* synthetic */ JLabel val$timingLabel;
                private final /* synthetic */ Backup this$1;
                {
                    this.this$1 = backup;
                    this.val$dirLabel = jLabel;
                    this.val$timingLabel = jLabel2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Backup.access$800(this.this$1).setChanged();
                    boolean bl = Backup.access$900(this.this$1).isSelected();
                    this.val$dirLabel.setEnabled(bl);
                    this.val$dirLabel.repaint();
                    this.val$timingLabel.setEnabled(bl);
                    this.val$timingLabel.repaint();
                    Backup.access$1000(this.this$1).setEnabled(bl);
                    Backup.access$1000(this.this$1).repaint();
                    Backup.access$1100(this.this$1).setEnabled(bl);
                    Backup.access$1100(this.this$1).repaint();
                }
            });
            if (!this.m_doBackupsBox.isSelected()) {
                jLabel.setEnabled(false);
                jLabel2.setEnabled(false);
                this.m_backupTimeField.setEnabled(false);
                this.m_dirField.setEnabled(false);
            }
            this.add(this.m_doBackupsBox);
            this.add(jPanel2);
            this.add(jPanel);
        }

        public boolean inputIsValid() {
            if (this.m_doBackupsBox.isSelected()) {
                String string = this.m_dirField.getText();
                if (!this.isValidDirectory(string)) {
                    JOptionPane.showMessageDialog(this, string.concat(" is not a valid directory."), "Directory not found", 0);
                    return false;
                }
                String string2 = this.m_backupTimeField.getText();
                try {
                    this.m_backupInterval = (int)(Float.valueOf(string2).floatValue() * 60000.0f);
                    if (this.m_backupInterval <= 0) {
                        JOptionPane.showMessageDialog(this, "Backup time must be positive.", "Negative Backup Time", 0);
                    }
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, string2.concat(" is not a valid number."), "Number Format Exception", 0);
                    return false;
                }
            }
            return true;
        }

        private boolean isValidDirectory(String string) {
            try {
                return new File(string).isDirectory();
            }
            catch (Exception exception) {
                return false;
            }
        }

        String getHelpTopic() {
            return "jobs.eventAnalysisAndGeneration.timedBackup";
        }

        void apply() {
            boolean bl = this.m_doBackupsBox.isSelected();
            if (bl) {
                String string = this.m_dirField.getText();
                ProgramPage.setBackupInterval(this.m_backupInterval);
                ProgramPage.setBackupDirectory(string);
            }
            ProgramPage.setTimerIsRunning(bl);
        }

        static /* synthetic */ JASOptionsDialog access$800(Backup backup) {
            return backup.JASOptionsDialog.this;
        }

        static /* synthetic */ JCheckBox access$900(Backup backup) {
            return backup.m_doBackupsBox;
        }

        static /* synthetic */ JASTextField access$1000(Backup backup) {
            return backup.m_backupTimeField;
        }

        static /* synthetic */ JASTextField access$1100(Backup backup) {
            return backup.m_dirField;
        }
    }

    private final class Compiler
    extends OptionsPage {
        private JCheckBox m_compilerToggle;
        private JASEditableComboBox m_compilerChoice;

        Compiler() {
            super(new GridBagLayout());
            boolean bl = JASOptionsDialog.this.m_app.getUserProperties().getBoolean("UseBuiltInCompiler", true);
            this.m_compilerToggle = new JCheckBox(this, "Use Built-in compiler", bl){
                private final /* synthetic */ Compiler this$1;
                {
                    this.this$1 = compiler;
                }

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    Compiler.access$700(this.this$1).setEnabled(!Compiler.access$600(this.this$1).isSelected());
                }
            };
            this.m_compilerToggle.addChangeListener(JASOptionsDialog.this);
            this.m_compilerChoice = new JASEditableComboBox("recentCompilers", 4, true);
            this.m_compilerChoice.setEnabled(!bl);
            this.m_compilerChoice.setText(JASOptionsDialog.this.m_app.getUserProperties().getString("Compiler", "javac"));
            this.m_compilerChoice.addChangeListener(JASOptionsDialog.this);
            this.m_compilerChoice.setMinWidth(200);
            this.m_compilerChoice.setMaxWidth(300);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            this.add((Component)this.m_compilerToggle, gridBagConstraints);
            this.add((Component)new JLabel("Java Compiler Command:"), gridBagConstraints);
            this.add((Component)this.m_compilerChoice, gridBagConstraints);
        }

        void apply() {
            JASOptionsDialog.this.m_app.getUserProperties().setBoolean("UseBuiltInCompiler", this.m_compilerToggle.isSelected());
            JASOptionsDialog.this.m_app.getUserProperties().setString("Compiler", this.m_compilerChoice.getText());
            this.m_compilerChoice.saveState();
        }

        String getHelpTopic() {
            return "jobs.eventAnalysisAndGeneration.compiling";
        }

        static /* synthetic */ JCheckBox access$600(Compiler compiler) {
            return compiler.m_compilerToggle;
        }

        static /* synthetic */ JASEditableComboBox access$700(Compiler compiler) {
            return compiler.m_compilerChoice;
        }
    }

    private final class Defaults
    extends OptionsPage
    implements MustTestInput {
        private final JCheckBox m_lastJob;
        private final JCheckBox m_fullPathForJobs;
        private final JCheckBox m_fullPathForFiles;
        private final JTextField m_jobsListLength;
        private final JTextField m_fileListLength;
        private final JTextField m_classListLength;
        private FitterFactory m_defaultFitterFactory;
        private boolean m_defaultFitterFactorySet = false;

        Defaults() {
            super(new GridBagLayout());
            ActionListener actionListener;
            this.m_lastJob = new JCheckBox("Open last job at startup", JASOptionsDialog.this.m_app.getUserProperties().getBoolean("OpenLastJobAtStartup", false));
            this.m_lastJob.setMnemonic('l');
            this.m_lastJob.addChangeListener(JASOptionsDialog.this);
            JButton jButton = new JButton("Open last job now");
            jButton.setMnemonic('w');
            String[] stringArray = JASOptionsDialog.this.m_app.getLastJobs();
            if (stringArray != null && stringArray.length > 0) {
                jButton.addActionListener(new ActionListener(this, jButton){
                    private final /* synthetic */ JButton val$openNow;
                    private final /* synthetic */ Defaults this$1;
                    {
                        this.this$1 = defaults;
                        this.val$openNow = jButton;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Defaults.access$300((Defaults)this.this$1).m_app.openLastJob();
                        this.val$openNow.setEnabled(false);
                    }
                });
                actionListener = JASOptionsDialog.this.m_app.getJob();
                jButton.setEnabled(actionListener == null || !stringArray[0].equals(((JASJob)actionListener).getFilePath()));
            }
            actionListener = new JComboBox();
            Enumeration enumeration = FitterRegistry.instance().elements();
            while (enumeration.hasMoreElements()) {
                ((JComboBox)actionListener).addItem(enumeration.nextElement());
            }
            ((JComboBox)actionListener).addItemListener(new ItemListener(this){
                private final /* synthetic */ Defaults this$1;
                {
                    this.this$1 = defaults;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    FitterFactory fitterFactory = (FitterFactory)itemEvent.getItem();
                    if (fitterFactory != Defaults.access$400(this.this$1)) {
                        Defaults.access$402(this.this$1, fitterFactory);
                        Defaults.access$502(this.this$1, true);
                        Defaults.access$300(this.this$1).setChanged();
                    }
                }
            });
            this.m_fullPathForJobs = new JCheckBox("Show directory for recent jobs", JASOptionsDialog.this.m_prop.getBoolean("InclPath-Jobs", true));
            this.m_fullPathForJobs.setMnemonic('j');
            this.m_fullPathForJobs.addChangeListener(JASOptionsDialog.this);
            this.m_fullPathForFiles = new JCheckBox("Show directory in recent files", JASOptionsDialog.this.m_prop.getBoolean("InclPath-Files", true));
            this.m_fullPathForFiles.setMnemonic('f');
            this.m_fullPathForFiles.addChangeListener(JASOptionsDialog.this);
            this.m_jobsListLength = new JTextField(JASOptionsDialog.this.m_prop.getString("MaxJobsListLength", "4"), 5);
            this.m_jobsListLength.addKeyListener(JASOptionsDialog.this);
            this.m_fileListLength = new JTextField(JASOptionsDialog.this.m_prop.getString("MaxFileListLength", "4"), 5);
            this.m_fileListLength.addKeyListener(JASOptionsDialog.this);
            this.m_classListLength = new JTextField(JASOptionsDialog.this.m_prop.getString("MaxClassesLength", "4"), 5);
            this.m_classListLength.addKeyListener(JASOptionsDialog.this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            this.add((Component)this.m_lastJob, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)jButton, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)new JLabel("Default fitter: "), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)((Object)actionListener), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            this.add((Component)this.m_fullPathForJobs, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)new JLabel("Length of recent jobs list: "), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.add((Component)this.m_jobsListLength, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            this.add((Component)this.m_fullPathForFiles, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)new JLabel("Length of recent file list: "), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.add((Component)this.m_fileListLength, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            this.add((Component)new JLabel("Length of recent class list: "), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.add((Component)this.m_classListLength, gridBagConstraints);
            this.setBorder(BorderFactory.createTitledBorder("Miscellaneous defaults"));
        }

        public boolean inputIsValid() {
            try {
                if (Integer.parseInt(this.m_jobsListLength.getText()) < 0 || Integer.parseInt(this.m_classListLength.getText()) < 0 || Integer.parseInt(this.m_fileListLength.getText()) < 0) {
                    JASOptionsDialog.this.m_app.error("Cannot have negative list length.");
                    return false;
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                JASOptionsDialog.this.m_app.error("Could not format number: ".concat(numberFormatException.getMessage()));
                return false;
            }
        }

        void apply() {
            JASOptionsDialog.this.m_app.getUserProperties().setBoolean("OpenLastJobAtStartup", this.m_lastJob.isSelected());
            if (this.m_defaultFitterFactorySet) {
                FitterRegistry.instance().setDefaultFitterFactory(this.m_defaultFitterFactory);
            }
            JASOptionsDialog.this.m_prop.setBoolean("InclPath-Files", this.m_fullPathForFiles.isSelected());
            JASOptionsDialog.this.m_prop.setBoolean("InclPath-Jobs", this.m_fullPathForJobs.isSelected());
            JASOptionsDialog.this.m_prop.setString("MaxJobsListLength", this.m_jobsListLength.getText());
            JASOptionsDialog.this.m_prop.setString("MaxFileListLength", this.m_fileListLength.getText());
            JASOptionsDialog.this.m_prop.setString("MaxClassesLength", this.m_classListLength.getText());
        }

        String getHelpTopic() {
            return "userInterface.optionsDialog.defaultsTab";
        }

        static /* synthetic */ JASOptionsDialog access$300(Defaults defaults) {
            return defaults.JASOptionsDialog.this;
        }

        static /* synthetic */ FitterFactory access$400(Defaults defaults) {
            return defaults.m_defaultFitterFactory;
        }

        static /* synthetic */ FitterFactory access$402(Defaults defaults, FitterFactory fitterFactory) {
            defaults.m_defaultFitterFactory = fitterFactory;
            return defaults.m_defaultFitterFactory;
        }

        static /* synthetic */ boolean access$502(Defaults defaults, boolean bl) {
            defaults.m_defaultFitterFactorySet = bl;
            return defaults.m_defaultFitterFactorySet;
        }
    }

    private final class SourcePath
    extends OptionsPage {
        private JASSourcePath path = JASSourcePath.create();
        private boolean enable = this.path.isEnabled();
        private JASAddRemovePanel panel;

        SourcePath() {
            super(new BorderLayout());
            JCheckBox jCheckBox = new JCheckBox("Use Class Path as Source Path", !this.enable);
            this.add((Component)jCheckBox, "North");
            jCheckBox.addActionListener(new ActionListener(this, jCheckBox){
                private final /* synthetic */ JCheckBox val$disable;
                private final /* synthetic */ SourcePath this$1;
                {
                    this.this$1 = sourcePath;
                    this.val$disable = jCheckBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SourcePath.access$002(this.this$1, !this.val$disable.isSelected());
                    SourcePath.access$100(this.this$1).setEnabled(SourcePath.access$000(this.this$1));
                    SourcePath.access$200(this.this$1).setChanged();
                }
            });
            this.panel = new SourcePathPanel(this.path);
            this.panel.addListDataListener(JASOptionsDialog.this);
            this.panel.setEnabled(this.path.isEnabled());
            this.add((Component)this.panel, "Center");
        }

        void apply() {
            this.path.setEnabled(this.enable);
            if (this.enable) {
                this.panel.update();
            }
        }

        String getHelpTopic() {
            return "userInterface.optionsDialog.sourcePath";
        }

        static /* synthetic */ boolean access$002(SourcePath sourcePath, boolean bl) {
            sourcePath.enable = bl;
            return sourcePath.enable;
        }

        static /* synthetic */ boolean access$000(SourcePath sourcePath) {
            return sourcePath.enable;
        }

        static /* synthetic */ JASAddRemovePanel access$100(SourcePath sourcePath) {
            return sourcePath.panel;
        }

        static /* synthetic */ JASOptionsDialog access$200(SourcePath sourcePath) {
            return sourcePath.JASOptionsDialog.this;
        }
    }

    private final class ClassPath
    extends OptionsPage {
        private JASAddRemovePanel panel = new ClassPathPanel(JASClassPath.create());

        ClassPath() {
            super(new BorderLayout());
            this.panel.addListDataListener(JASOptionsDialog.this);
            this.add("Center", this.panel);
        }

        void apply() {
            this.panel.update();
        }

        String getHelpTopic() {
            return "functionsAndFilters.registries";
        }
    }
}

