/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.HasCommandProcessor;
import jas.swingstudio.JASCommandProcessor;
import jas.swingstudio.JASConsoleDocumentUtilities;
import jas.swingstudio.JASConsoleScrollPane;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.CommandProcessor;
import jas.util.JASCheckboxState;
import jas.util.JASState;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class JASConsoleTextArea
extends JTextArea
implements HasCommandProcessor {
    protected String lineSeparator = System.getProperty("line.separator");
    private boolean logFileOpened;
    private boolean loggingOn;
    private JPopupMenu theJASConsoleTabbedPanePopupMenu;
    private FileWriter logOutput;
    private JASConsoleTextAreaCommandProcessor commandProcessor;
    private JASConsoleScrollPane theScrollPane;

    public JASConsoleTextArea(JASConsoleScrollPane jASConsoleScrollPane) {
        this.theScrollPane = jASConsoleScrollPane;
        this.loggingOn = false;
        this.logFileOpened = false;
        this.commandProcessor = new JASConsoleTextAreaCommandProcessor();
        this.theJASConsoleTabbedPanePopupMenu = JavaAnalysisStudio.getApp().getXMLMenuBuilder().getPopupMenu("consolePopupMenu");
        this.enableEvents(16L);
    }

    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    protected JASConsoleTextArea getJASConsoleTextArea() {
        return this;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.commandProcessor.forceSetChanged();
            this.theJASConsoleTabbedPanePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public boolean isLogFileOpened() {
        return this.logFileOpened;
    }

    public void setLogFileOpened(boolean bl) {
        this.logFileOpened = bl;
    }

    public boolean isLoggingOn() {
        return this.loggingOn;
    }

    public void setLoggingOn(boolean bl) {
        this.loggingOn = bl;
    }

    public void forceCommandProcessorSetChanged() {
        this.commandProcessor.forceSetChanged();
    }

    public FileWriter getLogWriter() {
        return this.logOutput;
    }

    private class JASConsoleTextAreaCommandProcessor
    extends JASCommandProcessor {
        public void forceSetChanged() {
            this.setChanged();
        }

        public void onCopyConsoleSelection() {
            JASConsoleTextArea.this.copy();
        }

        public void enableCopyConsoleSelection(JASState jASState) {
            jASState.setEnabled(JASConsoleTextArea.this.getJASConsoleTextArea().getSelectedText() != null);
        }

        public void onClear() {
            JASConsoleDocumentUtilities.clearDoc(JASConsoleTextArea.this.getDocument());
        }

        public void enableClear(JASState jASState) {
            jASState.setEnabled(JASConsoleTextArea.this.getDocument().getLength() > 0);
        }

        public void onSelectAll() {
            JASConsoleTextArea.this.selectAll();
        }

        public void enableSelectAll(JASState jASState) {
            jASState.setEnabled(JASConsoleTextArea.this.getDocument().getLength() > 0);
        }

        public void onSetBufferSize() {
        }

        public void enableSetBufferSize(JASState jASState) {
            jASState.setEnabled(false);
        }

        public void onCloseTab() {
            if (JASConsoleTextArea.this.isLoggingOn()) {
                JASConsoleTextArea.this.setLogFileOpened(false);
                JASConsoleTextArea.this.setLoggingOn(false);
            }
            JASConsoleTextArea.this.theScrollPane.removeTab();
        }

        public void enableCloseTab(JASState jASState) {
            jASState.setEnabled(true);
        }

        public void onOpenLogFile() {
            JFileChooser jFileChooser = new JFileChooser(JavaAnalysisStudio.getApp().getUserProperties().getString("LastProgramPath", System.getProperty("user.home")));
            jFileChooser.setDialogTitle("Open or Create Log File...");
            int n = jFileChooser.showOpenDialog(JASConsoleTextArea.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                boolean bl = false;
                if (file.exists()) {
                    if (!file.canWrite()) {
                        JavaAnalysisStudio.getApp().error("Cannot write to the file " + file);
                        bl = true;
                    } else if (!file.delete()) {
                        JavaAnalysisStudio.getApp().error("Could not overwrite the file " + file);
                        bl = true;
                    }
                }
                if (!bl) {
                    try {
                        JASConsoleTextArea.this.logOutput = new FileWriter(file);
                        JASConsoleTextArea.this.logOutput.write("Log file created on " + new Date() + JASConsoleTextArea.this.lineSeparator);
                        JASConsoleTextArea.this.logOutput.flush();
                        JASConsoleTextArea.this.setLogFileOpened(true);
                    }
                    catch (IOException iOException) {
                        JavaAnalysisStudio.getApp().error("Couldn't write to " + file.getName());
                    }
                }
            }
            if (!JASConsoleTextArea.this.isLoggingOn()) {
                this.onEnableLogging(true);
            }
        }

        public void enableOpenLogFile(JASState jASState) {
            jASState.setEnabled(!JASConsoleTextArea.this.isLogFileOpened());
        }

        public void onEnableLogging(boolean bl) {
            JASConsoleTextArea.this.setLoggingOn(bl);
            this.setChanged();
        }

        public void enableEnableLogging(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASConsoleTextArea.this.isLoggingOn());
            jASCheckboxState.setEnabled(JASConsoleTextArea.this.isLogFileOpened());
        }

        public void onCloseLogFile() {
            try {
                JASConsoleTextArea.this.logOutput.write("Log file closed on " + new Date() + JASConsoleTextArea.this.lineSeparator);
                JASConsoleTextArea.this.logOutput.flush();
                JASConsoleTextArea.this.logOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JASConsoleTextArea.this.setLogFileOpened(false);
            JASConsoleTextArea.this.setLoggingOn(false);
        }

        public void enableCloseLogFile(JASState jASState) {
            jASState.setEnabled(JASConsoleTextArea.this.isLogFileOpened());
        }
    }
}

