/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.HasCommandProcessor;
import jas.swingstudio.JASConsoleDocumentOutputStream;
import jas.swingstudio.JASConsoleScrollPane;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.Application;
import jas.util.CommandTargetManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.JTabbedPane;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class JASConsoleTabbedPane
extends JTabbedPane {
    private HasCommandProcessor prevSelected;
    private Hashtable outputStreams = new Hashtable();

    public JASConsoleTabbedPane() {
        this.init();
    }

    public JASConsoleTabbedPane(int n) {
        super(n);
        this.init();
    }

    public JASConsoleScrollPane getSelectedConsoleScrollPane() {
        return (JASConsoleScrollPane)this.getSelectedComponent();
    }

    public void addTab(String string, Component component) {
        super.addTab(string, component);
        JavaAnalysisStudio.getApp().showJASConsole();
    }

    public void remove(Component component) {
        super.remove(component);
        if (this.getTabCount() == 0) {
            JavaAnalysisStudio.getApp().hideJASConsole();
        } else {
            this.setCorrectCommandProcessor();
        }
    }

    public OutputStream getOutputStream(String string) {
        OutputStream outputStream = (OutputStream)this.outputStreams.get(string);
        if (outputStream != null) {
            return outputStream;
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, new Color(58, 106, 122));
        PlainDocument plainDocument = new PlainDocument();
        outputStream = new JASConsoleDocumentOutputStream(plainDocument, simpleAttributeSet, string, this);
        this.outputStreams.put(string, outputStream);
        return outputStream;
    }

    private void setCorrectCommandProcessor() {
        CommandTargetManager commandTargetManager = Application.getApplication().getCommandManager();
        Component component = this.getSelectedComponent();
        if (component == this.prevSelected) {
            return;
        }
        if (this.prevSelected != null) {
            commandTargetManager.remove(this.prevSelected.getCommandProcessor());
        }
        if (component instanceof HasCommandProcessor) {
            this.prevSelected = (HasCommandProcessor)((Object)component);
            commandTargetManager.add(this.prevSelected.getCommandProcessor());
        } else {
            this.prevSelected = null;
        }
    }

    protected void fireStateChanged() {
        super.fireStateChanged();
        this.setCorrectCommandProcessor();
    }

    private void init() {
        this.setMinimumSize(new Dimension(0, 0));
    }
}

