/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.plugin.PageContext;
import jas.plugin.PageEvent;
import jas.plugin.PageListener;
import jas.swingstudio.Closable;
import jas.swingstudio.FullScreenWindow;
import jas.swingstudio.HasCommandProcessor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.PageListenerInfo;
import jas.swingstudio.WindowItem;
import jas.swingstudio.WindowManager;
import jas.util.xml.XMLWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

final class InternalFramesWindowManager
extends JDesktopPane
implements WindowManager,
InternalFrameListener {
    private boolean m_changed = false;
    private Vector m_frames;
    private Vector m_listeners;
    private DesktopManager m_desktopManager;
    private int m_nCascaded = 0;
    private boolean init = false;
    private final int m_xCascadeOffset = 20;
    private final int m_yCascadeOffset = 20;
    private final float m_xCascadeFraction = 0.75f;
    private final float m_yCascadeFraction = 0.75f;
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    static final int CASCADE = -3;
    static final int TILE_HORIZONTALLY = -4;
    static final int TILE_VERTICALLY = -5;

    InternalFramesWindowManager() {
        this.m_desktopManager = this.getDesktopManager();
        this.m_frames = new Vector();
        this.putClientProperty("JDesktopPane.dragMode", "faster");
    }

    public void newWindow(String string, Component component) {
        JInternalFrame jInternalFrame = new JInternalFrame(string, true, true, true, true);
        jInternalFrame.setDefaultCloseOperation(0);
        this.m_frames.addElement(jInternalFrame);
        jInternalFrame.setContentPane((Container)component);
        this.add(jInternalFrame);
        if (this.init) {
            this.cascadeFrame(jInternalFrame);
        }
        jInternalFrame.addInternalFrameListener(this);
        jInternalFrame.show();
        this.m_changed = true;
    }

    private void cascadeFrame(JInternalFrame jInternalFrame) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = new Dimension();
        dimension2.height = (int)((float)dimension.height * 0.75f);
        dimension2.width = (int)((float)dimension.width * 0.75f);
        Point point = new Point();
        point.translate(this.m_nCascaded * 20, this.m_nCascaded * 20);
        jInternalFrame.setLocation(point);
        jInternalFrame.setPreferredSize(dimension2);
        jInternalFrame.setSize(dimension2);
        ++this.m_nCascaded;
    }

    public void doLayout() {
        super.doLayout();
        if (!this.init) {
            this.arrange(-3);
            this.init = true;
        }
    }

    void arrange(int n) {
        this.m_nCascaded = 0;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (n == -3) {
            int n2 = jInternalFrameArray.length - 1;
            while (n2 >= 0) {
                JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                if (!jInternalFrame.isIcon()) {
                    try {
                        jInternalFrameArray[n2].setMaximum(false);
                        this.cascadeFrame(jInternalFrame);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                --n2;
            }
        } else {
            int n3;
            int n4 = n3 = this.getWindowCount();
            int n5 = 0;
            while (n5 < n3) {
                if (jInternalFrameArray[n5].isIcon()) {
                    --n4;
                } else {
                    try {
                        jInternalFrameArray[n5].setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        --n4;
                    }
                }
                ++n5;
            }
            int n6 = (int)Math.sqrt(n4);
            if (n6 < 1) {
                return;
            }
            int n7 = this.getSize().width;
            int n8 = this.getSize().height;
            boolean bl = n == -4;
            int n9 = bl ? n7 / n6 : 0;
            int n10 = bl ? 0 : n8 / n6;
            int n11 = 0;
            Dimension dimension = new Dimension();
            Point point = new Point();
            int n12 = 0;
            int n13 = 0;
            if (bl) {
                dimension.width = n7 / n6;
            } else {
                dimension.height = n8 / n6;
            }
            int n14 = 0;
            while (n14 < n6) {
                point.setLocation(0, 0);
                point.translate(n14 * n9, n14 * n10);
                int n15 = n4 / (n6 - n14);
                n4 -= n15;
                if (bl) {
                    n13 = dimension.height = n8 / n15;
                } else {
                    n12 = dimension.width = n7 / n15;
                }
                int n16 = 0;
                while (true) {
                    JInternalFrame jInternalFrame;
                    if ((jInternalFrame = jInternalFrameArray[n11++]).isIcon() || jInternalFrame.isMaximum()) {
                        continue;
                    }
                    jInternalFrame.setSize(new Dimension(dimension));
                    jInternalFrame.setLocation(new Point(point));
                    if (++n16 >= n15) break;
                    point.translate(n12, n13);
                }
                ++n14;
            }
        }
    }

    public void closeAllWindows() {
        int n = this.m_frames.size() - 1;
        while (n >= 0) {
            if (!this.closeWindow(n)) {
                return;
            }
            --n;
        }
        int n2 = this.m_frames.size();
        if (n2 == 0) {
            this.m_app.setNPages(0);
        }
    }

    public boolean closeWindow(int n) {
        return this.closeWindow((JInternalFrame)this.m_frames.elementAt(n));
    }

    private Component detachWindow(int n) {
        return this.detachWindow((JInternalFrame)this.m_frames.elementAt(n));
    }

    private Component detachWindow(JInternalFrame jInternalFrame) {
        Container container = jInternalFrame.getContentPane();
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            if (jInternalFrameArray[n] == jInternalFrame) {
                ((JLayeredPane)this).remove(n);
                this.m_frames.removeElement(jInternalFrame);
                this.checkRemoval(jInternalFrame);
                this.selectLastWindow();
                this.m_changed = true;
            }
            ++n;
        }
        return container;
    }

    public void doFullScreen() {
        int n = this.getSelectedWindow();
        final String string = this.getWindowName(n);
        final Component component = this.detachWindow(n);
        final FullScreenWindow fullScreenWindow = new FullScreenWindow(this.m_app.getFrame(), (JComponent)component);
        fullScreenWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                fullScreenWindow.dispose();
                InternalFramesWindowManager.this.newWindow(string, component);
                InternalFramesWindowManager.this.m_app.getFrame().repaint();
            }

            public void windowClosed(WindowEvent windowEvent) {
                InternalFramesWindowManager.this.newWindow(string, component);
                InternalFramesWindowManager.this.m_app.getFrame().repaint();
            }
        });
    }

    private boolean closeWindow(JInternalFrame jInternalFrame) {
        Container container = jInternalFrame.getContentPane();
        try {
            if (container instanceof Closable && !((Closable)((Object)container)).pleaseClose()) {
                return false;
            }
        }
        catch (Exception exception) {
            this.m_app.error("Error", exception);
            return false;
        }
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            if (jInternalFrameArray[n] == jInternalFrame) {
                this.firePageClosed(jInternalFrame.getContentPane());
                ((JLayeredPane)this).remove(n);
                this.m_frames.removeElement(jInternalFrame);
                this.checkRemoval(jInternalFrame);
                this.selectLastWindow();
                this.m_changed = true;
                this.repaint();
                return true;
            }
            ++n;
        }
        return true;
    }

    private void selectLastWindow() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (jInternalFrameArray.length > 0) {
            try {
                jInternalFrameArray[0].setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public Vector openPages(Class clazz) {
        Vector<Container> vector = new Vector<Container>();
        Enumeration enumeration = this.m_frames.elements();
        while (enumeration.hasMoreElements()) {
            JInternalFrame jInternalFrame = (JInternalFrame)enumeration.nextElement();
            Container container = jInternalFrame.getContentPane();
            if (clazz != null && !clazz.isInstance(container)) continue;
            vector.addElement(container);
        }
        return vector;
    }

    public WindowItem[] getItems() {
        int n = this.m_frames.size();
        WindowItem[] windowItemArray = new WindowItem[n];
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame jInternalFrame = this.elementAt(n2);
            windowItemArray[n2] = new WindowItem(jInternalFrame.getTitle(), jInternalFrame.getContentPane());
            ++n2;
        }
        return windowItemArray;
    }

    public void initialize(WindowItem[] windowItemArray, Vector vector) {
        this.m_listeners = vector;
        this.m_nCascaded = 0;
        ((Container)this).removeAll();
        this.m_frames.removeAllElements();
        int n = 0;
        int n2 = 0;
        while (n2 < windowItemArray.length) {
            String string = windowItemArray[n2].name;
            this.newWindow(string, windowItemArray[n2].Component);
            if (string.startsWith("Page ")) {
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < windowItemArray.length) {
            windowItemArray[n3].Component.setVisible(true);
            ++n3;
        }
        this.m_app.setNPages(n);
        this.m_changed = false;
    }

    public void selectWindow(int n) {
        this.m_desktopManager.activateFrame(this.elementAt(n));
        int n2 = this.getSelectedWindow();
        try {
            JInternalFrame jInternalFrame;
            if (n2 >= 0) {
                jInternalFrame = this.elementAt(n2);
                jInternalFrame.setSelected(false);
                this.m_desktopManager.deactivateFrame(jInternalFrame);
            }
            jInternalFrame = this.elementAt(n);
            jInternalFrame.setSelected(true);
            jInternalFrame.setIcon(false);
            jInternalFrame.moveToFront();
            this.m_changed = true;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public String getWindowName(int n) {
        return this.elementAt(n).getTitle();
    }

    public Component getWindow(int n) {
        return this.elementAt(n).getContentPane();
    }

    public int getWindowCount() {
        return this.m_frames.size();
    }

    public int getSelectedWindow() {
        int n = this.m_frames.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.elementAt(n2).isSelected()) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setCurrentTitle(String string) {
        int n = this.getSelectedWindow();
        if (n >= 0) {
            this.elementAt(n).setTitle(string);
        }
    }

    public void saveState(XMLWriter xMLWriter) {
        this.m_changed = false;
    }

    private JInternalFrame elementAt(int n) {
        return (JInternalFrame)this.m_frames.elementAt(n);
    }

    private void checkRemoval(JInternalFrame jInternalFrame) {
        if (this.m_frames.size() == 0) {
            this.m_app.setNPages(0);
            this.m_nCascaded = 0;
        }
    }

    public int find(Component component) {
        int n = this.getWindowCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getWindow(n2) == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void addPageListener(Component component, PageListener pageListener, PageContext pageContext) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector(4, 2);
        }
        this.m_listeners.addElement(new PageListenerInfo(component, pageListener, pageContext));
    }

    public void removePageListener(PageListener pageListener) {
        if (this.m_listeners != null) {
            int n = this.m_listeners.size();
            int n2 = 0;
            while (n2 < n) {
                PageListenerInfo pageListenerInfo = (PageListenerInfo)this.m_listeners.elementAt(n2);
                if (pageListenerInfo.listener == pageListener) {
                    this.m_listeners.removeElementAt(n2);
                    --n;
                    continue;
                }
                ++n2;
            }
        }
    }

    public void removeListenersForComponent(Component component) {
        if (this.m_listeners != null) {
            int n = this.m_listeners.size();
            int n2 = 0;
            while (n2 < n) {
                PageListenerInfo pageListenerInfo = (PageListenerInfo)this.m_listeners.elementAt(n2);
                if (pageListenerInfo.Component == component) {
                    this.m_listeners.removeElementAt(n2);
                    --n;
                    continue;
                }
                ++n2;
            }
        }
    }

    private void firePageClosed(Component component) {
        this.notifyListenersForComponent(component, 4001);
        this.removeListenersForComponent(component);
    }

    private void firePageSelected(Component component) {
        if (component instanceof Closable) {
            ((Closable)((Object)component)).pageSelected(true);
        }
        this.notifyListenersForComponent(component, 3999);
    }

    private void firePageDeselected(Component component) {
        if (component instanceof Closable) {
            ((Closable)((Object)component)).pageSelected(false);
        }
        this.notifyListenersForComponent(component, 4000);
    }

    private void firePageIconized(Component component) {
        this.notifyListenersForComponent(component, 4002);
    }

    private void firePageDeiconized(Component component) {
        this.notifyListenersForComponent(component, 4003);
    }

    private void notifyListenersForComponent(Component component, int n) {
        if (this.m_listeners != null) {
            Enumeration enumeration = this.m_listeners.elements();
            while (enumeration.hasMoreElements()) {
                PageListenerInfo pageListenerInfo = (PageListenerInfo)enumeration.nextElement();
                if (pageListenerInfo.Component != component) continue;
                pageListenerInfo.listener.pageChanged(new PageEvent(pageListenerInfo.context, n));
            }
        }
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        Container container = ((JInternalFrame)internalFrameEvent.getSource()).getContentPane();
        this.firePageSelected(container);
        if (container instanceof HasCommandProcessor) {
            this.m_app.getCommandManager().add(((HasCommandProcessor)((Object)container)).getCommandProcessor());
        }
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        Container container = ((JInternalFrame)internalFrameEvent.getSource()).getContentPane();
        this.firePageDeselected(container);
        if (container instanceof HasCommandProcessor) {
            this.m_app.getCommandManager().remove(((HasCommandProcessor)((Object)container)).getCommandProcessor());
        }
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        this.closeWindow((JInternalFrame)internalFrameEvent.getSource());
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        this.firePageDeiconized(((JInternalFrame)internalFrameEvent.getSource()).getContentPane());
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        this.firePageIconized(((JInternalFrame)internalFrameEvent.getSource()).getContentPane());
        this.selectLastWindow();
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public boolean windowListChanged() {
        return this.m_changed;
    }

    public Vector getPageListeners() {
        return this.m_listeners;
    }
}

