/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.jds.interfaces.CutInterface;
import jas.jds.interfaces.CutProperties;
import jas.swingstudio.JASJob;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.Job;
import jas.util.Application;
import jas.util.JASDialog;
import jas.util.JASState;
import java.awt.Frame;

abstract class CutDialog
extends JASDialog {
    private String m_name = null;
    private String m_constructor = null;
    private String m_description = null;
    private boolean m_isAdjustment;
    private CutInterface m_peer;
    private CutProperties m_initialProperties;

    CutDialog(boolean bl) {
        super((Frame)Application.getApplication().getFrame(), "Cut parameters", true, bl ? 15 : 13);
        if (bl) {
            this.setApplyLabel("Apply and run");
        }
        this.m_isAdjustment = bl;
    }

    protected abstract CutProperties getProperties();

    protected final void onApply() {
        if (this.setProperties()) {
            Job job = JavaAnalysisStudio.getApp().getJob().getJob();
            job.rewind();
            job.go(0);
        }
    }

    protected final void enableApply(JASState jASState) {
        JASJob jASJob = JavaAnalysisStudio.getApp().getJob();
        jASState.setEnabled(jASJob != null && jASJob.getJob().isRunnable());
    }

    protected final void onOK() {
        if (this.m_isAdjustment) {
            this.setProperties();
        } else {
            this.m_constructor = this.createConstructor(this.m_name);
            if (this.m_constructor == null) {
                return;
            }
            this.m_description = this.createDescription(this.m_name);
            if (this.m_description == null) {
                return;
            }
            super.onOK();
        }
    }

    private boolean setProperties() {
        CutProperties cutProperties = this.getProperties();
        if (cutProperties != null) {
            if (!cutProperties.equals(this.m_initialProperties)) {
                this.m_peer.setProperties(cutProperties);
            }
            super.onOK();
            return true;
        }
        return false;
    }

    void init(CutInterface cutInterface, CutProperties cutProperties) {
        this.m_initialProperties = cutProperties;
        this.m_peer = cutInterface;
    }

    void init(String string) {
        this.m_name = string;
    }

    String getConstructor() {
        return this.m_constructor;
    }

    String getDescription() {
        return this.m_description;
    }

    protected abstract String createConstructor(String var1);

    protected abstract String createDescription(String var1);
}

