/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.jds.interfaces.CutInterface;
import jas.jds.interfaces.CutProperties;
import jas.swingstudio.CutDialogPanel;
import jas.swingstudio.CutPropertiesDialog;
import jas.swingstudio.CutPropertiesPanel;
import jas.swingstudio.HasPlot;
import jas.swingstudio.HasSlider;
import jas.swingstudio.JASJob;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.Application;
import jas.util.JASDialog;
import jas.util.JASState;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public abstract class CutAdjustmentDialog
extends JASDialog
implements CutPropertiesDialog {
    private boolean m_changed = false;
    private CutPropertiesPanel m_panel;
    private CutInterface m_peer;
    private CutProperties m_oldProperties;
    final JCheckBox m_showPlot = new JCheckBox("Show plot", false);
    private final String m_auto_Key = "AutoRun";
    private final JCheckBox m_autoRun = new JCheckBox("Run job on change", Application.getApplication().getUserProperties().getBoolean("AutoRun", false));

    public CutAdjustmentDialog(CutInterface cutInterface, CutProperties cutProperties, CutPropertiesPanel cutPropertiesPanel) {
        super((Frame)Application.getApplication().getFrame(), "Cut parameters", false, 15);
        this.setApplyLabel("Apply and run");
        this.m_oldProperties = cutProperties;
        this.m_peer = cutInterface;
        this.m_panel = cutPropertiesPanel;
        final Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        cutPropertiesPanel.m_dialog = this;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        container.add((Component)cutPropertiesPanel, gridBagConstraints);
        JPanel jPanel = new JPanel(null);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.m_showPlot);
        JCheckBox jCheckBox = new JCheckBox("Show slider", false);
        jPanel.add(jCheckBox);
        jPanel.add(this.m_autoRun);
        jPanel.setBorder(new EtchedBorder());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        container.add((Component)jPanel, gridBagConstraints);
        boolean bl = cutProperties.m_hasPartition && this instanceof HasPlot;
        boolean bl2 = this instanceof HasSlider;
        this.m_showPlot.setEnabled(bl);
        jCheckBox.setEnabled(bl2);
        if (this instanceof HasPlot) {
            this.m_showPlot.addItemListener(new ItemListener(){
                private CutDialogPanel m_plot;
                private GridBagConstraints m_const;

                public void itemStateChanged(ItemEvent itemEvent) {
                    Point point = CutAdjustmentDialog.this.getLocation();
                    if (itemEvent.getStateChange() == 1) {
                        if (this.m_plot == null) {
                            this.m_plot = ((HasPlot)((Object)CutAdjustmentDialog.this)).getPlotPanel(CutAdjustmentDialog.this.m_peer);
                            this.m_plot.m_width = container.getSize().width;
                            this.m_const = new GridBagConstraints();
                            this.m_const.gridx = 0;
                            this.m_const.gridy = 0;
                            this.m_const.gridwidth = 2;
                            this.m_const.fill = 1;
                        }
                        if (!this.m_plot.beforeShowing()) {
                            return;
                        }
                        container.add((Component)this.m_plot, this.m_const);
                        CutAdjustmentDialog.this.defaultPack();
                        point.y -= this.m_plot.getSize().height;
                        if (point.y < 0) {
                            point.y = 0;
                        }
                    } else if (itemEvent.getStateChange() == 2) {
                        container.remove(this.m_plot);
                        CutAdjustmentDialog.this.defaultPack();
                        point.y += this.m_plot.getSize().height;
                        this.m_plot.afterClosing();
                    }
                    ((Component)CutAdjustmentDialog.this).setLocation(point);
                }
            });
        }
        if (bl2) {
            jCheckBox.addItemListener(new ItemListener(){
                private CutDialogPanel m_slider;
                private GridBagConstraints m_const;

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (this.m_slider == null) {
                            this.m_slider = ((HasSlider)((Object)CutAdjustmentDialog.this)).getSliderPanel(CutAdjustmentDialog.this.m_peer);
                            this.m_slider.m_width = container.getSize().width;
                            this.m_const = new GridBagConstraints();
                            this.m_const.gridx = 0;
                            this.m_const.gridy = 2;
                            this.m_const.gridwidth = 2;
                            this.m_const.fill = 1;
                        }
                        if (!this.m_slider.beforeShowing()) {
                            return;
                        }
                        container.add((Component)this.m_slider, this.m_const);
                    } else if (itemEvent.getStateChange() == 2) {
                        container.remove(this.m_slider);
                        this.m_slider.afterClosing();
                    }
                    CutAdjustmentDialog.this.defaultPack();
                }
            });
        }
        this.setResizable(false);
        this.pack();
    }

    public final void changeNotify(boolean bl) {
        if (bl && this.m_autoRun.isSelected()) {
            this.onApply();
        }
        this.m_changed = true;
        this.callEnable();
    }

    protected final void onApply() {
        if (this.setProperties()) {
            this.callEnable();
        }
    }

    protected final void enableApply(JASState jASState) {
        JASJob jASJob = JavaAnalysisStudio.getApp().getJob();
        jASState.setEnabled(this.m_changed && jASJob != null && jASJob.getJob().isRunnable());
    }

    protected final void enableOK(JASState jASState) {
        jASState.setEnabled(this.m_changed);
    }

    protected final void onOK() {
        if (this.setProperties()) {
            Application.getApplication().getUserProperties().setBoolean("AutoRun", this.m_autoRun.isSelected());
            super.onOK();
        }
    }

    protected final CutPropertiesPanel getPropertiesPanel() {
        return this.m_panel;
    }

    private boolean setProperties() {
        CutProperties cutProperties = this.m_panel.getProperties();
        if (cutProperties != null && !cutProperties.equals(this.m_oldProperties)) {
            this.m_oldProperties = cutProperties;
            this.m_changed = false;
            this.m_peer.setProperties(cutProperties);
            this.m_showPlot.setEnabled(cutProperties.m_hasPartition && this instanceof HasPlot);
            return true;
        }
        return false;
    }
}

