/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.ClassPathFileView;
import jas.swingstudio.ClassPathFilter;
import jas.swingstudio.ClassPathListCellRenderer;
import jas.swingstudio.JASAddRemovePanel;
import jas.swingstudio.UserClassPath;
import jas.util.Application;
import jas.util.gui.JDirectoryChooser;
import java.io.File;
import java.util.Hashtable;
import java.util.zip.ZipFile;

class ClassPathPanel
extends JASAddRemovePanel {
    ClassPathPanel(UserClassPath userClassPath) {
        super(userClassPath, "Look for class files in these directories:", "Class path", null, new ClassPathListCellRenderer());
    }

    protected Object add(String string) {
        Application application = Application.getApplication();
        String string2 = application.getUserProperties().getProperty("ClassPathPanel.dir");
        JDirectoryChooser jDirectoryChooser = new JDirectoryChooser(string2);
        jDirectoryChooser.setFileSelectionMode(2);
        jDirectoryChooser.setFileView(new ClassPathFileView());
        jDirectoryChooser.setFileFilter(new ClassPathFilter());
        jDirectoryChooser.setDialogTitle("Select Directory or Jar File");
        int n = jDirectoryChooser.showDialog(this);
        if (n != JDirectoryChooser.APPROVE_OPTION) {
            return null;
        }
        File file = jDirectoryChooser.getSelectedFile();
        ((Hashtable)application.getUserProperties()).put("ClassPathPanel.dir", file.toString());
        if (file.isDirectory()) {
            return file;
        }
        try {
            return new ZipFile(file);
        }
        catch (Exception exception) {
            application.error("Error Opening JAR file", exception);
            return null;
        }
    }
}

