/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.Axis;
import jas.plot.CoordinateTransformation;
import jas.plot.DataAreaLayout;
import jas.plot.EditableLabel;
import jas.plot.MovableObject;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PrintHelper;
import jas.plot.SetablePlotGraphics;
import jas.plot.java1.PlotGraphics11;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JComponent;

public class DataArea
extends MovableObject {
    private final Vector overlays = new Vector();
    public static final int PG2_NEVER = 0;
    public static final int PG2_PRINTING = 1;
    public static final int PG2_ALWAYS = 2;
    private int usepg2 = 0;
    private NormalDataArea normal;
    private Component special;
    private CardLayout cardLayout;
    private SetablePlotGraphics pg2;
    private SetablePlotGraphics pg1 = new PlotGraphics11();
    private Axis xAxis;
    private final Axis[] yAxis = new Axis[2];
    private EditableLabel xAxisLabel;
    private final EditableLabel[] yAxisLabel = new EditableLabel[2];

    public DataArea(Axis axis, Axis axis2) {
        this();
        this.add(axis, (Object)"x");
        this.add(axis2, (Object)"yl");
    }

    public DataArea() {
        super("Data Area");
        this.normal = new NormalDataArea();
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        super.add((Component)this.normal, "Normal");
        this.usePG2(1);
    }

    public void add(Axis axis, Object object) {
        if (axis == null) {
            return;
        }
        if (object == "x") {
            if (this.xAxis != null) {
                this.remove(this.xAxis);
            }
            this.xAxis = axis;
        } else if (object == "yl") {
            if (this.yAxis[0] != null) {
                this.remove(this.yAxis[0]);
            }
            this.yAxis[0] = axis;
        } else if (object == "yr") {
            if (this.yAxis[1] != null) {
                this.remove(this.yAxis[1]);
            }
            this.yAxis[1] = axis;
        }
        this.normal.add((Component)axis, object);
    }

    public void add(EditableLabel editableLabel, Object object) {
        if (editableLabel == null) {
            return;
        }
        if (object == "xl") {
            if (this.xAxisLabel != null) {
                this.remove(this.xAxisLabel);
            }
            this.xAxisLabel = editableLabel;
        } else if (object == "yll") {
            if (this.yAxisLabel[0] != null) {
                this.remove(this.yAxisLabel[0]);
            }
            this.yAxisLabel[0] = editableLabel;
        } else if (object == "yrl") {
            if (this.yAxisLabel[1] != null) {
                this.remove(this.yAxisLabel[1]);
            }
            this.yAxisLabel[1] = editableLabel;
        }
        this.normal.add((Component)editableLabel, object);
    }

    public void add(Overlay overlay) {
        this.overlays.addElement(overlay);
        overlay.containerNotify(this.normal);
    }

    public void setSpecialComponent(Component component) {
        if (component == this.special) {
            return;
        }
        if (component == null) {
            this.cardLayout.first(this);
            super.remove(this.special);
            this.special = null;
        } else {
            super.add(component, "Special");
            this.cardLayout.last(this);
            if (this.special != null) {
                super.remove(this.special);
            }
            this.special = component;
        }
    }

    public void remove(Component component) {
        if (component == this.xAxis) {
            this.xAxis = null;
        } else if (component == this.yAxis[0]) {
            this.yAxis[0] = null;
        } else if (component == this.yAxis[1]) {
            this.yAxis[1] = null;
        } else if (component == this.xAxisLabel) {
            this.xAxisLabel = null;
        } else if (component == this.yAxisLabel[0]) {
            this.yAxisLabel[0] = null;
        } else if (component == this.yAxisLabel[1]) {
            this.yAxisLabel[1] = null;
        }
        this.normal.remove(component);
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis[0];
    }

    public Axis getYAxis(int n) {
        return this.yAxis[n];
    }

    public void remove(Overlay overlay) {
        this.overlays.removeElement(overlay);
        overlay.containerNotify(null);
    }

    public EditableLabel getLabel(Axis axis) {
        if (axis == this.xAxis) {
            return this.xAxisLabel;
        }
        if (axis == this.yAxis[0]) {
            return this.yAxisLabel[0];
        }
        if (axis == this.yAxis[1]) {
            return this.yAxisLabel[1];
        }
        return null;
    }

    public void setLabel(Axis axis, EditableLabel editableLabel) {
        if (axis == this.xAxis) {
            this.add(editableLabel, (Object)"xl");
        } else if (axis == this.yAxis[0]) {
            this.add(editableLabel, (Object)"yll");
        } else if (axis == this.yAxis[1]) {
            this.add(editableLabel, (Object)"yrl");
        }
    }

    public void usePG2(int n) {
        if (n != 0 && this.pg2 == null) {
            try {
                Class<?> clazz = Class.forName("jas.plot.java2.PlotGraphics12");
                this.pg2 = (SetablePlotGraphics)clazz.newInstance();
            }
            catch (Throwable throwable) {
                this.usepg2 = 0;
                return;
            }
        }
        if (this.usepg2 != n) {
            this.usepg2 = n;
            this.repaint();
        }
    }

    private class NormalDataArea
    extends JComponent
    implements OverlayContainer {
        private boolean printing;

        NormalDataArea() {
            this.setLayout(new DataAreaLayout());
        }

        public void print(Graphics graphics) {
            try {
                this.printing = true;
                System.out.println("printing=" + this.printing);
                super.print(graphics);
                Object var3_2 = null;
                this.printing = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.printing = false;
                throw throwable;
            }
        }

        public void paintChildren(Graphics graphics) {
            try {
                super.paintChildren(graphics);
                boolean bl = DataArea.this.usepg2 == 2 || DataArea.this.usepg2 == 1 && this.isPrinting();
                SetablePlotGraphics setablePlotGraphics = bl ? DataArea.this.pg2 : DataArea.this.pg1;
                setablePlotGraphics.setGraphics(graphics);
                setablePlotGraphics.setClip(DataArea.this.xAxis.getMinLocation(), DataArea.this.xAxis.getMaxLocation(), DataArea.this.yAxis[0].getMinLocation(), DataArea.this.yAxis[0].getMaxLocation());
                int n = 0;
                int n2 = DataArea.this.overlays.size();
                while (n < n2) {
                    setablePlotGraphics.clearTransformation();
                    Overlay overlay = (Overlay)DataArea.this.overlays.elementAt(n);
                    overlay.paint(setablePlotGraphics);
                    ++n;
                }
                setablePlotGraphics.clearTransformation();
                setablePlotGraphics.clearClip();
                DataArea.this.xAxis.paint(setablePlotGraphics);
                if (DataArea.this.yAxis[0] != null) {
                    DataArea.this.yAxis[0].paint(setablePlotGraphics);
                }
                if (DataArea.this.yAxis[1] != null) {
                    DataArea.this.yAxis[1].paint(setablePlotGraphics);
                }
            }
            catch (Throwable throwable) {
                System.err.println("Exception while painting DataArea");
                throwable.printStackTrace();
            }
        }

        public CoordinateTransformation getXTransformation() {
            return ((DataArea)DataArea.this).xAxis.type.getCoordinateTransformation();
        }

        public CoordinateTransformation getYTransformation() {
            return ((DataArea)DataArea.this).yAxis[0].type.getCoordinateTransformation();
        }

        public CoordinateTransformation getYTransformation(int n) {
            return ((DataArea)DataArea.this).yAxis[n].type.getCoordinateTransformation();
        }

        private boolean isPrinting() {
            return this.printing || PrintHelper.isPrinting();
        }
    }
}

