/*
 * Decompiled with CFR 0.152.
 */
package jas.jds.module;

import jas.jds.module.BasicLocalDIM;
import jas.swingstudio.MultiFilePanel;
import jas.util.Application;
import jas.util.JASWizardPage;
import jas.util.UserProperties;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public abstract class MultiFileLocalDIM
extends BasicLocalDIM {
    private UserProperties prop = Application.getApplication().getUserProperties();
    private final String key = this.getClass().getName();
    private static final String MULTI = "MULTI";
    private static final String SINGLE = "SINGLE";

    public MultiFileLocalDIM(FileFilter fileFilter) {
        super(fileFilter);
    }

    public MultiFileLocalDIM(String string, String string2) {
        super(string, string2);
    }

    public JASWizardPage getSetupPage() {
        return new MultiFileWizardPage();
    }

    class MultiFileWizardPage
    extends BasicLocalDIM.BasicWizardPage
    implements ActionListener {
        private JPanel card;
        private CardLayout layout = new CardLayout();
        private JCheckBox multi;
        private MultiFilePanel multiFilePanel;

        MultiFileWizardPage() {
            this.remove(this.m_filePanel);
            this.card = new JPanel(this.layout);
            this.card.add((Component)this.m_filePanel, MultiFileLocalDIM.SINGLE);
            this.multiFilePanel = new MultiFilePanel(MultiFileLocalDIM.this.getFileFilter(), null, "Files to Open", MultiFileLocalDIM.this.key);
            this.card.add((Component)this.multiFilePanel, MultiFileLocalDIM.MULTI);
            this.add((Component)this.card, "Center");
            this.multi = new JCheckBox("Append multiple files together to form one logical dataset");
            this.add((Component)this.multi, "South");
            boolean bl = MultiFileLocalDIM.this.prop.getBoolean(MultiFileLocalDIM.this.key + ".multi", false);
            this.layout.show(this.card, bl ? MultiFileLocalDIM.MULTI : MultiFileLocalDIM.SINGLE);
            this.multi.setSelected(bl);
            this.multi.addActionListener(this);
        }

        public void onFinish() {
            if (!this.multi.isSelected()) {
                super.onFinish();
            } else {
                int n = this.multiFilePanel.getNFiles();
                if (n == 0) {
                    JOptionPane.showMessageDialog(this, "You must add at least one file.", "Error...", 0);
                    return;
                }
                MultiFileLocalDIM.this.m_ljb.createJob(this.multiFilePanel.getFilePath());
                this.multiFilePanel.saveState();
                this.dispose();
            }
            MultiFileLocalDIM.this.prop.setBoolean(MultiFileLocalDIM.this.key + ".multi", this.multi.isSelected());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.layout.show(this.card, this.multi.isSelected() ? MultiFileLocalDIM.MULTI : MultiFileLocalDIM.SINGLE);
        }
    }
}

