/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import jas.jds.ConnectionMonitor;
import jas.jds.JDSJob;
import jas.jds.interfaces.RemoteMonitor;
import jas.jds.interfaces.RemoteMonitorList;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;

public class JavaDataServerMonitor
extends UnicastRemoteObject
implements RemoteMonitor {
    private static JavaDataServerMonitor theMonitor;
    private Vector m_list = new Vector();

    public JavaDataServerMonitor() throws RemoteException {
        theMonitor = this;
    }

    public void connect(RemoteMonitorList remoteMonitorList) throws RemoteException {
        String[] stringArray = new String[]{"Job", "User", "Node", "Status"};
        int[] nArray = new int[]{0, 0, 0, 0};
        remoteMonitorList.setBatched(true);
        remoteMonitorList.setLabels(stringArray, nArray);
        Enumeration enumeration = JDSJob.elements();
        while (enumeration.hasMoreElements()) {
            JDSJob jDSJob = (JDSJob)enumeration.nextElement();
            String[] stringArray2 = new String[]{jDSJob.getName(), jDSJob.getUser(), jDSJob.getNode(), jDSJob.getState()};
            remoteMonitorList.setRow(jDSJob.getMonitor(), stringArray2);
        }
        remoteMonitorList.setBatched(false);
        this.m_list.addElement(remoteMonitorList);
    }

    public void disconnect(RemoteMonitorList remoteMonitorList) {
        this.m_list.removeElement(remoteMonitorList);
    }

    ConnectionMonitor addJob(JDSJob jDSJob) {
        try {
            ConnectionMonitor connectionMonitor = new ConnectionMonitor();
            String[] stringArray = new String[]{jDSJob.getName(), jDSJob.getUser(), jDSJob.getNode(), jDSJob.getState()};
            Enumeration enumeration = this.m_list.elements();
            while (enumeration.hasMoreElements()) {
                RemoteMonitorList remoteMonitorList = (RemoteMonitorList)enumeration.nextElement();
                try {
                    remoteMonitorList.setRow(connectionMonitor, stringArray);
                }
                catch (RemoteException remoteException) {
                    this.m_list.removeElement(remoteMonitorList);
                }
            }
            return connectionMonitor;
        }
        catch (RemoteException remoteException) {
            System.err.println("Unable to create ConnectionMonitor!");
            remoteException.printStackTrace();
            return null;
        }
    }

    void deleteJob(JDSJob jDSJob) {
        ConnectionMonitor connectionMonitor = jDSJob.getMonitor();
        Enumeration enumeration = this.m_list.elements();
        while (enumeration.hasMoreElements()) {
            RemoteMonitorList remoteMonitorList = (RemoteMonitorList)enumeration.nextElement();
            try {
                remoteMonitorList.clearRow(connectionMonitor);
            }
            catch (RemoteException remoteException) {
                this.m_list.removeElement(remoteMonitorList);
            }
        }
    }

    void updateJob(JDSJob jDSJob) {
        ConnectionMonitor connectionMonitor = jDSJob.getMonitor();
        String[] stringArray = new String[]{jDSJob.getName(), jDSJob.getUser(), jDSJob.getNode(), jDSJob.getState()};
        Enumeration enumeration = this.m_list.elements();
        while (enumeration.hasMoreElements()) {
            RemoteMonitorList remoteMonitorList = (RemoteMonitorList)enumeration.nextElement();
            try {
                remoteMonitorList.setRow(connectionMonitor, stringArray);
            }
            catch (RemoteException remoteException) {
                this.m_list.removeElement(remoteMonitorList);
            }
        }
    }

    static JavaDataServerMonitor getMonitor() {
        return theMonitor;
    }
}

