/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import jas.hist.Rebinnable1DHistogramData;
import jas.jds.ConnectionRefused;
import jas.jds.JDSJob;
import jas.jds.JobNotFoundError;
import jas.jds.SecureJavaDataServerImpl;
import jas.jds.interfaces.Remote1DHistogramInfo;
import jas.jds.interfaces.RemoteUpdate;
import jas.job.NoSuchItemError;
import jas.util.tree.TreeItem;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

class JDSConnection {
    static final long checkword = 314159271828L;
    static final double version = 1.0;
    private SecureJavaDataServerImpl jds;
    private static final Object OK = new TreeItem();

    JDSConnection(SecureJavaDataServerImpl secureJavaDataServerImpl) {
        this.jds = secureJavaDataServerImpl;
        Thread thread = new Thread(){

            public void run() {
                try {
                    ServerSocket serverSocket = new ServerSocket(998);
                    while (true) {
                        Socket socket = serverSocket.accept();
                        new ReaderThread(socket);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        };
        thread.start();
    }

    private class ReaderThread
    extends Thread {
        private WriterThread writer = new WriterThread();
        private Socket socket;
        private ObjectInputStream in;
        private ObjectOutputStream out;
        private String user;
        private String node;
        private JDSJob job;
        private Hashtable router = new Hashtable();

        ReaderThread(Socket socket) {
            try {
                this.socket = socket;
                this.in = new ObjectInputStream(socket.getInputStream());
                long l = this.in.readLong();
                if (l != 314159271828L) {
                    throw new ConnectionRefused();
                }
                double d = this.in.readDouble();
                if (d != 1.0) {
                    throw new ConnectionRefused();
                }
                this.user = (String)this.in.readObject();
                this.node = socket.getInetAddress().getHostName();
                this.out = new ObjectOutputStream(socket.getOutputStream());
                this.out.writeDouble(1.0);
                this.out.flush();
                this.start();
                this.writer.start();
                System.out.println("New Custom Connection from " + this.user + " at " + this.node);
            }
            catch (Exception exception) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Enumeration enumeration;
            try {
                Enumeration enumeration2;
                Enumeration enumeration3;
                try {
                    while (true) {
                        Object var15_20;
                        Object object;
                        Object object2;
                        String string;
                        if ((string = (String)this.in.readObject()).equals("connectToJob")) {
                            object2 = (String)this.in.readObject();
                            try {
                                this.job = JDSJob.findJob((String)object2);
                                this.job.connect(this.user, this.node);
                                this.writeObject(OK);
                            }
                            catch (JobNotFoundError jobNotFoundError) {
                                this.writeObject(null);
                            }
                            continue;
                        }
                        if (string.equals("getItem")) {
                            try {
                                object2 = (TreeItem)this.in.readObject();
                                object = this.job.getItem((TreeItem)object2);
                                this.writeObject(object2);
                            }
                            catch (NoSuchItemError noSuchItemError) {
                                this.writeObject(null);
                            }
                            continue;
                        }
                        if (string.equals("remoteRebin")) {
                            try {
                                object2 = (TreeItem)this.in.readObject();
                                object = (Rebinnable1DHistogramData)this.job.getItem((TreeItem)object2);
                                int n = this.in.readInt();
                                double d = this.in.readDouble();
                                double d2 = this.in.readDouble();
                                boolean bl = this.in.readBoolean();
                                boolean bl2 = this.in.readBoolean();
                                double[][] dArray = object.rebin(n, d, d2, bl, bl2);
                                this.writeObject(dArray);
                            }
                            catch (Throwable throwable) {
                                this.writeObject(null);
                            }
                            continue;
                        }
                        if (string.equals("getInfo")) {
                            try {
                                object2 = (TreeItem)this.in.readObject();
                                object = (Rebinnable1DHistogramData)this.job.getItem((TreeItem)object2);
                                Remote1DHistogramInfo remote1DHistogramInfo = new Remote1DHistogramInfo();
                                remote1DHistogramInfo.m_title = object.getTitle();
                                remote1DHistogramInfo.m_min = object.getMin();
                                remote1DHistogramInfo.m_max = object.getMax();
                                remote1DHistogramInfo.m_bins = object.getBins();
                                remote1DHistogramInfo.m_isRebinnable = object.isRebinnable();
                                remote1DHistogramInfo.m_axisType = object.getAxisType();
                                this.writeObject(remote1DHistogramInfo);
                            }
                            catch (Throwable throwable) {
                                this.writeObject(null);
                            }
                            continue;
                        }
                        if (string.equals("getRemoteAxisLabels")) {
                            try {
                                object2 = (TreeItem)this.in.readObject();
                                object = (Rebinnable1DHistogramData)this.job.getItem((TreeItem)object2);
                                this.writeObject(object.getAxisLabels());
                            }
                            catch (Throwable throwable) {
                                this.writeObject(null);
                            }
                            continue;
                        }
                        if (string.equals("addObserver")) {
                            Object var13_19;
                            try {
                                try {
                                    object2 = (TreeItem)this.in.readObject();
                                    object = (Observable)this.job.getItem((TreeItem)object2);
                                    this.router.put(object, object2);
                                    ((Observable)object).addObserver(this.writer);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                    var13_19 = null;
                                    this.writeObject(null);
                                    continue;
                                }
                                var13_19 = null;
                            }
                            catch (Throwable throwable) {
                                var13_19 = null;
                                this.writeObject(null);
                                throw throwable;
                            }
                            this.writeObject(null);
                            continue;
                        }
                        if (!string.equals("removeObserver")) throw new Exception("Unknown message " + string);
                        try {
                            object2 = (TreeItem)this.in.readObject();
                            object = (Observable)this.job.getItem((TreeItem)object2);
                            this.router.remove(object);
                            ((Observable)object).deleteObserver(this.writer);
                            var15_20 = null;
                        }
                        catch (Throwable throwable) {
                            var15_20 = null;
                            this.writeObject(null);
                            throw throwable;
                        }
                        this.writeObject(null);
                    }
                }
                catch (EOFException eOFException) {
                    Object var17_23 = null;
                    System.out.println("Saying goodbye to " + this.user + " at " + this.node);
                    this.writer.stop();
                    enumeration3 = this.router.keys();
                }
                while (enumeration3.hasMoreElements()) {
                    Observable observable = (Observable)enumeration3.nextElement();
                    observable.deleteObserver(this.writer);
                }
                return;
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var17_24 = null;
                    System.out.println("Saying goodbye to " + this.user + " at " + this.node);
                    this.writer.stop();
                    enumeration2 = this.router.keys();
                }
                while (enumeration2.hasMoreElements()) {
                    Observable observable = (Observable)enumeration2.nextElement();
                    observable.deleteObserver(this.writer);
                }
                return;
            }
            catch (Throwable throwable) {
                Object var17_25 = null;
                System.out.println("Saying goodbye to " + this.user + " at " + this.node);
                this.writer.stop();
                enumeration = this.router.keys();
            }
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    throw throwable;
                }
                Observable observable = (Observable)enumeration.nextElement();
                observable.deleteObserver(this.writer);
            }
        }

        private void writeObject(Object object) throws IOException {
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeObject(object);
                this.out.flush();
                this.out.reset();
            }
        }

        private class WriterThread
        extends Thread
        implements Observer {
            private Vector queue;

            private WriterThread() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    block8: while (true) {
                        Enumeration enumeration;
                        WriterThread writerThread = this;
                        synchronized (writerThread) {
                            if (this.queue == null) {
                                this.wait();
                            }
                            enumeration = this.queue.elements();
                            this.queue = null;
                        }
                        ObjectOutputStream objectOutputStream = ReaderThread.this.out;
                        synchronized (objectOutputStream) {
                            while (true) {
                                if (!enumeration.hasMoreElements()) {
                                    ReaderThread.this.out.flush();
                                    ReaderThread.this.out.reset();
                                    continue block8;
                                }
                                ReaderThread.this.out.writeObject(enumeration.nextElement());
                            }
                        }
                        break;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (EOFException eOFException) {
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }

            public synchronized void update(Observable observable, Object object) {
                Object v = ReaderThread.this.router.get(observable);
                if (v != null) {
                    if (this.queue == null) {
                        this.queue = new Vector();
                        this.queue.addElement(new RemoteUpdate(v, object));
                        this.notify();
                    } else {
                        this.queue.addElement(new RemoteUpdate(v, object));
                    }
                }
            }
        }
    }
}

