/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import jas.jds.NestedClassException;
import jas.jds.interfaces.RemoteClassLoader;
import java.rmi.RemoteException;
import java.util.Hashtable;

class JDSClassLoader
extends ClassLoader {
    private Hashtable m_cache = new Hashtable();
    private RemoteClassLoader m_remote;

    JDSClassLoader(RemoteClassLoader remoteClassLoader) {
        this.m_remote = remoteClassLoader;
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.m_cache.get(string);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    byte[] byArray = this.m_remote.loadClassData(string);
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                }
                catch (RemoteException remoteException) {
                    throw new NestedClassException("Unexpected error during remote class load", remoteException);
                }
            }
        }
        this.m_cache.put(string, clazz);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

