/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.ExtendedStatistics;
import jas.hist.JASHistData;
import jas.hist.Statistics;
import jas.hist.StatsWindow;
import jas.plot.TextBlock;
import jas.util.ScientificFormat;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class StatisticsBlock
extends TextBlock {
    private boolean NothingToShow;
    private Format f;
    private Hashtable formats = new Hashtable();
    private StatsWindow statwin;
    private Vector stats = new Vector();
    private String[] selectedentries;
    private String[] listnames;
    private int showtitles = 3;
    private int splitstringalign = 2;
    private String line;
    private JMenuItem statpropertiesitem;
    private boolean alwaysall = true;
    public static final int SHOWTITLES_ALWAYS = 1;
    public static final int SHOWTITLES_NEVER = 2;
    public static final int SHOWTITLES_AUTOMATIC = 3;
    public static final int LEFTALIGNSPLIT = 1;
    public static final int RIGHTALIGNSPLIT = 2;
    public static final int NOALIGNSPLIT = 3;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$jas$util$DoubleWithError;

    public StatisticsBlock() {
        this(new ScientificFormat());
    }

    public StatisticsBlock(Format format) {
        super("Statistics");
        this.initializeDefaultFormats(format);
        this.setFormat(format);
    }

    public int getNLines() {
        this.NothingToShow = false;
        if (this.stats.isEmpty()) {
            return 1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.stats.size()) {
            JASHistData jASHistData = (JASHistData)this.stats.elementAt(n2);
            Statistics statistics = jASHistData.getStatistics();
            n = this.selectedentries != null ? (n += this.addDisplayLines(this.compareEntries(statistics)).length) : (n += this.addDisplayLines(statistics.getStatisticNames()).length);
            ++n2;
        }
        if (n == 0) {
            this.NothingToShow = true;
            n = 1;
            return 1;
        }
        return n;
    }

    public String getLine(int n) {
        if (this.stats.isEmpty() || this.NothingToShow) {
            return "No Statistics";
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.stats.size()) {
            JASHistData jASHistData = (JASHistData)this.stats.elementAt(n3);
            Statistics statistics = jASHistData.getStatistics();
            String[] stringArray = this.addDisplayLines(this.compareEntries(statistics));
            String[] stringArray2 = this.addDisplayLines(statistics.getStatisticNames());
            if (this.selectedentries != null) {
                if (n - n2 < stringArray.length) {
                    String string;
                    this.line = stringArray[n - n2];
                    if (this.line.equals("addplottitle")) {
                        return jASHistData.getLegendText();
                    }
                    if (this.line.equals("\n")) {
                        return this.line;
                    }
                    if (statistics instanceof ExtendedStatistics) {
                        Format format;
                        Object object = ((ExtendedStatistics)statistics).getExtendedStatistic(this.line);
                        if (object == null) {
                            object = new Double(statistics.getStatistic(this.line));
                        }
                        string = (format = (Format)this.formats.get(object.getClass())) != null ? this.line + "\t" + format.format(object) : this.line + "\t" + object.toString();
                    } else {
                        Double d = new Double(statistics.getStatistic(this.line));
                        string = this.line + "\t" + this.f.format(d);
                    }
                    return string;
                }
                n2 += stringArray.length;
            } else {
                if (n - n2 < stringArray2.length) {
                    String string;
                    this.line = stringArray2[n - n2];
                    if (this.line.equals("addplottitle")) {
                        return jASHistData.getLegendText();
                    }
                    if (this.line.equals("\n")) {
                        return this.line;
                    }
                    if (statistics instanceof ExtendedStatistics) {
                        Format format;
                        Object object = ((ExtendedStatistics)statistics).getExtendedStatistic(this.line);
                        if (object == null) {
                            object = new Double(statistics.getStatistic(this.line));
                        }
                        string = (format = (Format)this.formats.get(object.getClass())) != null ? this.line + "\t" + format.format(object) : this.line + "\t" + object.toString();
                    } else {
                        Double d = new Double(statistics.getStatistic(this.line));
                        string = this.line + "\t" + this.f.format(d);
                    }
                    return string;
                }
                n2 += stringArray2.length;
            }
            ++n3;
        }
        throw new IllegalArgumentException();
    }

    private String[] addDisplayLines(String[] stringArray) {
        if (this.showtitles == 1 || this.showtitles == 3 && this.stats.size() > 1 && stringArray.length > 0) {
            String[] stringArray2 = new String[stringArray.length + 2];
            stringArray2[0] = "\n";
            stringArray2[1] = "addplottitle";
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n + 2] = stringArray[n];
                ++n;
            }
            return stringArray2;
        }
        if (stringArray.length > 0) {
            String[] stringArray3 = new String[stringArray.length + 1];
            stringArray3[0] = "\n";
            int n = 0;
            while (n < stringArray.length) {
                stringArray3[n + 1] = stringArray[n];
                ++n;
            }
            return stringArray3;
        }
        return stringArray;
    }

    private String[] compareEntries(Statistics statistics) {
        Object[] objectArray = statistics.getStatisticNames();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < objectArray.length) {
            if (this.selectedentries != null) {
                int n2 = 0;
                while (n2 < this.selectedentries.length) {
                    if (((String)objectArray[n]).equals(this.selectedentries[n2])) {
                        vector.addElement(this.selectedentries[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setSelectedEntries(String[] stringArray) {
        this.selectedentries = stringArray;
    }

    public String[] getSelectedEntries() {
        return this.selectedentries;
    }

    void set_AllwaysAll_Subset(boolean bl) {
        this.alwaysall = bl;
    }

    boolean get_AllwaysAll_Subset() {
        return this.alwaysall;
    }

    String[] getStatNames() {
        Vector<String> vector = new Vector<String>();
        this.listnames = null;
        int n = 0;
        while (n < this.stats.size()) {
            JASHistData jASHistData = (JASHistData)this.stats.elementAt(n);
            Statistics statistics = jASHistData.getStatistics();
            if (statistics != null) {
                this.listnames = statistics.getStatisticNames();
            }
            if (this.listnames != null) {
                int n2 = 0;
                while (n2 < this.listnames.length) {
                    if (!vector.contains(this.listnames[n2])) {
                        vector.addElement(this.listnames[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.listnames = new String[vector.size()];
        vector.copyInto(this.listnames);
        return this.listnames;
    }

    public void add(JASHistData jASHistData) {
        if (jASHistData.getStatistics() != null) {
            this.stats.addElement(jASHistData);
        }
    }

    public void remove(JASHistData jASHistData) {
        this.stats.removeElement(jASHistData);
    }

    public void clear() {
        this.stats.removeAllElements();
    }

    public void setFormat(Format format) {
        this.f = format;
        this.updateFormatsInstances(this.f);
        this.revalidate();
        this.repaint();
    }

    public Format getFormat() {
        return this.f;
    }

    public void putFormat(Class clazz, Format format) {
        this.formats.put(clazz, format);
    }

    private void updateFormatsInstances(Format format) {
        Enumeration enumeration = this.formats.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (this.formats.get(k).getClass() != format.getClass()) continue;
            this.putFormat(k.getClass(), format);
        }
    }

    private void initializeDefaultFormats(Format format) {
        if (format instanceof ScientificFormat) {
            this.putFormat(class$java$lang$Double == null ? (class$java$lang$Double = StatisticsBlock.class$("java.lang.Double")) : class$java$lang$Double, format);
            this.putFormat(class$jas$util$DoubleWithError == null ? (class$jas$util$DoubleWithError = StatisticsBlock.class$("jas.util.DoubleWithError")) : class$jas$util$DoubleWithError, format);
        } else {
            ScientificFormat scientificFormat = new ScientificFormat();
            this.putFormat(class$java$lang$Double == null ? (class$java$lang$Double = StatisticsBlock.class$("java.lang.Double")) : class$java$lang$Double, scientificFormat);
            this.putFormat(class$jas$util$DoubleWithError == null ? (class$jas$util$DoubleWithError = StatisticsBlock.class$("jas.util.DoubleWithError")) : class$jas$util$DoubleWithError, scientificFormat);
        }
    }

    public int getSplitStringAlign() {
        return this.splitstringalign;
    }

    public void setSplitStringAlign(int n) {
        if (n >= 4 || n <= 0) {
            throw new IllegalArgumentException("Integer splitstringalign must be set to 1,2 or 3");
        }
        this.splitstringalign = n;
    }

    public void setShowTitles(int n) {
        if (n >= 4 || n <= 0) {
            throw new IllegalArgumentException("Integer showtitles must be set to 1,2 or 3");
        }
        this.showtitles = n;
    }

    public int getShowTitles() {
        return this.showtitles;
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        this.statpropertiesitem = new JMenuItem(this.getPrefix() + " Properties..."){
            static /* synthetic */ Class class$java$awt$Frame;

            protected void fireActionPerformed(ActionEvent actionEvent) {
                StatisticsBlock.this.statwin = new StatsWindow(StatisticsBlock.this);
                Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = 1.class$("java.awt.Frame")) : class$java$awt$Frame, this);
                StatisticsBlock.this.statwin.showStatsWindow();
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        jPopupMenu.add(this.statpropertiesitem);
        super.modifyPopupMenu(jPopupMenu, component);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

