/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DateTransformationConverter;
import jas.hist.JASHist1DHistogramData;
import jas.hist.JASHist1DHistogramStyle;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.MutableLegendEntry;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import jas.plot.StringCoordinateTransformation;
import jas.plot.java1.PlotGraphics11;
import java.awt.Color;
import java.awt.Graphics;

class OneDOverlay
implements Overlay,
MutableLegendEntry {
    private OverlayContainer container;
    private JASHist1DHistogramData source;
    private double[] data;
    private double[] plus;
    private double[] minus;
    private double xmin;
    private double xmax;
    private String[] labels;

    OneDOverlay(JASHist1DHistogramData jASHist1DHistogramData) {
        this.source = jASHist1DHistogramData;
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
        JASHist1DHistogramStyle jASHist1DHistogramStyle = this.source.style;
        if (jASHist1DHistogramStyle.getShowDataPoints()) {
            graphics.setColor(jASHist1DHistogramStyle.getDataPointColor());
            PlotGraphics11.drawSymbol(graphics, n / 2, n2 / 2, n / 2, jASHist1DHistogramStyle.getDataPointStyle());
        } else if (jASHist1DHistogramStyle.getShowHistogramBars()) {
            graphics.setColor(jASHist1DHistogramStyle.getHistogramBarColor());
            graphics.fillRect(1, 1, n - 2, n2 - 2);
        } else if (jASHist1DHistogramStyle.getShowLinesBetweenPoints()) {
            graphics.setColor(jASHist1DHistogramStyle.getLineColor());
            graphics.fillRect(1, 1, n - 2, n2 - 2);
        } else if (jASHist1DHistogramStyle.getShowErrorBars()) {
            graphics.setColor(jASHist1DHistogramStyle.getErrorBarColor());
            graphics.fillRect(1, 1, n - 2, n2 - 2);
        } else if (jASHist1DHistogramStyle.getHistogramFill()) {
            graphics.setColor(jASHist1DHistogramStyle.getHistogramBarColor());
            graphics.fillRect(1, 1, n - 2, n2 - 2);
        }
    }

    public String getTitle() {
        return this.source.getLegendText();
    }

    public void setTitle(String string) {
        this.source.setLegendText(string);
    }

    public boolean titleIsChanged() {
        return this.source.isLegendChanged();
    }

    void setData(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2) {
        this.data = dArray;
        this.plus = dArray2;
        this.minus = dArray3;
        this.xmin = d;
        this.xmax = d2;
    }

    void setData(double[] dArray, double[] dArray2, double[] dArray3, String[] stringArray) {
        this.data = dArray;
        this.plus = dArray2;
        this.minus = dArray3;
        this.labels = stringArray;
    }

    public void paint(PlotGraphics plotGraphics) {
        block28: {
            CoordinateTransformation coordinateTransformation;
            CoordinateTransformation coordinateTransformation2;
            JASHist1DHistogramStyle jASHist1DHistogramStyle;
            block27: {
                jASHist1DHistogramStyle = this.source.style;
                coordinateTransformation2 = this.container.getXTransformation();
                coordinateTransformation = this.container.getYTransformation(this.source.getYAxis());
                if (coordinateTransformation2 instanceof DateCoordinateTransformation) {
                    coordinateTransformation2 = new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation2);
                }
                if (!(coordinateTransformation2 instanceof DoubleCoordinateTransformation) || !(coordinateTransformation instanceof DoubleCoordinateTransformation)) break block27;
                DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)coordinateTransformation2;
                DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)coordinateTransformation;
                int n = this.data.length;
                double d = (this.xmax - this.xmin) / (double)n;
                double d2 = (doubleCoordinateTransformation.convert(this.xmax) - doubleCoordinateTransformation.convert(this.xmin)) / (double)n;
                boolean bl = d2 > 5.0;
                double d3 = Math.min(d, 3.0 * d / d2);
                plotGraphics.setTransformation(doubleCoordinateTransformation, doubleCoordinateTransformation2);
                double d4 = this.xmin;
                double d5 = this.xmin;
                double d6 = 0.0;
                if (doubleCoordinateTransformation2.getPlotMin() > d6) {
                    d6 = doubleCoordinateTransformation2.getPlotMin();
                }
                if (doubleCoordinateTransformation2.getPlotMax() < d6) {
                    d6 = doubleCoordinateTransformation2.getPlotMax();
                }
                double d7 = d6;
                double[] dArray = null;
                double[] dArray2 = null;
                int n2 = 0;
                if (jASHist1DHistogramStyle.getShowLinesBetweenPoints() || jASHist1DHistogramStyle.getShowDataPoints()) {
                    dArray = new double[n];
                    dArray2 = new double[n];
                }
                int n3 = 0;
                while (n3 < n) {
                    double d8 = this.data[n3];
                    d4 += d;
                    if (jASHist1DHistogramStyle.getShowHistogramBars()) {
                        if (!Double.isNaN(d8)) {
                            plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarColor());
                            if (jASHist1DHistogramStyle.getHistogramFill()) {
                                plotGraphics.fillRect(d5, d6, d4, d8);
                                plotGraphics.setColor(Color.black);
                                if (bl) {
                                    plotGraphics.drawRect(d5, d6, d4, d8);
                                } else {
                                    plotGraphics.drawLine(d5, d7, d5, d8);
                                    plotGraphics.drawLine(d5, d8, d4, d8);
                                }
                            } else {
                                plotGraphics.drawLine(d5, d7, d5, d8);
                                plotGraphics.drawLine(d5, d8, d4, d8);
                            }
                        } else if (!jASHist1DHistogramStyle.getHistogramFill() || !bl) {
                            plotGraphics.drawLine(d5, d7, d5, d6);
                        }
                    }
                    if (jASHist1DHistogramStyle.getShowErrorBars() && !Double.isNaN(d8)) {
                        plotGraphics.setColor(jASHist1DHistogramStyle.getErrorBarColor());
                        double d9 = d5 + d / 2.0;
                        double d10 = d3;
                        double d11 = this.data[n3] + this.plus[n3];
                        double d12 = this.data[n3] - this.minus[n3];
                        plotGraphics.drawLine(d9, d11, d9, d12);
                        if (bl) {
                            plotGraphics.drawLine(d9 - d10, d11, d9 + d10, d11);
                            plotGraphics.drawLine(d9 - d10, d12, d9 + d10, d12);
                        }
                    }
                    if (dArray != null) {
                        if (Double.isNaN(d8)) {
                            if (n2 > 0) {
                                if (jASHist1DHistogramStyle.getShowLinesBetweenPoints()) {
                                    plotGraphics.setColor(jASHist1DHistogramStyle.getLineColor());
                                    plotGraphics.drawPolyLine(dArray, dArray2, n2);
                                }
                                if (jASHist1DHistogramStyle.getShowDataPoints()) {
                                    plotGraphics.setColor(jASHist1DHistogramStyle.getDataPointColor());
                                    plotGraphics.drawPolySymbol(dArray, dArray2, jASHist1DHistogramStyle.getDataPointSize(), jASHist1DHistogramStyle.getDataPointStyle(), n2);
                                }
                                n2 = 0;
                            }
                        } else {
                            dArray[n2] = d5 + d / 2.0;
                            dArray2[n2++] = d8;
                        }
                    }
                    d5 = d4;
                    d7 = d8 == Double.NaN ? d6 : d8;
                    ++n3;
                }
                if (n2 <= 0) break block28;
                if (jASHist1DHistogramStyle.getShowLinesBetweenPoints()) {
                    plotGraphics.setColor(jASHist1DHistogramStyle.getLineColor());
                    plotGraphics.drawPolyLine(dArray, dArray2, n2);
                }
                if (!jASHist1DHistogramStyle.getShowDataPoints()) break block28;
                plotGraphics.setColor(jASHist1DHistogramStyle.getDataPointColor());
                plotGraphics.drawPolySymbol(dArray, dArray2, jASHist1DHistogramStyle.getDataPointSize(), jASHist1DHistogramStyle.getDataPointStyle(), n2);
                break block28;
            }
            if (coordinateTransformation2 instanceof StringCoordinateTransformation && coordinateTransformation instanceof DoubleCoordinateTransformation) {
                StringCoordinateTransformation stringCoordinateTransformation = (StringCoordinateTransformation)coordinateTransformation2;
                DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)coordinateTransformation;
                int n = this.labels.length;
                double d = stringCoordinateTransformation.binWidth();
                boolean bl = d > 5.0;
                plotGraphics.setTransformation(null, doubleCoordinateTransformation);
                double d13 = doubleCoordinateTransformation.getPlotMin();
                int n4 = 0;
                while (n4 < n) {
                    double d14 = stringCoordinateTransformation.convert(this.labels[n4]) + d / 2.0;
                    double d15 = d14 - d;
                    double d16 = this.data[n4];
                    plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarColor());
                    plotGraphics.fillRect(d15, d13, d14, d16);
                    plotGraphics.setColor(Color.black);
                    if (bl) {
                        plotGraphics.drawRect(d15, d13, d14, d16);
                    } else {
                        plotGraphics.drawLine(d15, d13, d15, d16);
                        plotGraphics.drawLine(d15, d16, d14, d16);
                        d13 = d16;
                    }
                    if (jASHist1DHistogramStyle.getShowErrorBars()) {
                        double d17 = d14 - d / 2.0;
                        double d18 = Math.min(3.0, d / 2.0);
                        double d19 = this.data[n4] + this.plus[n4];
                        double d20 = this.data[n4] - this.minus[n4];
                        plotGraphics.drawLine(d17, d19, d17, d20);
                        plotGraphics.drawLine(d17 - d18, d19, d17 + d18, d19);
                        plotGraphics.drawLine(d17 - d18, d20, d17 + d18, d20);
                    }
                    ++n4;
                }
            }
        }
    }

    public void containerNotify(OverlayContainer overlayContainer) {
        this.container = overlayContainer;
    }
}

