/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.HasDataSource;
import jas.hist.HasScatterPlotData;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist2DHistogramData;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.JASHistStyle;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterOverlay;
import jas.hist.XMLHistBuilder;
import jas.hist.XMLPrintWriter;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import jas.util.xml.HasXMLRepresentation;
import jas.util.xml.JASDOMParser;
import jas.util.xml.XMLNodeTraverser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;

class JASHist2DScatterData
extends JASHist2DHistogramData {
    HasScatterPlotData dataSource;
    boolean dataChanged;
    boolean resetSent;
    boolean onNewAxis;

    JASHist2DScatterData(DataManager dataManager, HasScatterPlotData hasScatterPlotData) {
        super(dataManager, hasScatterPlotData);
        this.dataSource = hasScatterPlotData;
    }

    JASHistStyle createStyle() {
        return new JASHistScatterPlotStyle();
    }

    boolean hasScatterPlotData() {
        return this.dataSource.hasScatterPlotData();
    }

    public void setStyle(JASHistStyle jASHistStyle) {
        if (!(jASHistStyle instanceof JASHistScatterPlotStyle)) {
            throw new IllegalArgumentException("Style " + jASHistStyle.getClass() + " is not subclass of JASHistScatterPlotStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHistScatterPlotStyle)jASHistStyle;
        this.style.addObserver(this);
    }

    Overlay createOverlay() {
        return new ScatterOverlay(this);
    }

    public void update(Observable observable, Object object) {
        if (observable == this.dataSource) {
            this.parent.update((HistogramUpdate)object, this);
        } else if (observable == this.style) {
            this.parent.styleUpdate(this);
        }
    }

    void restartImage(boolean bl) {
        if (this.overlay instanceof ScatterOverlay) {
            ((ScatterOverlay)this.overlay).restartImage(bl);
        }
    }

    void continueImage() {
        if (this.overlay instanceof ScatterOverlay) {
            ((ScatterOverlay)this.overlay).continueImage();
        }
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    protected void calcZLimits() {
        if (((JASHistScatterPlotStyle)this.style).getDisplayAsScatterPlot()) {
            return;
        }
        super.calcZLimits();
    }

    public static void main(String[] stringArray) {
        try {
            URL uRL = new URL("http://www.slac.stanford.edu/~pspence/scattertest.plotml");
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            XMLHistBuilder xMLHistBuilder = new XMLHistBuilder(inputStreamReader, "scattertest.plotml");
            ((Reader)inputStreamReader).close();
            xMLHistBuilder.getSoloPlot();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("aida exception: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("aida exception: " + iOException);
        }
        catch (JASDOMParser.XMLException xMLException) {
            System.out.println("aida exception: " + xMLException);
        }
        catch (XMLNodeTraverser.BadXMLException badXMLException) {
            System.out.println("aida exception: " + badXMLException);
        }
    }

    public void writeAsXML(XMLPrintWriter xMLPrintWriter, boolean bl) {
        Object object;
        String string = XMLPrintWriter.convertAxisTypeToString(this.dataSource.getXAxisType());
        String string2 = XMLPrintWriter.convertAxisTypeToString(this.dataSource.getYAxisType());
        xMLPrintWriter.setAttribute("type", "scatter2d");
        xMLPrintWriter.openTag("data2d");
        int n = this.dataSource.getXBins();
        double d = this.dataSource.getXMin();
        double d2 = this.dataSource.getXMax();
        int n2 = this.dataSource.getYBins();
        double d3 = this.dataSource.getYMin();
        double d4 = this.dataSource.getYMax();
        if (bl) {
            object = this.dataSource.rebin(n, d, d2, n2, d3, d4, true, false, this.style.getShowOverflow());
            if (object == null) {
                object = new double[1][n][n2];
            }
            double[][] dArray = object[0];
            xMLPrintWriter.setAttribute("title", this.getTitle());
            xMLPrintWriter.setAttribute("dimensions", "2");
            xMLPrintWriter.openTag("points");
            double[] dArray2 = new double[2];
            int n3 = xMLPrintWriter.getIndent();
            int n4 = 0;
            while (n4 < n3) {
                xMLPrintWriter.outdent();
                ++n4;
            }
            if (this.dataSource.hasScatterPlotData()) {
                ScatterEnumeration scatterEnumeration = this.dataSource.startEnumeration();
                while (scatterEnumeration.getNextPoint(dArray2)) {
                    xMLPrintWriter.println(dArray2[0] + "," + dArray2[1]);
                }
            }
            int n5 = 0;
            while (n5 < n3) {
                xMLPrintWriter.indent();
                ++n5;
            }
            xMLPrintWriter.closeTag();
            xMLPrintWriter.printPointDataAxisAttributes("x", string);
            xMLPrintWriter.printPointDataAxisAttributes("y", string2);
        } else if (this.dataSource instanceof HasXMLRepresentation) {
            ((HasXMLRepresentation)((Object)this.dataSource)).writeAsXML(xMLPrintWriter);
        } else {
            if (this.dataSource instanceof HasDataSource) {
                xMLPrintWriter.setAttribute("name", this.dataSource.getClass().getName());
            } else {
                xMLPrintWriter.setAttribute("name", "???");
            }
            xMLPrintWriter.setAttribute("param", "???");
            xMLPrintWriter.printTag("class");
        }
        object = JASHist2DHistogramStyle.getHistStyleName(this.style.getHistStyle());
        xMLPrintWriter.setAttribute("histStyle", (String)object);
        if (object.equals("STYLE_COLORMAP")) {
            xMLPrintWriter.setAttribute("colorMapScheme", JASHist2DHistogramStyle.getColorMapSchemeName(this.style.getColorMapScheme()));
        }
        xMLPrintWriter.setAttribute("shapeColor", ColorConverter.colorToString(this.style.getShapeColor()));
        xMLPrintWriter.setAttribute("overflowBinColor", ColorConverter.colorToString(this.style.getOverflowBinColor()));
        xMLPrintWriter.setAttribute("startDataColor", ColorConverter.colorToString(this.style.getStartDataColor()));
        xMLPrintWriter.setAttribute("endDataColor", ColorConverter.colorToString(this.style.getEndDataColor()));
        xMLPrintWriter.setAttribute("showOverflow", this.style.getShowOverflow());
        xMLPrintWriter.setAttribute("showPlot", this.style.getShowPlot());
        xMLPrintWriter.setAttribute("displayAsScatterPlot", ((JASHistScatterPlotStyle)this.style).getDisplayAsScatterPlot());
        xMLPrintWriter.setAttribute("dataPointSize", ((JASHistScatterPlotStyle)this.style).getDataPointSize());
        xMLPrintWriter.setAttribute("dataPointStyle", ((JASHistScatterPlotStyle)this.style).getDataPointStyle());
        xMLPrintWriter.setAttribute("dataPointColor", ColorConverter.colorToString(((JASHistScatterPlotStyle)this.style).getDataPointColor()));
        xMLPrintWriter.printTag("style2d");
        xMLPrintWriter.closeTag();
    }
}

