/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.JASHistStyle;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class JASHist1DHistogramStyle
extends JASHistStyle
implements Serializable {
    public static final int SYMBOL_DOT = 0;
    public static final int SYMBOL_BOX = 1;
    public static final int SYMBOL_TRIANGLE = 2;
    public static final int SYMBOL_DIAMOND = 3;
    public static final int SYMBOL_STAR = 4;
    public static final int SYMBOL_VERT_LINE = 5;
    public static final int SYMBOL_HORIZ_LINE = 6;
    public static final int SYMBOL_CROSS = 7;
    public static final int SYMBOL_CIRCLE = 8;
    public static final int SYMBOL_SQUARE = 9;
    static final Color[] lineColors = new Color[]{Color.blue, Color.red, Color.magenta, Color.yellow, Color.green, Color.orange, Color.cyan};
    static final int[] pointStyles = new int[]{0, 1, 2, 3, 4, 7, 8, 9};
    static int n = 0;
    static final long serialVersionUID = 7779996364086801435L;
    private boolean m_histogramFill;
    private Color m_histogramBarColor;
    private Color m_errorBarColor;
    private Color m_lineColor;
    private Color m_dataPointColor;
    private int m_style;
    private int m_dataPointStyle;
    private int m_dataPointSize;
    private boolean m_showHistogramBars;
    private boolean m_showErrorBars;
    private boolean m_showDataPoints;
    private boolean m_showLinesBetweenPoints;
    private boolean m_errorBarColorIsDefault;

    public JASHist1DHistogramStyle() {
        this.initTransientData();
        this.m_showDataPoints = false;
        this.m_showErrorBars = true;
        this.m_histogramFill = true;
        this.m_showHistogramBars = true;
        this.m_showLinesBetweenPoints = false;
        this.m_dataPointSize = 6;
        this.m_dataPointStyle = pointStyles[n];
        this.m_histogramBarColor = lineColors[n];
        this.m_errorBarColor = lineColors[n];
        this.m_errorBarColorIsDefault = true;
        this.m_dataPointColor = lineColors[n];
        this.m_lineColor = lineColors[n];
        if (++n == lineColors.length) {
            n = 0;
        }
    }

    public boolean getShowHistogramBars() {
        return this.m_showHistogramBars;
    }

    public void setShowHistogramBars(boolean bl) {
        this.m_showHistogramBars = bl;
        this.changeNotify();
    }

    public boolean getShowErrorBars() {
        return this.m_showErrorBars;
    }

    public void setShowErrorBars(boolean bl) {
        this.m_showErrorBars = bl;
        this.changeNotify();
    }

    public boolean getShowDataPoints() {
        return this.m_showDataPoints;
    }

    public void setShowDataPoints(boolean bl) {
        this.m_showDataPoints = bl;
        this.changeNotify();
    }

    public boolean getShowLinesBetweenPoints() {
        return this.m_showLinesBetweenPoints;
    }

    public void setShowLinesBetweenPoints(boolean bl) {
        this.m_showLinesBetweenPoints = bl;
        this.changeNotify();
    }

    public int getDataPointStyle() {
        return this.m_dataPointStyle;
    }

    public void setDataPointStyle(int n) {
        this.m_dataPointStyle = n;
        this.changeNotify();
    }

    public int getDataPointSize() {
        return this.m_dataPointSize;
    }

    public void setDataPointSize(int n) {
        this.m_dataPointSize = n;
        this.changeNotify();
    }

    public Color getDataPointColor() {
        return this.m_dataPointColor;
    }

    public void setDataPointColor(Color color) {
        this.m_dataPointColor = color;
        this.changeNotify();
    }

    public Color getHistogramBarColor() {
        return this.m_histogramBarColor;
    }

    public void setHistogramBarColor(Color color) {
        this.m_histogramBarColor = color;
        this.changeNotify();
    }

    public Color getLineColor() {
        return this.m_lineColor;
    }

    public void setLineColor(Color color) {
        this.m_lineColor = color;
        this.changeNotify();
    }

    public Color getErrorBarColor() {
        if (this.m_histogramFill && this.m_errorBarColorIsDefault) {
            return Color.black;
        }
        return this.m_errorBarColor;
    }

    public void setErrorBarColor(Color color) {
        this.m_errorBarColor = color;
        this.m_errorBarColorIsDefault = false;
        this.changeNotify();
    }

    public boolean getHistogramFill() {
        return this.m_histogramFill;
    }

    public void setHistogramFill(boolean bl) {
        this.m_histogramFill = bl;
        this.changeNotify();
    }

    protected void changeNotify() {
        super.changeNotify();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initTransientData();
    }

    private void initTransientData() {
    }
}

