/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.HasDataSource;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.OneDOverlay;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.XMLPrintWriter;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import jas.util.xml.HasXMLRepresentation;
import java.io.Serializable;
import java.util.Observable;

class JASHist1DHistogramData
extends JASHistData {
    private Rebinnable1DHistogramData dataSource;
    JASHist1DHistogramStyle style;
    private boolean isBinned = false;
    private boolean yLimitsValid = false;
    private double[] data;
    private double[] plusError;
    private double[] minusError;
    private int xBins;
    private double xLow;
    private double xHigh;
    private double yLow;
    private double yHigh;
    private static final HistogramUpdate hu = new HistogramUpdate(2, true);
    static final long serialVersionUID = -3529869583896718619L;
    private FittableDataSource fittableDataSource = new FittableDataSource();

    JASHist1DHistogramData(DataManager dataManager, Rebinnable1DHistogramData rebinnable1DHistogramData) {
        super(dataManager);
        this.dataSource = rebinnable1DHistogramData;
        this.initTransientData();
        JASHistStyle jASHistStyle = null;
        if (rebinnable1DHistogramData instanceof HasStyle) {
            jASHistStyle = ((HasStyle)((Object)rebinnable1DHistogramData)).getStyle();
        }
        if (jASHistStyle == null) {
            jASHistStyle = new JASHist1DHistogramStyle();
        }
        this.setStyle(jASHistStyle);
    }

    private void initTransientData() {
        this.yLimitsValid = false;
        this.isBinned = false;
    }

    public void setStyle(JASHistStyle jASHistStyle) {
        if (!(jASHistStyle instanceof JASHist1DHistogramStyle)) {
            throw new IllegalArgumentException("Style is not subclass of JASHist1DHistogramStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHist1DHistogramStyle)jASHistStyle;
        this.style.addObserver(this);
    }

    public String getTitle() {
        return this.dataSource.getTitle();
    }

    String[] getAxisLabels() {
        return this.dataSource.getAxisLabels();
    }

    Overlay createOverlay() {
        return new OneDOverlay(this);
    }

    public void writeAsXML(XMLPrintWriter xMLPrintWriter, boolean bl) {
        xMLPrintWriter.setAttribute("axis", "y" + this.getYAxis());
        xMLPrintWriter.openTag("data1d");
        String string = XMLPrintWriter.convertAxisTypeToString(this.getAxisType());
        if (bl) {
            String[] stringArray;
            boolean bl2;
            xMLPrintWriter.setAttribute("title", this.getTitle());
            xMLPrintWriter.openTag("bins1d");
            Rebinnable1DHistogramData rebinnable1DHistogramData = (Rebinnable1DHistogramData)this.getFittableDataSource();
            double[][] dArray = rebinnable1DHistogramData.rebin(rebinnable1DHistogramData.getBins(), rebinnable1DHistogramData.getMin(), rebinnable1DHistogramData.getMax(), true, true);
            if (dArray == null) {
                dArray = new double[1][rebinnable1DHistogramData.getBins()];
            }
            double[] dArray2 = dArray[0];
            double[] dArray3 = new double[]{};
            double[] dArray4 = new double[]{};
            boolean bl3 = dArray.length > 1;
            boolean bl4 = bl2 = dArray.length > 2;
            if (bl3) {
                dArray3 = dArray[1];
                if (bl2) {
                    dArray4 = dArray[2];
                }
            }
            int n = 0;
            while (n < dArray2.length) {
                xMLPrintWriter.print("" + dArray2[n]);
                if (bl3 && dArray3.length > n) {
                    xMLPrintWriter.print("," + dArray3[n]);
                    if (bl2 && dArray4.length > n) {
                        xMLPrintWriter.println("," + dArray4[n]);
                    } else {
                        xMLPrintWriter.println();
                    }
                } else {
                    xMLPrintWriter.println();
                }
                ++n;
            }
            xMLPrintWriter.closeTag();
            xMLPrintWriter.printBinnedDataAxisAttributes("x", "" + rebinnable1DHistogramData.getMin(), "" + rebinnable1DHistogramData.getMax(), "" + rebinnable1DHistogramData.getBins(), string);
            if (string.equals("string")) {
                xMLPrintWriter.setAttribute("type", "x0");
                xMLPrintWriter.openTag("axisLabels");
                stringArray = this.getAxisLabels();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    xMLPrintWriter.setAttribute("value", stringArray[n2]);
                    xMLPrintWriter.printTag("axisLabel");
                    ++n2;
                }
                xMLPrintWriter.closeTag();
            }
            if (this.dataSource instanceof HasStatistics && (stringArray = ((HasStatistics)((Object)this.dataSource)).getStatistics()) != null) {
                xMLPrintWriter.openTag("statistics");
                String[] stringArray2 = stringArray.getStatisticNames();
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    String string2 = stringArray2[n3];
                    double d = stringArray.getStatistic(string2);
                    xMLPrintWriter.setAttribute("name", string2);
                    xMLPrintWriter.setAttribute("value", d);
                    xMLPrintWriter.printTag("statistic");
                    ++n3;
                }
                xMLPrintWriter.closeTag();
            }
        } else if (this.dataSource instanceof HasXMLRepresentation) {
            ((HasXMLRepresentation)((Object)this.dataSource)).writeAsXML(xMLPrintWriter);
        } else {
            if (this.dataSource instanceof HasDataSource) {
                xMLPrintWriter.setAttribute("name", this.dataSource.getClass().getName());
            } else {
                xMLPrintWriter.setAttribute("name", "???");
            }
            xMLPrintWriter.setAttribute("param", "???");
            xMLPrintWriter.printTag("class");
        }
        xMLPrintWriter.setAttribute("histogramBarsFilled", this.style.getHistogramFill());
        xMLPrintWriter.setAttribute("histogramBarColor", ColorConverter.colorToString(this.style.getHistogramBarColor()));
        xMLPrintWriter.setAttribute("errorBarColor", ColorConverter.colorToString(this.style.getErrorBarColor()));
        xMLPrintWriter.setAttribute("dataPointColor", ColorConverter.colorToString(this.style.getDataPointColor()));
        xMLPrintWriter.setAttribute("dataPointStyle", XMLPrintWriter.convertStyleToString(this.style.getDataPointStyle()));
        xMLPrintWriter.setAttribute("dataPointSize", this.style.getDataPointSize());
        xMLPrintWriter.setAttribute("lineColor", ColorConverter.colorToString(this.style.getLineColor()));
        xMLPrintWriter.setAttribute("showHistogramBars", this.style.getShowHistogramBars());
        xMLPrintWriter.setAttribute("showErrorBars", this.style.getShowErrorBars());
        xMLPrintWriter.setAttribute("showDataPoints", this.style.getShowDataPoints());
        xMLPrintWriter.setAttribute("showLinesBetweenPoints", this.style.getShowLinesBetweenPoints());
        xMLPrintWriter.printTag("style1d");
        xMLPrintWriter.closeTag();
    }

    boolean isRebinnable() {
        return this.dataSource.isRebinnable();
    }

    double getXMin() {
        return this.dataSource.getMin();
    }

    double getXMax() {
        return this.dataSource.getMax();
    }

    void setXRange(int n, double d, double d2) {
        if (this.isRebinnable()) {
            if (n != this.xBins || d != this.xLow || d2 != this.xHigh) {
                this.xBins = n;
                this.isBinned = false;
            }
        } else {
            this.xBins = this.dataSource.getBins();
        }
        this.yLimitsValid = false;
        this.xLow = d;
        this.xHigh = d2;
    }

    private void doBin() {
        double d;
        double d2;
        int n = this.dataSource.getAxisType();
        String[] stringArray = null;
        if (n == 2) {
            stringArray = this.dataSource.getAxisLabels();
            this.xBins = stringArray.length;
            d2 = 0.0;
            d = stringArray.length;
        } else if (this.isRebinnable()) {
            d2 = this.xLow;
            d = this.xHigh;
        } else {
            d2 = this.dataSource.getMin();
            d = this.dataSource.getMax();
        }
        this.isBinned = true;
        double[][] dArray = this.dataSource.rebin(this.xBins, d2, d, true, false);
        if (dArray == null) {
            dArray = new double[1][this.xBins];
        }
        this.data = dArray[0];
        if (this.data.length != this.xBins) {
            System.err.println("Warning xbins=" + this.xBins + " data.length=" + this.data.length);
        }
        if (dArray.length > 1) {
            this.plusError = dArray[1];
            this.minusError = dArray.length > 2 ? dArray[2] : this.plusError;
        } else {
            this.plusError = new double[this.xBins];
            int n2 = 0;
            while (n2 < this.xBins) {
                this.plusError[n2] = Math.sqrt(Math.abs(this.data[n2]));
                ++n2;
            }
            this.minusError = this.plusError;
        }
        if (this.plusError.length != this.xBins) {
            System.err.println("Warning xbins=" + this.xBins + " plusError.length=" + this.plusError.length);
        }
        if (this.minusError.length != this.xBins) {
            System.err.println("Warning xbins=" + this.xBins + " minusError.length=" + this.minusError.length);
        }
        if (this.normalization != null) {
            double d3 = 1.0 / this.normalization.getNormalizationFactor();
            double[] dArray2 = new double[this.xBins];
            double[] dArray3 = new double[this.xBins];
            double[] dArray4 = new double[this.xBins];
            int n3 = 0;
            while (n3 < this.data.length) {
                dArray2[n3] = this.data[n3] * d3;
                dArray3[n3] = this.plusError[n3] * d3;
                dArray4[n3] = this.minusError[n3] * d3;
                ++n3;
            }
            if (this.overlay instanceof OneDOverlay) {
                if (n == 2) {
                    ((OneDOverlay)this.overlay).setData(dArray2, dArray3, dArray4, stringArray);
                } else {
                    ((OneDOverlay)this.overlay).setData(dArray2, dArray3, dArray4, d2, d);
                }
            }
        } else if (this.overlay instanceof OneDOverlay) {
            if (n == 2) {
                ((OneDOverlay)this.overlay).setData(this.data, this.plusError, this.minusError, stringArray);
            } else {
                ((OneDOverlay)this.overlay).setData(this.data, this.plusError, this.minusError, d2, d);
            }
        }
        this.fittableDataSource.binningChanged();
    }

    /*
     * Unable to fully structure code
     */
    private void calcYLimits() {
        if (!this.isBinned) {
            this.doBin();
        }
        this.yLimitsValid = true;
        var1_1 = 0;
        this.yLow = 1.7976931348623157E308;
        this.yHigh = -1.7976931348623157E308;
        var2_2 = this.style.getShowErrorBars();
        if (this.isRebinnable()) ** GOTO lbl-1000
        if (this.dataSource.getAxisType() != 2) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        var3_3 = v0;
        var4_4 = this.getXMin();
        var6_5 = (this.getXMax() - this.getXMin()) / (double)this.xBins;
        var8_6 = 0;
        while (var8_6 < this.xBins) {
            block12: {
                block11: {
                    if (!var3_3) break block11;
                    var9_7 = var4_4;
                    var11_8 = var4_4 += var6_5;
                    if (var11_8 < this.xLow || var9_7 > this.xHigh) break block12;
                }
                if (!Double.isNaN(var9_7 = this.data[var8_6])) {
                    ++var1_1;
                    this.yLow = Math.min(this.yLow, var9_7 - (var2_2 != false ? this.minusError[var8_6] : 0.0));
                    this.yHigh = Math.max(this.yHigh, var9_7 + (var2_2 != false ? this.plusError[var8_6] : 0.0));
                }
            }
            ++var8_6;
        }
        if (var1_1 == 0) {
            this.yLow = 0.0;
            this.yHigh = 1.0;
        } else if (this.normalization != null) {
            var9_7 = 1.0 / this.normalization.getNormalizationFactor();
            this.yLow *= var9_7;
            this.yHigh *= var9_7;
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this.dataSource) {
            HistogramUpdate histogramUpdate = (HistogramUpdate)object;
            if (!this.isBinned || this.countObservers() == 0) {
                this.fittableDataSource.update(object);
            }
            this.isBinned = false;
            this.yLimitsValid = false;
            this.parent.update(histogramUpdate, this);
        } else if (observable == this.style) {
            this.yLimitsValid = false;
            this.parent.styleUpdate(this);
        } else if (observable == this.normalization) {
            this.normalizationChanged(false);
        }
    }

    void normalizationChanged(boolean bl) {
        HistogramUpdate histogramUpdate = new HistogramUpdate(2, bl);
        if (!this.isBinned || this.countObservers() == 0) {
            this.fittableDataSource.update(histogramUpdate);
        }
        this.isBinned = false;
        this.yLimitsValid = false;
        this.parent.update(histogramUpdate, this);
    }

    public boolean hasChanged() {
        return !this.isBinned;
    }

    double getYMin() {
        if (!this.yLimitsValid) {
            this.calcYLimits();
        }
        return this.yLow;
    }

    double getYMax() {
        if (!this.yLimitsValid) {
            this.calcYLimits();
        }
        return this.yHigh;
    }

    void validate() {
        if (!this.isBinned) {
            this.doBin();
        }
    }

    void axisChanged() {
        this.parent.axisChanged(this);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSource getFittableDataSource() {
        return this.fittableDataSource;
    }

    public boolean getBinnable() {
        return true;
    }

    public int getBins() {
        return this.dataSource.getBins();
    }

    int getAxisType() {
        return this.dataSource.getAxisType();
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    void destroy() {
        if (this.dataSource instanceof Observable) {
            ((Observable)((Object)this.dataSource)).deleteObserver(this);
        }
        this.style.deleteObserver(this);
        super.destroy();
    }

    class FittableDataSource
    extends Observable
    implements Rebinnable1DHistogramData,
    Serializable {
        FittableDataSource() {
        }

        public String[] getAxisLabels() {
            return JASHist1DHistogramData.this.dataSource.getAxisLabels();
        }

        public int getAxisType() {
            return JASHist1DHistogramData.this.dataSource.getAxisType();
        }

        public int getBins() {
            if (JASHist1DHistogramData.this.isBinned) {
                return JASHist1DHistogramData.this.xBins;
            }
            return JASHist1DHistogramData.this.dataSource.getBins();
        }

        public double getMax() {
            if (JASHist1DHistogramData.this.isBinned) {
                return JASHist1DHistogramData.this.xHigh;
            }
            return JASHist1DHistogramData.this.dataSource.getMax();
        }

        public double getMin() {
            if (JASHist1DHistogramData.this.isBinned) {
                return JASHist1DHistogramData.this.xLow;
            }
            return JASHist1DHistogramData.this.dataSource.getMin();
        }

        public String getTitle() {
            return JASHist1DHistogramData.this.dataSource.getTitle();
        }

        public boolean isRebinnable() {
            if (JASHist1DHistogramData.this.isBinned) {
                return false;
            }
            return JASHist1DHistogramData.this.dataSource.isRebinnable();
        }

        public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
            if (JASHist1DHistogramData.this.isBinned) {
                double[][] dArrayArray = new double[][]{JASHist1DHistogramData.this.data, JASHist1DHistogramData.this.plusError, JASHist1DHistogramData.this.minusError};
                return dArrayArray;
            }
            return JASHist1DHistogramData.this.dataSource.rebin(n, d, d2, bl, bl2);
        }

        void update(Object object) {
            this.setChanged();
            this.notifyObservers(object);
        }

        void binningChanged() {
            this.setChanged();
            this.notifyObservers(hu);
        }

        JASHist1DHistogramData parent() {
            return JASHist1DHistogramData.this;
        }
    }
}

