/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.BinnedDataManager;
import jas.hist.DataManagerException;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.StatisticsBlock;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import java.io.IOException;
import java.io.ObjectInputStream;

class DoubleDataManager
extends BinnedDataManager {
    private DoubleAxis xAxis = new DoubleAxis();

    DoubleDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock, int n) {
        super(jASHist, dataArea, legend, statisticsBlock, n);
        DoubleAxis doubleAxis = new DoubleAxis();
        doubleAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, false, doubleAxis);
        new BinnedDataManager.DoubleAxisListener(this.xm);
        this.xm.setBins(n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        new BinnedDataManager.DoubleAxisListener(this.xm);
    }

    final JASHistData add(DataSource dataSource) {
        Rebinnable1DHistogramData rebinnable1DHistogramData = (Rebinnable1DHistogramData)dataSource;
        if (rebinnable1DHistogramData.getAxisType() != 1) {
            throw new DataManagerException("Incompatible data type for axis");
        }
        return super.add(rebinnable1DHistogramData);
    }

    protected final void calcMinMaxBins(double d, double d2) {
        double d3 = this.xAxis.getPlotMin();
        double d4 = this.xAxis.getPlotMax();
        if (d != d3 || d2 != d4) {
            this.xAxis.setMin(d);
            this.xAxis.setMax(d2);
            this.xm.invalidate();
        }
    }
}

