/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas.hist.Basic1DFunction;
import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.FunctionAdvancedOptions;
import jas.hist.FunctionValueUndefined;
import jas.hist.InvalidFunctionParameter;
import jas.hist.JASHist;
import jas.util.JASDialog;
import jasext.hist.function.SumOfFunctionsException;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

class SumOfFunctions
extends Fittable1DFunction
implements Observer,
FunctionAdvancedOptions {
    private Vector funcs = new Vector();
    private int m_nParams;
    private int[] m_param;
    private boolean[] included;

    SumOfFunctions() {
    }

    void addFunction(Basic1DFunction basic1DFunction) {
        this.funcs.addElement(basic1DFunction);
        basic1DFunction.addObserver(this);
        this.mapParams();
    }

    void removeFunction(Basic1DFunction basic1DFunction) {
        basic1DFunction.deleteObserver(this);
        this.reSetIncluded(this.funcs.indexOf(basic1DFunction));
        this.funcs.removeElement(basic1DFunction);
        this.mapParams();
    }

    void removeAllFunctions() {
        Enumeration enumeration = this.funcs.elements();
        while (enumeration.hasMoreElements()) {
            Basic1DFunction basic1DFunction = (Basic1DFunction)enumeration.nextElement();
            basic1DFunction.deleteObserver(this);
        }
        this.funcs.removeAllElements();
        this.mapParams();
    }

    Enumeration getFunctions() {
        return this.funcs.elements();
    }

    public double valueAt(double d) throws FunctionValueUndefined {
        double d2 = 0.0;
        int n = 0;
        Enumeration enumeration = this.funcs.elements();
        while (enumeration.hasMoreElements()) {
            if (this.included[n++]) {
                Basic1DFunction basic1DFunction = (Basic1DFunction)enumeration.nextElement();
                d2 += basic1DFunction.valueAt(d);
                continue;
            }
            enumeration.nextElement();
        }
        return d2;
    }

    public String[] getParameterNames() {
        String[] stringArray = new String[this.m_nParams];
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.funcs.elements();
        while (enumeration.hasMoreElements()) {
            if (this.included[n2++]) {
                Basic1DFunction basic1DFunction = (Basic1DFunction)enumeration.nextElement();
                String[] stringArray2 = basic1DFunction.getParameterNames();
                String string = basic1DFunction.getTitle();
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    stringArray[n++] = string + ": " + stringArray2[n3];
                    ++n3;
                }
                continue;
            }
            enumeration.nextElement();
        }
        return stringArray;
    }

    public double[] getParameterValues() {
        double[] dArray = new double[this.m_nParams];
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.funcs.elements();
        while (enumeration.hasMoreElements()) {
            if (this.included[n2++]) {
                Basic1DFunction basic1DFunction = (Basic1DFunction)enumeration.nextElement();
                double[] dArray2 = basic1DFunction.getParameterValues();
                int n3 = 0;
                while (n3 < dArray2.length) {
                    dArray[n++] = dArray2[n3];
                    ++n3;
                }
                continue;
            }
            enumeration.nextElement();
        }
        return dArray;
    }

    public void setParameter(int n, double d) throws InvalidFunctionParameter {
        if (n >= this.m_nParams) {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        int n2 = 0;
        while (n2 < this.m_param.length) {
            if (n < this.m_param[n2]) {
                Basic1DFunction basic1DFunction = (Basic1DFunction)this.funcs.elementAt(n2);
                basic1DFunction.setParameter(n, d);
                return;
            }
            n -= this.m_param[n2];
            ++n2;
        }
        this.clearFit();
        this.setChanged();
    }

    public void setFit(Fitter fitter, double[] dArray) throws InvalidFunctionParameter {
        if (dArray.length != this.m_nParams) {
            throw new IllegalArgumentException("Array passed to setParameters is of wrong length");
        }
        int n = 0;
        int n2 = 0;
        try {
            try {
                int n3 = 0;
                while (n3 < this.m_param.length) {
                    double[] dArray2 = new double[this.m_param[n3]];
                    System.arraycopy(dArray, n, dArray2, 0, this.m_param[n3]);
                    while (!this.included[n2]) {
                        ++n2;
                    }
                    Fittable1DFunction fittable1DFunction = (Fittable1DFunction)this.funcs.elementAt(n2++);
                    fittable1DFunction.setFit(null, dArray2);
                    n += this.m_param[n3];
                    ++n3;
                }
                this.setFit(fitter);
                this.setChanged();
            }
            catch (ClassCastException classCastException) {
                throw new SumOfFunctionsException("Sum is not fittable since at least one component function is not fittable");
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            throw throwable;
        }
    }

    public double valueAt(double d, double[] dArray) throws FunctionValueUndefined {
        if (dArray.length != this.m_nParams) {
            throw new IllegalArgumentException("Array passed to valueAt is of wrong length");
        }
        int n = 0;
        int n2 = 0;
        double d2 = 0.0;
        try {
            int n3 = 0;
            while (n3 < this.m_param.length) {
                double[] dArray2 = new double[this.m_param[n3]];
                System.arraycopy(dArray, n, dArray2, 0, this.m_param[n3]);
                while (!this.included[n2]) {
                    ++n2;
                }
                Fittable1DFunction fittable1DFunction = (Fittable1DFunction)this.funcs.elementAt(n2++);
                d2 += fittable1DFunction.valueAt(d, dArray2);
                n += this.m_param[n3];
                ++n3;
            }
        }
        catch (ClassCastException classCastException) {
            throw new SumOfFunctionsException("Sum is not fittable since at least one component function is not fittable");
        }
        return d2;
    }

    public String getTitle() {
        String string = null;
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.funcs.elements();
        while (enumeration.hasMoreElements()) {
            if (this.included[n++]) {
                ++n2;
                Basic1DFunction basic1DFunction = (Basic1DFunction)enumeration.nextElement();
                if (string == null) {
                    string = basic1DFunction.getTitle();
                    continue;
                }
                string = string + "+" + basic1DFunction.getTitle();
                continue;
            }
            enumeration.nextElement();
        }
        if (n2 > 1) {
            return string;
        }
        if (n2 == 1) {
            return string + " (Sum)";
        }
        return "Sum of nothing";
    }

    public void update(Observable observable, Object object) {
        if ("remove".equals(object)) {
            this.removeFunction((Basic1DFunction)observable);
        }
        this.mapParams();
        this.clearFit();
        this.setChanged();
    }

    private void mapParams() {
        int n = 0;
        int n2 = 0;
        this.m_nParams = 0;
        int n3 = this.funcs.size();
        if (this.included != null) {
            int n4 = 0;
            while (n4 < this.included.length) {
                if (!this.included[n4]) {
                    --n3;
                }
                ++n4;
            }
        }
        this.m_param = new int[n3];
        Enumeration enumeration = this.funcs.elements();
        while (enumeration.hasMoreElements()) {
            if (this.included == null || this.included[n2++]) {
                Basic1DFunction basic1DFunction = (Basic1DFunction)enumeration.nextElement();
                int n5 = basic1DFunction.getParameterValues().length;
                this.m_param[n++] = n5;
                this.m_nParams += n5;
                continue;
            }
            enumeration.nextElement();
        }
        this.initIncludeParametersInFit(this.m_nParams);
    }

    void setIncluded(int n) {
        this.included = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.included[n2] = true;
            ++n2;
        }
    }

    private void reSetIncluded(int n) {
        boolean[] blArray = new boolean[this.included.length - 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.included.length) {
            if (n3 != n) {
                blArray[n2++] = this.included[n3];
            }
            ++n3;
        }
        this.included = blArray;
    }

    public void openAdvancedDialog(Frame frame, JASHist jASHist) {
        new SumOfFunctionsAdvancedDialog(frame);
    }

    private class SumOfFunctionsAdvancedDialog
    extends JASDialog {
        SumOfFunctionsAdvancedDialog(Frame frame) {
            super(frame, "Advanced...", true, 1);
            int n = SumOfFunctions.this.funcs.size();
            Container container = this.getContentPane();
            JCheckBox[] jCheckBoxArray = new JCheckBox[n];
            container.setLayout(new GridLayout(n + 1, 1));
            container.add(new JLabel("Select functions to include:"));
            int n2 = 0;
            while (n2 < n) {
                Basic1DFunction basic1DFunction = (Basic1DFunction)SumOfFunctions.this.funcs.elementAt(n2);
                jCheckBoxArray[n2] = new JCheckBox(String.valueOf(n2 + 1) + " " + basic1DFunction.getTitle(), SumOfFunctions.this.included[n2]);
                jCheckBoxArray[n2].addActionListener(new EnumeratedJCheckBoxListener(n2));
                jCheckBoxArray[n2].setMnemonic(48 + (char)(n2 + 1));
                container.add(jCheckBoxArray[n2]);
                ++n2;
            }
            this.pack();
            ((Dialog)((Object)this)).setResizable(false);
            this.show();
        }

        private class EnumeratedJCheckBoxListener
        implements ActionListener {
            private int i;

            EnumeratedJCheckBoxListener(int n) {
                this.i = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((SumOfFunctions)((SumOfFunctionsAdvancedDialog)SumOfFunctionsAdvancedDialog.this).SumOfFunctions.this).included[this.i] = !SumOfFunctions.this.included[this.i];
                SumOfFunctions.this.mapParams();
                SumOfFunctions.this.setChanged();
                SumOfFunctions.this.clearFit();
            }
        }
    }
}

