/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.Handle;
import jas.hist.HasHandles;

public class StraightLineFunction
extends Fittable1DFunction
implements HasHandles {
    private double[] p = new double[2];

    StraightLineFunction(double d, double d2) {
        this.p[0] = d;
        this.p[1] = d2;
    }

    public StraightLineFunction(double d, double d2, double d3, double d4) {
        this.p[0] = d2 != d ? (d4 - d3) / (d2 - d) : 0.0;
        this.p[1] = d3 - d * this.p[0];
    }

    public double valueAt(double d) {
        return this.valueAt(d, this.p);
    }

    public double valueAt(double d, double[] dArray) {
        return dArray[1] + d * dArray[0];
    }

    private double valueFor(double d) {
        return (d - this.p[1]) / this.p[0];
    }

    public String[] getParameterNames() {
        String[] stringArray = new String[]{"slope", "yoffset"};
        return stringArray;
    }

    public double[] getParameterValues() {
        return this.p;
    }

    public void setParameter(int n, double d) {
        if (n > this.p.length) {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.p[n] = d;
        this.clearFit();
        this.setChanged();
    }

    public void setFit(Fitter fitter, double[] dArray) {
        if (dArray.length != this.p.length) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        System.arraycopy(dArray, 0, this.p, 0, this.p.length);
        this.setFit(fitter);
        this.setChanged();
    }

    public String getTitle() {
        return "Straight Line";
    }

    public Handle[] getHandles(double d, double d2, double d3, double d4) {
        int n = 0;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        double d5 = d;
        double d6 = this.valueAt(d5);
        if (d6 >= d3 && d6 <= d4) {
            dArray[n] = d5;
            dArray2[n] = d6;
            ++n;
        }
        if ((d6 = this.valueAt(d5 = d2)) >= d3 && d6 <= d4) {
            dArray[n] = d5;
            dArray2[n] = d6;
            ++n;
        }
        if ((d5 = this.valueFor(d6 = d3)) > d && d5 < d2) {
            dArray[n] = d5;
            dArray2[n] = d6;
            ++n;
        }
        if ((d5 = this.valueFor(d6 = d4)) > d && d5 < d2) {
            dArray[n] = d5;
            dArray2[n] = d6;
            ++n;
        }
        if (n == 2) {
            Handle[] handleArray = new SLHandle[]{new SLHandle(dArray[0] + (dArray[1] - dArray[0]) * 0.1, dArray2[0] + (dArray2[1] - dArray2[0]) * 0.1), new SLHandle(dArray[0] + (dArray[1] - dArray[0]) * 0.9, dArray2[0] + (dArray2[1] - dArray2[0]) * 0.9)};
            handleArray[0].setPartner(handleArray[1]);
            handleArray[1].setPartner(handleArray[0]);
            return handleArray;
        }
        return new Handle[0];
    }

    private class SLHandle
    extends Handle {
        private double x;
        private double y;
        private SLHandle partner;

        SLHandle(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        void setPartner(SLHandle sLHandle) {
            this.partner = sLHandle;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void moveTo(double d, double d2) {
            this.x = d;
            this.y = d2;
            ((StraightLineFunction)StraightLineFunction.this).p[0] = this.partner.x != d ? (this.partner.y - d2) / (this.partner.x - d) : 0.0;
            ((StraightLineFunction)StraightLineFunction.this).p[1] = d2 - d * StraightLineFunction.this.p[0];
            StraightLineFunction.this.clearFit();
            StraightLineFunction.this.setChanged();
        }
    }
}

