/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas.hist.Basic1DFunction;
import jas.hist.FunctionAdvancedOptions;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.Rebinnable1DHistogramData;
import jas.util.JASDialog;
import jas.util.JASTextField;
import jasext.hist.function.Spline;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplineFunction
extends Basic1DFunction
implements FunctionAdvancedOptions {
    private Spline spline;
    private double smoothness;
    final double initialSmoothness = 10.0;

    public String[] getParameterNames() {
        String[] stringArray = new String[]{"Smoothness"};
        return stringArray;
    }

    public double[] getParameterValues() {
        double[] dArray = new double[]{this.smoothness};
        return dArray;
    }

    public String getTitle() {
        return "Cubic Spline";
    }

    public void setParameter(int n, double d) {
        this.smoothness = d;
        this.setChanged();
    }

    public double valueAt(double d) {
        return this.spline.get(d);
    }

    private void init(Rebinnable1DHistogramData rebinnable1DHistogramData) {
        double[] dArray;
        this.smoothness = 10.0;
        int n = rebinnable1DHistogramData.getBins();
        double d = rebinnable1DHistogramData.getMin();
        double d2 = rebinnable1DHistogramData.getMax();
        double d3 = (d2 - d) / (double)n;
        double[][] dArray2 = rebinnable1DHistogramData.rebin(n, d, d2, true, false);
        double[] dArray3 = new double[n];
        double[] dArray4 = dArray2[0];
        if (dArray2.length > 2 && dArray2[1] != dArray2[2]) {
            throw new RuntimeException("Cannot create spline fit for data with asymetric error bars");
        }
        double d4 = d + d3 / 2.0;
        int n2 = 0;
        while (n2 < n) {
            dArray3[n2] = d4;
            d4 += d3;
            ++n2;
        }
        if (dArray2.length > 1) {
            dArray = dArray2[1];
        } else {
            dArray = new double[n];
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = Math.sqrt(dArray4[n3]);
                ++n3;
            }
        }
        double d5 = d - 1.0;
        this.spline = new Spline(n, d5);
        int n4 = 0;
        while (n4 < n) {
            if (dArray[n4] > 0.0) {
                this.spline.add(dArray3[n4], dArray4[n4], dArray[n4]);
            }
            ++n4;
        }
        this.spline.calcApproximation(this.smoothness);
    }

    SplineFunction(Rebinnable1DHistogramData rebinnable1DHistogramData) {
        this.init(rebinnable1DHistogramData);
    }

    private synchronized void setSmoothness(double d) {
        this.smoothness = d;
        this.spline.calcApproximation(this.smoothness);
        this.setChanged();
    }

    public void openAdvancedDialog(Frame frame, JASHist jASHist) {
        new SplineFunctionAdvancedDialog(frame, jASHist);
    }

    private double getSmoothness() {
        return this.smoothness;
    }

    static /* synthetic */ void access$300(SplineFunction splineFunction, double d) {
        splineFunction.setSmoothness(d);
    }

    static /* synthetic */ void access$500(SplineFunction splineFunction, Rebinnable1DHistogramData rebinnable1DHistogramData) {
        splineFunction.init(rebinnable1DHistogramData);
    }

    private class SplineFunctionAdvancedDialog
    extends JASDialog {
        private final NumberFormat format = NumberFormat.getInstance();
        final int sliderMin = 10;
        final int sliderMax = 1000;
        final double maxSmoothness = 100.0;
        final double minSmoothness = 1.0;
        double smoothness;

        private int toInt(double d) {
            double d2 = (d - 1.0) / 99.0;
            int n = (int)(d2 * 990.0);
            return n + 10;
        }

        SplineFunctionAdvancedDialog(Frame frame, JASHist jASHist) {
            super(frame, "Advanced...", true, 1);
            Object object;
            this.format.setMaximumFractionDigits(5);
            this.smoothness = SplineFunction.this.getSmoothness();
            JSlider jSlider = new JSlider(0, 10, 1000, this.toInt(this.smoothness));
            JASTextField jASTextField = new JASTextField(String.valueOf(this.smoothness), 5);
            jASTextField.addActionListener(new ActionListener(this, jASTextField, jSlider){
                private final /* synthetic */ JASTextField val$tf;
                private final /* synthetic */ JSlider val$s;
                private final /* synthetic */ SplineFunctionAdvancedDialog this$1;
                {
                    this.this$1 = splineFunctionAdvancedDialog;
                    this.val$tf = jASTextField;
                    this.val$s = jSlider;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        this.this$1.smoothness = Double.valueOf(this.val$tf.getText());
                        if (this.this$1.smoothness < 0.0) {
                            this.this$1.smoothness = 0.0;
                        }
                        double d = this.this$1.smoothness;
                        this.val$s.setValue(SplineFunctionAdvancedDialog.access$100(this.this$1, this.this$1.smoothness));
                        this.val$tf.setText(String.valueOf(d));
                        this.this$1.smoothness = d;
                        SplineFunction.access$300(SplineFunctionAdvancedDialog.access$200(this.this$1), this.this$1.smoothness);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            jSlider.addChangeListener(new ChangeListener(this, jSlider, jASTextField){
                private final /* synthetic */ JSlider val$s;
                private final /* synthetic */ JASTextField val$tf;
                private final /* synthetic */ SplineFunctionAdvancedDialog this$1;
                {
                    this.this$1 = splineFunctionAdvancedDialog;
                    this.val$s = jSlider;
                    this.val$tf = jASTextField;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = this.val$s.getValue() - 10;
                    double d = (double)n / 990.0;
                    this.this$1.smoothness = 1.0 + 99.0 * d;
                    SplineFunction.access$300(SplineFunctionAdvancedDialog.access$200(this.this$1), this.this$1.smoothness);
                    this.val$tf.setText(SplineFunctionAdvancedDialog.access$400(this.this$1).format(this.this$1.smoothness));
                }
            });
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = jASHist.getDataSources();
            while (enumeration.hasMoreElements()) {
                object = (JASHistData)enumeration.nextElement();
                if (!(object.getDataSource() instanceof Rebinnable1DHistogramData)) continue;
                vector.addElement(object);
            }
            object = new JComboBox(vector);
            ((JComboBox)object).addItemListener(new ItemListener(this){
                private final /* synthetic */ SplineFunctionAdvancedDialog this$1;
                {
                    this.this$1 = splineFunctionAdvancedDialog;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    JASHistData jASHistData = (JASHistData)itemEvent.getItem();
                    SplineFunction.access$500(SplineFunctionAdvancedDialog.access$200(this.this$1), (Rebinnable1DHistogramData)jASHistData.getFittableDataSource());
                    SplineFunctionAdvancedDialog.access$200(this.this$1).setChanged();
                }
            });
            Container container = this.getContentPane();
            container.setLayout(new GridLayout(6, 1));
            container.add(new JLabel("Set spline smoothness."));
            container.add(new JLabel("Slider range is 1.0 to 100.0"));
            container.add(jSlider);
            container.add((Component)jASTextField);
            container.add(new JLabel("Select data source:"));
            container.add((Component)object);
            this.pack();
            this.show();
        }

        static /* synthetic */ int access$100(SplineFunctionAdvancedDialog splineFunctionAdvancedDialog, double d) {
            return splineFunctionAdvancedDialog.toInt(d);
        }

        static /* synthetic */ SplineFunction access$200(SplineFunctionAdvancedDialog splineFunctionAdvancedDialog) {
            return splineFunctionAdvancedDialog.SplineFunction.this;
        }

        static /* synthetic */ NumberFormat access$400(SplineFunctionAdvancedDialog splineFunctionAdvancedDialog) {
            return splineFunctionAdvancedDialog.format;
        }
    }
}

