/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

class Spline {
    public int lastElement;
    public double[] x;
    public double[] y;
    public double[] f;
    double[] d1f;
    double[] d2f;
    double[] d3f;
    double[] dy;
    double[][] v;
    double emptyCode;

    public Spline(int n, double d) {
        this.x = new double[n];
        this.y = new double[n];
        this.dy = new double[n];
        this.f = new double[n];
        this.d1f = new double[n];
        this.d2f = new double[n];
        this.d3f = new double[n];
        this.v = new double[n][7];
        this.emptyCode = d;
        this.lastElement = -1;
    }

    public void add(double d, double d2) {
        if (d2 > this.emptyCode) {
            ++this.lastElement;
            this.x[this.lastElement] = d;
            this.y[this.lastElement] = d2;
            this.dy[this.lastElement] = 0.0;
        }
    }

    public void add(double d, double d2, double d3) {
        if (d2 > this.emptyCode) {
            this.add(d, d2);
            this.dy[this.lastElement] = d3;
        }
    }

    public void calcApproximation(double d) {
        if (this.lastElement > 0) {
            if (this.lastElement < 2) {
                int n = 0;
                while (n < this.lastElement) {
                    this.f[n] = this.y[n];
                    this.d1f[n] = (this.y[n + 1] - this.y[n]) / (this.x[n + 1] - this.x[n]);
                    this.d2f[n] = 0.0;
                    this.d3f[n] = 0.0;
                    ++n;
                }
                this.f[this.lastElement] = this.y[this.lastElement];
            } else {
                int n;
                double d2;
                int n2 = 100;
                double d3 = 0.0;
                double d4 = 0.0;
                this.SetupQ();
                if (d > 0.0) {
                    d3 = 0.0;
                    this.Chol1D(d3);
                    d2 = 0.0;
                    int n3 = 0;
                    while (n3 <= this.lastElement) {
                        d2 += Math.pow(this.f[n3] * this.dy[n3], 2.0);
                        ++n3;
                    }
                    if ((d2 *= 36.0) > d) {
                        boolean bl;
                        double d5 = 0.0;
                        n = 1;
                        while (n <= this.lastElement) {
                            d5 += this.v[n - 1][3] * (this.d2f[n - 1] * (this.d2f[n - 1] + this.d2f[n]) + Math.pow(this.d2f[n], 2.0));
                            ++n;
                        }
                        double d6 = 1.0 / Math.sqrt(d);
                        double d7 = 1.0 / Math.sqrt(d2);
                        d4 = -(d7 - d6) * d2 / (6.0 * d5 * d7);
                        double d8 = 0.0;
                        double d9 = d7;
                        int n4 = 0;
                        do {
                            this.Chol1D(d4 / (1.0 + d4));
                            ++n4;
                            d2 = 0.0;
                            int n5 = 0;
                            while (n5 <= this.lastElement) {
                                d2 += Math.pow(this.f[n5] * this.dy[n5], 2.0);
                                ++n5;
                            }
                            bl = Math.abs((d2 = d2 * 36.0 / Math.pow(1.0 + d4, 2.0)) - d) <= 0.01 * d;
                            if (bl) continue;
                            d7 = 1.0 / Math.sqrt(d2);
                            double d10 = (d4 - d8) / (d7 - d9) * (d7 - d6);
                            d8 = d4;
                            d4 -= d10;
                            d9 = d7;
                        } while (!bl && n4 <= n2);
                        d3 = d4 / (1.0 + d4);
                    }
                } else {
                    d3 = 1.0;
                    this.Chol1D(d3);
                    d2 = 0.0;
                }
                double d11 = 6.0 / (1.0 + d4);
                int n6 = 0;
                while (n6 <= this.lastElement) {
                    this.f[n6] = this.y[n6] - d11 * Math.pow(this.dy[n6], 2.0) * this.f[n6];
                    ++n6;
                }
                n = 0;
                while (n <= this.lastElement) {
                    int n7 = n++;
                    this.d2f[n7] = this.d2f[n7] * (6.0 * d3);
                }
                int n8 = 0;
                while (n8 < this.lastElement) {
                    this.d3f[n8] = (this.d2f[n8 + 1] - this.d2f[n8]) / this.v[n8][3];
                    this.d1f[n8] = (this.f[n8 + 1] - this.f[n8]) / this.v[n8][3] - (this.d2f[n8] + this.d3f[n8] / 3.0 * this.v[n8][3]) / 2.0 * this.v[n8][3];
                    ++n8;
                }
            }
        }
    }

    void SetupQ() {
        this.v[0][3] = this.x[1] - this.x[0];
        int n = 1;
        while (n < this.lastElement) {
            this.v[n][3] = this.x[n + 1] - this.x[n];
            this.v[n][0] = this.dy[n - 1] / this.v[n - 1][3];
            this.v[n][1] = -this.dy[n] / this.v[n][3] - this.dy[n] / this.v[n - 1][3];
            this.v[n][2] = this.dy[n + 1] / this.v[n][3];
            ++n;
        }
        this.v[this.lastElement][0] = 0.0;
        int n2 = 1;
        while (n2 < this.lastElement) {
            this.v[n2][4] = Math.pow(this.v[n2][0], 2.0) + Math.pow(this.v[n2][1], 2.0) + Math.pow(this.v[n2][2], 2.0);
            ++n2;
        }
        int n3 = 2;
        while (n3 < this.lastElement) {
            this.v[n3 - 1][5] = this.v[n3 - 1][1] * this.v[n3][0] + this.v[n3 - 1][2] * this.v[n3][1];
            ++n3;
        }
        this.v[this.lastElement - 1][5] = 0.0;
        int n4 = 3;
        while (n4 < this.lastElement) {
            this.v[n4 - 2][6] = this.v[n4 - 2][2] * this.v[n4][0];
            ++n4;
        }
        this.v[this.lastElement - 2][6] = 0.0;
        this.v[this.lastElement - 1][6] = 0.0;
        double d = (this.y[1] - this.y[0]) / this.v[0][3];
        int n5 = 1;
        while (n5 < this.lastElement) {
            double d2 = (this.y[n5 + 1] - this.y[n5]) / this.v[n5][3];
            this.d3f[n5] = d2 - d;
            d = d2;
            ++n5;
        }
    }

    void Chol1D(double d) {
        int n;
        double d2 = 6.0 * (1.0 - d);
        int n2 = 1;
        while (n2 < this.lastElement) {
            this.v[n2][0] = d2 * this.v[n2][4] + 2.0 * d * (this.v[n2 - 1][3] + this.v[n2][3]);
            this.v[n2][1] = d2 * this.v[n2][5] + d * this.v[n2][3];
            this.v[n2][2] = d2 * this.v[n2][6];
            ++n2;
        }
        if (this.lastElement >= 3) {
            int n3 = 1;
            while (n3 < this.lastElement - 1) {
                double d3 = this.v[n3][1] / this.v[n3][0];
                double[] dArray = this.v[n3 + 1];
                dArray[0] = dArray[0] - d3 * this.v[n3][1];
                double[] dArray2 = this.v[n3 + 1];
                dArray2[1] = dArray2[1] - d3 * this.v[n3][2];
                this.v[n3][1] = d3;
                d3 = this.v[n3][2] / this.v[n3][0];
                double[] dArray3 = this.v[n3 + 2];
                dArray3[0] = dArray3[0] - d3 * this.v[n3][2];
                this.v[n3][2] = d3;
                ++n3;
            }
            this.d2f[0] = 0.0;
            this.d2f[1] = this.d3f[1];
            this.v[0][2] = 0.0;
            int n4 = 1;
            while (n4 < this.lastElement - 1) {
                this.d2f[n4 + 1] = this.d3f[n4 + 1] - this.v[n4][1] * this.d2f[n4] - this.v[n4 - 1][2] * this.d2f[n4 - 1];
                ++n4;
            }
            this.d2f[this.lastElement] = 0.0;
            this.d2f[this.lastElement - 1] = this.d2f[this.lastElement - 1] / this.v[this.lastElement - 1][0];
            n = this.lastElement - 2;
            while (n > 0) {
                this.d2f[n] = this.d2f[n] / this.v[n][0] - this.d2f[n + 1] * this.v[n][1] - this.d2f[n + 2] * this.v[n][2];
                --n;
            }
        } else {
            this.d2f[0] = 0.0;
            this.d2f[1] = this.d3f[1] / this.v[1][0];
            this.d2f[2] = 0.0;
        }
        double d4 = 0.0;
        n = 1;
        while (n <= this.lastElement) {
            this.f[n] = (this.d2f[n] - this.d2f[n - 1]) / this.v[n - 1][3];
            this.f[n - 1] = this.f[n] - d4;
            d4 = this.f[n];
            ++n;
        }
        this.f[this.lastElement] = -this.f[this.lastElement];
    }

    public void calcInterpolation(boolean bl) {
        if (this.lastElement > 0) {
            double d;
            boolean bl2 = this.lastElement > 1 && bl;
            double d2 = 0.0;
            double d3 = this.x[1] - this.x[0];
            this.v[0][3] = -d3;
            this.v[0][4] = d3 * d3 * d2;
            int n = 1;
            while (n < this.lastElement) {
                d3 = this.x[n + 1] - this.x[n];
                d = this.x[n] - this.x[n - 1];
                this.v[n][3] = 2.0 * (d + d3) - d * d / this.v[n - 1][3];
                this.v[n][4] = (this.y[n + 1] - this.y[n]) / d3 - (this.y[n] - this.y[n - 1]) / d - d * this.v[n - 1][4] / this.v[n - 1][3];
                ++n;
            }
            d = this.x[this.lastElement] - this.x[this.lastElement - 1];
            this.v[this.lastElement][3] = -d - d * d / this.v[this.lastElement - 1][3];
            this.v[this.lastElement][4] = -(d * d) * d2 - d * this.v[this.lastElement - 1][4] / this.v[this.lastElement - 1][3];
            this.d2f[this.lastElement] = bl2 ? this.v[this.lastElement][4] / this.v[this.lastElement][3] : 0.0;
            int n2 = this.lastElement - 1;
            while (n2 >= 0) {
                this.d2f[n2] = bl2 ? (this.v[n2][4] - (this.x[n2 + 1] - this.x[n2]) * this.d2f[n2 + 1]) / this.v[n2][3] : 0.0;
                --n2;
            }
            int n3 = 0;
            while (n3 < this.lastElement) {
                d3 = this.x[n3 + 1] - this.x[n3];
                this.f[n3] = this.y[n3];
                this.d1f[n3] = (this.y[n3 + 1] - this.y[n3]) / d3 - d3 * (this.d2f[n3 + 1] + 2.0 * this.d2f[n3]);
                this.d3f[n3] = 6.0 * (this.d2f[n3 + 1] - this.d2f[n3]) / d3;
                int n4 = n3++;
                this.d2f[n4] = this.d2f[n4] * 6.0;
            }
        }
    }

    public double get(double d) {
        double d2 = this.emptyCode - 0.5;
        boolean bl = false;
        if (this.lastElement > 0) {
            int n = 0;
            while (n < this.lastElement && !(bl = d >= this.x[n] && d <= this.x[n + 1])) {
                ++n;
            }
            if (bl) {
                double d3 = d - this.x[n];
                d2 = this.f[n] + d3 * (this.d1f[n] + d3 * (this.d2f[n] + d3 * this.d3f[n] / 3.0) / 2.0);
            }
        }
        return d2;
    }
}

