/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas.hist.FunctionAdvancedOptions;
import jas.hist.JASHist;
import jas.hist.JASHistPropertyDialog;
import jas.util.JASDialog;
import jas.util.JASTextField;
import jasext.hist.function.AbstractPolynomialFunction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PolynomialFunction
extends AbstractPolynomialFunction
implements FunctionAdvancedOptions {
    PolynomialFunction(double[] dArray) {
        this.order = dArray.length - 1;
        this.p = dArray;
    }

    public PolynomialFunction(double d, double d2, double d3, double d4) {
        this.order = 2;
        this.p = new double[3];
        double d5 = (d2 - d) / 2.0;
        this.p[0] = (d4 - d3) / Math.pow(d2 - d5, 2.0);
        this.p[1] = -this.p[0] * (d2 - d);
        this.p[2] = d3 - this.p[0] * d5 * d5 - this.p[1] * d5;
    }

    public void openAdvancedDialog(Frame frame, JASHist jASHist) {
        new PolynomialFunctionAdvancedDialog(frame);
    }

    private class PolynomialFunctionAdvancedDialog
    extends JASDialog {
        private JASTextField tf;
        private Frame f;
        private JASHistPropertyDialog pd;

        PolynomialFunctionAdvancedDialog(Frame frame) {
            super(frame, "Advanced...", true, 1);
            this.f = frame;
            Container container = this.getContentPane();
            JPanel jPanel = new JPanel(new GridLayout(4, 1));
            jPanel.add(new JLabel("Set the order of the polynomial.  "));
            jPanel.add(new JLabel("Note that changing the order will "));
            jPanel.add(new JLabel("erase all existing polynomial "));
            jPanel.add(new JLabel("coefficients."));
            this.tf = new JASTextField(String.valueOf(PolynomialFunction.this.order));
            container.add("North", jPanel);
            container.add("South", (Component)this.tf);
            this.pack();
            this.doModal();
        }

        public void onOK() {
            try {
                int n = Integer.parseInt(this.tf.getText());
                if (n < 2) {
                    JOptionPane.showMessageDialog(this.f, "Order must be at least 2", "Error", 0);
                    return;
                }
                if (n != PolynomialFunction.this.order) {
                    PolynomialFunction.this.order = n;
                    PolynomialFunction.this.clearFitParams();
                    PolynomialFunction.this.clearFit();
                    PolynomialFunction.this.p = new double[PolynomialFunction.this.order + 1];
                    int n2 = 0;
                    while (n2 < PolynomialFunction.this.p.length) {
                        PolynomialFunction.this.p[n2] = Math.random() * (Math.random() > 0.5 ? 5.0 : -2.0);
                        ++n2;
                    }
                    PolynomialFunction.this.setChanged();
                    ((Window)((Object)this)).dispose();
                } else {
                    ((Window)((Object)this)).dispose();
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.f, "Incorrect number format", "Error...", 0);
            }
        }
    }
}

