/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.Handle;
import jas.hist.HasHandles;

public class LorentzianFunction
extends Fittable1DFunction
implements HasHandles {
    private double amp;
    private double origin;
    private double width;

    LorentzianFunction(double d, double d2, double d3) {
        this.amp = d;
        this.origin = d2;
        this.width = d3;
    }

    public LorentzianFunction(double d, double d2, double d3, double d4) {
        this.origin = (d2 + d) * 0.5;
        this.width = (d2 - d) / 4.0;
        this.amp = d3 + (d4 - d3) * 0.9;
    }

    public double valueAt(double d) {
        double d2 = this.width * this.width / 4.0;
        return this.amp * d2 / ((d - this.origin) * (d - this.origin) + d2);
    }

    public double valueAt(double d, double[] dArray) {
        double d2 = dArray[2] * dArray[2] / 4.0;
        return dArray[0] * d2 / ((d - dArray[1]) * (d - dArray[1]) + d2);
    }

    public String[] getParameterNames() {
        String[] stringArray = new String[]{"amplitude", "origin", "width"};
        return stringArray;
    }

    public double[] getParameterValues() {
        double[] dArray = new double[]{this.amp, this.origin, this.width};
        return dArray;
    }

    public void setParameter(int n, double d) {
        if (n == 0) {
            this.amp = d;
        } else if (n == 1) {
            this.origin = d;
        } else if (n == 2) {
            this.width = d;
        } else {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.clearFit();
        this.setChanged();
    }

    public void setFit(Fitter fitter, double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        this.amp = dArray[0];
        this.origin = dArray[1];
        this.width = dArray[2];
        this.setFit(fitter);
        this.setChanged();
    }

    public String getTitle() {
        return "Lorentzian";
    }

    public Handle[] getHandles(double d, double d2, double d3, double d4) {
        Handle[] handleArray = new Handle[]{new Handle(){

            public void moveTo(double d, double d2) {
                LorentzianFunction.this.amp = d2;
                LorentzianFunction.this.origin = d;
                LorentzianFunction.this.clearFit();
                LorentzianFunction.this.setChanged();
            }

            public double getX() {
                return LorentzianFunction.this.origin;
            }

            public double getY() {
                return LorentzianFunction.this.amp;
            }
        }, new Handle(){

            public void moveTo(double d, double d2) {
                LorentzianFunction.this.width = 2.0 * (d - LorentzianFunction.this.origin);
                LorentzianFunction.this.clearFit();
                LorentzianFunction.this.setChanged();
            }

            public double getY() {
                return LorentzianFunction.this.amp / 2.0;
            }

            public double getX() {
                return LorentzianFunction.this.origin + LorentzianFunction.this.width / 2.0;
            }
        }, new Handle(){

            public void moveTo(double d, double d2) {
                LorentzianFunction.this.width = 2.0 * (LorentzianFunction.this.origin - d);
                LorentzianFunction.this.clearFit();
                LorentzianFunction.this.setChanged();
            }

            public double getY() {
                return LorentzianFunction.this.amp / 2.0;
            }

            public double getX() {
                return LorentzianFunction.this.origin - LorentzianFunction.this.width / 2.0;
            }
        }};
        return handleArray;
    }
}

