/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.Handle;
import jas.hist.HasHandles;
import jas.hist.Statistics;

public class GaussianFunction
extends Fittable1DFunction
implements HasHandles {
    private static final double fwhm = 1.177;
    private double max;
    private double mean;
    private double sigma;

    public GaussianFunction(double d, double d2, double d3) {
        this.max = d;
        this.mean = d2;
        this.sigma = d3;
    }

    public GaussianFunction(double d, double d2, double d3, double d4) {
        this.max = d3 + (d4 - d3) * 0.8;
        this.mean = (d + d2) / 2.0;
        this.sigma = (d2 - d) / 6.0;
    }

    public double valueAt(double d) {
        return this.max * Math.exp(-Math.pow((d - this.mean) / this.sigma, 2.0) / 2.0);
    }

    public double valueAt(double d, double[] dArray) {
        return dArray[0] * Math.exp(-Math.pow((d - dArray[1]) / dArray[2], 2.0) / 2.0);
    }

    public String[] getParameterNames() {
        String[] stringArray = new String[]{"amplitude", "mean", "sigma"};
        return stringArray;
    }

    public double[] getParameterValues() {
        double[] dArray = new double[]{this.max, this.mean, this.sigma};
        return dArray;
    }

    public void setParameter(int n, double d) {
        if (n == 0) {
            this.max = d;
        } else if (n == 1) {
            this.mean = d;
        } else if (n == 2) {
            this.sigma = d;
        } else {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.clearFit();
        this.setChanged();
    }

    public void setFit(Fitter fitter, double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        this.max = dArray[0];
        this.mean = dArray[1];
        this.sigma = dArray[2];
        this.setFit(fitter);
        this.setChanged();
    }

    public String getTitle() {
        return "Gaussian";
    }

    public Statistics getStatistics() {
        return this;
    }

    public Handle[] getHandles(double d, double d2, double d3, double d4) {
        Handle[] handleArray = new Handle[]{new Handle(){

            public void moveTo(double d, double d2) {
                GaussianFunction.this.mean = d;
                GaussianFunction.this.max = d2;
                GaussianFunction.this.clearFit();
                GaussianFunction.this.setChanged();
            }

            public double getX() {
                return GaussianFunction.this.mean;
            }

            public double getY() {
                return GaussianFunction.this.max;
            }
        }, new Handle(){

            public void moveTo(double d, double d2) {
                GaussianFunction.this.sigma = (GaussianFunction.this.mean - d) / 1.177;
                GaussianFunction.this.clearFit();
                GaussianFunction.this.setChanged();
            }

            public double getY() {
                return GaussianFunction.this.max / 2.0;
            }

            public double getX() {
                return GaussianFunction.this.mean - GaussianFunction.this.sigma * 1.177;
            }
        }, new Handle(){

            public void moveTo(double d, double d2) {
                GaussianFunction.this.sigma = (d - GaussianFunction.this.mean) / 1.177;
                GaussianFunction.this.clearFit();
                GaussianFunction.this.setChanged();
            }

            public double getY() {
                return GaussianFunction.this.max / 2.0;
            }

            public double getX() {
                return GaussianFunction.this.mean + GaussianFunction.this.sigma * 1.177;
            }
        }};
        return handleArray;
    }
}

