/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.Handle;
import jas.hist.HasHandles;

public class ExponentialFunction
extends Fittable1DFunction
implements HasHandles {
    private double max;
    private double origin;
    private double exponent;

    ExponentialFunction(double d, double d2, double d3) {
        this.max = d;
        this.origin = d2;
        this.exponent = d3;
    }

    public ExponentialFunction(double d, double d2, double d3, double d4) {
        this.max = d3 + (d4 - d3) * 0.8;
        this.origin = d + (d2 - d) * 0.05;
        this.exponent = -(d2 - d) / (Math.log(d4) - Math.log(d3 + 0.05 * d4));
    }

    public double valueAt(double d) {
        return this.max * Math.exp((d - this.origin) / this.exponent);
    }

    public double valueAt(double d, double[] dArray) {
        return dArray[0] * Math.exp((d - dArray[1]) / dArray[2]);
    }

    public String[] getParameterNames() {
        String[] stringArray = new String[]{"amplitude", "origin", "exponent"};
        return stringArray;
    }

    public double[] getParameterValues() {
        double[] dArray = new double[]{this.max, this.origin, this.exponent};
        return dArray;
    }

    public void setParameter(int n, double d) {
        if (n == 0) {
            this.max = d;
        } else if (n == 1) {
            this.origin = d;
        } else if (n == 2) {
            this.exponent = d;
        } else {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.clearFit();
        this.setChanged();
    }

    public void setFit(Fitter fitter, double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        this.max = dArray[0];
        this.origin = dArray[1];
        this.exponent = dArray[2];
        this.setFit(fitter);
        this.setChanged();
    }

    public String getTitle() {
        return "Exponential";
    }

    public Handle[] getHandles(double d, double d2, double d3, double d4) {
        Handle[] handleArray = new Handle[]{new Handle(){

            public void moveTo(double d, double d2) {
                ExponentialFunction.this.origin = d;
                ExponentialFunction.this.max = d2;
                ExponentialFunction.this.clearFit();
                ExponentialFunction.this.setChanged();
            }

            public double getX() {
                return ExponentialFunction.this.origin;
            }

            public double getY() {
                return ExponentialFunction.this.max;
            }
        }, new Handle(){

            public void moveTo(double d, double d2) {
                ExponentialFunction.this.exponent = (d - ExponentialFunction.this.origin) / Math.log(d2 / ExponentialFunction.this.max);
                ExponentialFunction.this.clearFit();
                ExponentialFunction.this.setChanged();
            }

            public double getY() {
                return ExponentialFunction.this.max * 0.367;
            }

            public double getX() {
                return ExponentialFunction.this.origin - ExponentialFunction.this.exponent;
            }
        }};
        return handleArray;
    }
}

