/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.Handle;
import jas.hist.HasHandles;
import jas.hist.InvalidFunctionParameter;
import jas.util.ArbitraryNameGenerator;

abstract class AbstractPolynomialFunction
extends Fittable1DFunction
implements HasHandles {
    protected double[] p;
    protected int order;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    AbstractPolynomialFunction() {
    }

    public final double valueAt(double d) {
        double d2 = this.p[this.order];
        int n = 0;
        while (n < this.order) {
            d2 += Math.pow(d, this.order - n) * this.p[n];
            ++n;
        }
        return d2;
    }

    public final double valueAt(double d, double[] dArray) {
        double d2 = dArray[this.order];
        int n = 0;
        while (n < this.order) {
            d2 += Math.pow(d, this.order - n) * dArray[n];
            ++n;
        }
        return d2;
    }

    public final String[] getParameterNames() {
        String[] stringArray = new String[this.order + 1];
        new ArbitraryNameGenerator().fillArray(stringArray);
        return stringArray;
    }

    public final double[] getParameterValues() {
        return this.p;
    }

    public final void setParameter(int n, double d) throws InvalidFunctionParameter {
        try {
            this.p[n] = d;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.clearFit();
        this.setChanged();
    }

    public final void setFit(Fitter fitter, double[] dArray) throws InvalidFunctionParameter {
        if (dArray.length != this.p.length) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        this.p = dArray;
        this.setFit(fitter);
        this.setChanged();
    }

    public String getTitle() {
        return "Polynomial (order " + this.order + ")";
    }

    public final Handle[] getHandles(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        Handle[] handleArray = this.order == 2 ? new Handle[]{new Handle(){

            public void moveTo(double d, double d2) {
                AbstractPolynomialFunction.this.p[1] = -2.0 * AbstractPolynomialFunction.this.p[0] * d;
                AbstractPolynomialFunction.this.p[2] = d2 - AbstractPolynomialFunction.this.p[0] * d * d - AbstractPolynomialFunction.this.p[1] * d;
                AbstractPolynomialFunction.this.clearFit();
                AbstractPolynomialFunction.this.setChanged();
            }

            public double getX() {
                return -AbstractPolynomialFunction.this.p[1] / (2.0 * AbstractPolynomialFunction.this.p[0]);
            }

            public double getY() {
                return AbstractPolynomialFunction.this.valueAt(this.getX());
            }
        }, new Handle(){

            public void moveTo(double d, double d2) {
                double d3 = -AbstractPolynomialFunction.this.p[1] / (2.0 * AbstractPolynomialFunction.this.p[0]);
                double d4 = AbstractPolynomialFunction.this.valueAt(d3);
                AbstractPolynomialFunction.this.p[0] = (d2 - d4) / Math.pow(d - d3, 2.0);
                AbstractPolynomialFunction.this.p[1] = -2.0 * AbstractPolynomialFunction.this.p[0] * d3;
                AbstractPolynomialFunction.this.p[2] = d2 - AbstractPolynomialFunction.this.p[0] * d * d - AbstractPolynomialFunction.this.p[1] * d;
                AbstractPolynomialFunction.this.clearFit();
                AbstractPolynomialFunction.this.setChanged();
            }

            public double getY() {
                return AbstractPolynomialFunction.this.valueAt(this.getX());
            }

            public double getX() {
                double d = -AbstractPolynomialFunction.this.p[1] / (2.0 * AbstractPolynomialFunction.this.p[0]);
                double d2 = (AbstractPolynomialFunction.this.xmax - AbstractPolynomialFunction.this.xmin) / 2.0;
                if (d > d2 && d < AbstractPolynomialFunction.this.xmax) {
                    return (d - AbstractPolynomialFunction.this.xmin) / 2.0 + AbstractPolynomialFunction.this.xmin;
                }
                if (d <= d2 && d > AbstractPolynomialFunction.this.xmin) {
                    return AbstractPolynomialFunction.this.xmax - (AbstractPolynomialFunction.this.xmax - d) / 2.0;
                }
                return d2;
            }
        }} : new Handle[]{new Handle(){

            public void moveTo(double d, double d2) {
                AbstractPolynomialFunction.this.p[AbstractPolynomialFunction.this.order] = 0.0;
                AbstractPolynomialFunction.this.p[AbstractPolynomialFunction.this.order] = d2 - AbstractPolynomialFunction.this.valueAt(d);
                AbstractPolynomialFunction.this.clearFit();
                AbstractPolynomialFunction.this.setChanged();
            }

            public double getY() {
                return AbstractPolynomialFunction.this.valueAt(this.getX());
            }

            public double getX() {
                return (AbstractPolynomialFunction.this.xmax - AbstractPolynomialFunction.this.xmin) / 2.0;
            }
        }};
        return handleArray;
    }
}

