/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.fitter;

import jas.hist.FitFailed;
import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.FunctionValueUndefined;
import jas.hist.IndeterminateMatrix;
import jas.hist.InvalidFunctionParameter;
import jas.hist.Matrix;

public class LeastSquaresFit
extends Fitter {
    private double m_chiSquared;
    private double[] m_sigmaA;

    public void fit(Fittable1DFunction fittable1DFunction, double[] dArray, double[] dArray2, double[] dArray3) throws FitFailed {
        int n = dArray.length;
        if (n != dArray2.length || n != dArray3.length) {
            throw new IllegalArgumentException("Invalid arguments to fit");
        }
        double[] dArray4 = (double[])fittable1DFunction.getParameterValues().clone();
        int n2 = dArray4.length;
        this.m_sigmaA = new double[n2];
        int n3 = n - n2;
        if (n3 <= 0) {
            throw new FitFailed("Insufficient degrees of Freedom");
        }
        double[] dArray5 = new double[n];
        int n4 = 0;
        while (n4 < n) {
            dArray5[n4] = dArray3[n4] == 0.0 ? 0.0 : 1.0 / dArray3[n4] / dArray3[n4];
            ++n4;
        }
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[][] dArray8 = Matrix.create((int)n2);
        double[][] dArray9 = Matrix.create((int)n2);
        double d = 0.001;
        try {
            int n5 = 0;
            while (true) {
                int n6;
                int n7;
                int n8;
                if (n5 > 10000) {
                    throw new FitFailed("Fit exceeded maximum number of iterations");
                }
                double d2 = this.calculateChiSquared(fittable1DFunction, dArray, dArray2, dArray5, dArray4, n3);
                int n9 = 0;
                while (n9 < n2) {
                    dArray6[n9] = 0.0;
                    n8 = 0;
                    while (n8 <= n9) {
                        dArray8[n9][n8] = 0.0;
                        ++n8;
                    }
                    ++n9;
                }
                n8 = 0;
                while (n8 < n) {
                    double[] dArray10 = fittable1DFunction.getDerivatives(dArray[n8], dArray4);
                    n7 = 0;
                    while (n7 < n2) {
                        int n10 = n7;
                        dArray6[n10] = dArray6[n10] + dArray5[n8] * (dArray2[n8] - fittable1DFunction.valueAt(dArray[n8], dArray4)) * dArray10[n7];
                        int n11 = 0;
                        while (n11 <= n7) {
                            double[] dArray11 = dArray8[n7];
                            int n12 = n11;
                            dArray11[n12] = dArray11[n12] + dArray5[n8] * dArray10[n7] * dArray10[n11];
                            ++n11;
                        }
                        ++n7;
                    }
                    ++n8;
                }
                int n13 = 0;
                while (n13 < n2) {
                    n7 = 0;
                    while (n7 < n13) {
                        dArray8[n7][n13] = dArray8[n13][n7];
                        ++n7;
                    }
                    ++n13;
                }
                double d3 = this.calculateChiSquared(fittable1DFunction, dArray, dArray2, dArray5, dArray4, n3);
                while (true) {
                    n6 = 0;
                    while (n6 < n2) {
                        int n14 = 0;
                        while (n14 < n2) {
                            dArray9[n6][n14] = dArray8[n6][n14] / Math.sqrt(dArray8[n6][n6] * dArray8[n14][n14]);
                            ++n14;
                        }
                        dArray9[n6][n6] = 1.0 + d;
                        ++n6;
                    }
                    try {
                        double d4 = Matrix.invert((double[][])dArray9);
                    }
                    catch (IndeterminateMatrix indeterminateMatrix) {
                        throw new FitFailed("Matrix became indeterminate during fit");
                    }
                    int n15 = 0;
                    while (n15 < n2) {
                        dArray7[n15] = dArray4[n15];
                        int n16 = 0;
                        while (n16 < n2) {
                            int n17 = n15;
                            dArray7[n17] = dArray7[n17] + dArray6[n16] * dArray9[n15][n16] / Math.sqrt(dArray8[n15][n15] * dArray8[n16][n16]);
                            ++n16;
                        }
                        ++n15;
                    }
                    d2 = this.calculateChiSquared(fittable1DFunction, dArray, dArray2, dArray5, dArray7, n3);
                    if (d2 <= d3) break;
                    d *= 10.0;
                }
                n6 = 0;
                while (n6 < n2) {
                    dArray4[n6] = dArray7[n6];
                    this.m_sigmaA[n6] = Math.sqrt(dArray9[n6][n6] / dArray8[n6][n6]);
                    ++n6;
                }
                d /= 10.0;
                double d5 = Math.abs(d2 - this.m_chiSquared) / this.m_chiSquared;
                this.m_chiSquared = d2;
                if (d5 < 0.001) break;
                this.setPercentComplete(10 * n5);
                ++n5;
            }
            try {
                fittable1DFunction.setFit((Fitter)this, dArray4);
            }
            catch (InvalidFunctionParameter invalidFunctionParameter) {
                throw new FitFailed("Unexpected exception: " + (Object)((Object)invalidFunctionParameter));
            }
        }
        catch (FunctionValueUndefined functionValueUndefined) {
            throw new FitFailed("Fit entered region where function value was undefined");
        }
    }

    private double calculateChiSquared(Fittable1DFunction fittable1DFunction, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n) throws FunctionValueUndefined {
        double d = 0.0;
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray2[n3] - fittable1DFunction.valueAt(dArray[n3], dArray4);
            d += dArray3[n3] * d2 * d2;
            ++n3;
        }
        return d / (double)n;
    }

    public double getChiSquared() {
        return this.m_chiSquared;
    }

    public double[] getParameterSigmas() {
        return this.m_sigmaA;
    }
}

