/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.util.RepConversion;
import oracle.security.o3logon.O3LoginClientHelper;

public class O3log
extends TTIfun {
    private byte[] user;
    private byte[] password;
    private int auditFlag = 0;
    private long connectFlag = 0L;
    private int revisionLev = 0;
    private int padO2UPtr = 0;
    private boolean padO2U = false;
    private byte[] terminal = new byte[0];
    private byte[] machine = new byte[0];
    private byte[] sysUserName = new byte[0];
    private int sizeofUCAUAC = 4096;
    private byte[] processID = new byte[0];
    private byte[] programName = new byte[0];
    private short svrAttrPtr = 0;
    private int lenSvrAttrs = 0;
    private boolean svrDataO2U = false;
    private long svrDataO2UPtr = 0L;
    private int lenSvrData = 0;
    private int svrInfoLen = 16;
    private boolean svrInfoO2U = false;
    private byte[] svrInfoO2UPtr = new byte[this.svrInfoLen];
    private boolean retLenO2U = false;
    private int retLenO2UPtr = 0;
    public byte[] encryptedSK;
    public byte[] sessionKey;

    public O3log(MAREngine mAREngine, String string, String string2, byte[] byArray, Properties properties, long l) throws IOException, SQLException {
        super((byte)3, 0, (byte)81);
        this.setMarshalingEngine(mAREngine);
        this.connectFlag = l;
        this.oer = new TTIoer(this.meg);
        if (byArray.length > 16) {
            DBError.check_error(413);
        }
        String string3 = string.trim();
        String string4 = string2.trim();
        String string5 = string3;
        String string6 = string4;
        if (string3.startsWith("\"") || string3.endsWith("\"")) {
            string5 = this.removeQuotes(string3);
        }
        if (string4.startsWith("\"") || string4.endsWith("\"")) {
            string6 = this.removeQuotes(string4);
        }
        O3LoginClientHelper o3LoginClientHelper = new O3LoginClientHelper(this.meg.conv.isServerMultiByte());
        this.sessionKey = o3LoginClientHelper.getSessionKey(string5, string6, byArray);
        byte[] byArray2 = this.meg.conv.StringToNetworkRep(string6);
        byte by = byArray2.length % 8 > 0 ? (byte)((byte)(8 - byArray2.length % 8)) : (byte)0;
        byte[] byArray3 = new byte[byArray2.length + by];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byte[] byArray4 = o3LoginClientHelper.getEPasswd(this.sessionKey, byArray3);
        this.user = this.meg.conv.StringToCharBytes(string);
        this.password = new byte[2 * byArray3.length + 1];
        if (this.password.length < 2 * byArray4.length) {
            DBError.check_error(413);
        }
        RepConversion.bArray2nibbles(byArray4, this.password);
        this.password[this.password.length - 1] = RepConversion.nibbleToHex(by);
        this.setSessionFields(properties);
    }

    public O3log(MAREngine mAREngine, String string, Properties properties, long l) throws IOException, SQLException {
        super((byte)3, 0, (byte)82);
        this.setMarshalingEngine(mAREngine);
        this.user = this.meg.conv.StringToCharBytes(string);
        this.password = new byte[0];
        this.setSessionFields(properties);
        this.svrInfoO2U = true;
        this.retLenO2U = true;
        this.oer = new TTIoer(this.meg);
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void marshal() throws IOException {
        this.marshalFunHeader();
        if (this.user.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.user.length);
        if (this.password.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.password.length);
        this.meg.marshalSB4(this.auditFlag);
        this.meg.marshalUB4(this.connectFlag);
        this.meg.marshalSB4(this.revisionLev);
        this.meg.marshalO2U(this.padO2U);
        if (this.terminal.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.terminal.length);
        if (this.machine.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.machine.length);
        if (this.sysUserName.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.sysUserName.length);
        this.meg.marshalSB4(this.sizeofUCAUAC);
        if (this.processID.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.processID.length);
        if (this.programName.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.programName.length);
        this.meg.marshalSB2(this.svrAttrPtr);
        this.meg.marshalSB4(this.lenSvrAttrs);
        this.meg.marshalO2U(this.svrDataO2U);
        this.meg.marshalSB4(this.lenSvrData);
        this.meg.marshalO2U(this.svrInfoO2U);
        this.meg.marshalSB4(this.svrInfoLen);
        this.meg.marshalO2U(this.retLenO2U);
        this.meg.marshalCHR(this.user);
        this.meg.marshalCHR(this.password);
        this.meg.marshalCHR(this.terminal);
        this.meg.marshalCHR(this.machine);
        this.meg.marshalCHR(this.sysUserName);
        this.meg.marshalCHR(this.processID);
        this.meg.marshalCHR(this.programName);
    }

    public void receive1st() throws SQLException, IOException {
        boolean bl = false;
        block4: while (true) {
            byte by = this.meg.unmarshalSB1();
            switch (by) {
                case 8: {
                    if (bl) {
                        DBError.check_error(401);
                    }
                    int n = this.meg.unmarshalUB2();
                    this.encryptedSK = this.meg.unmarshalCHR(16);
                    if (this.encryptedSK == null) {
                        DBError.check_error(438);
                    }
                    bl = true;
                    continue block4;
                }
                case 4: {
                    this.oer.init();
                    this.oer.unmarshal();
                    this.oer.processError();
                    break block4;
                }
                default: {
                    DBError.check_error(401);
                    continue block4;
                }
            }
            break;
        }
    }

    public void receive2nd() throws SQLException, IOException {
        block4: while (true) {
            byte by = this.meg.unmarshalSB1();
            switch (by) {
                case 8: {
                    DBError.check_error(401);
                }
                case 4: {
                    this.oer.init();
                    this.oer.unmarshal();
                    this.oer.processError();
                    break block4;
                }
                default: {
                    DBError.check_error(401);
                    continue block4;
                }
            }
            break;
        }
    }

    private String removeQuotes(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) != '\"') {
                n = n3;
                break;
            }
            ++n3;
        }
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            if (string.charAt(n4) != '\"') {
                n2 = n4;
                break;
            }
            --n4;
        }
        return string.substring(n, n2 + 1);
    }

    public void setSessionFields(Properties properties) throws SQLException {
        String string = properties.getProperty("v$session.terminal");
        String string2 = properties.getProperty("v$session.machine");
        String string3 = properties.getProperty("v$session.osuser");
        String string4 = properties.getProperty("v$session.program");
        if (string == null) {
            string = "unknown";
        }
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string2 = "jdbcclient";
            }
        }
        if (string3 == null) {
            try {
                string3 = System.getProperty("user.name");
            }
            catch (Exception exception) {
                string3 = "jdbcuser";
            }
        }
        if (string4 == null) {
            string4 = "JDBC Thin Client";
        }
        this.terminal = this.meg.conv.StringToCharBytes(string);
        this.machine = this.meg.conv.StringToCharBytes(string2);
        this.sysUserName = this.meg.conv.StringToCharBytes(string3);
        this.programName = this.meg.conv.StringToCharBytes(string4);
    }
}

