/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.TTCConversion;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTCTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

public class MAREngine {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG1 = false;
    private static final boolean DEBUG2 = false;
    public static final int TTCC_MXL = 252;
    public static final int TTCC_ESC = 253;
    public static final int TTCC_LNG = 254;
    public static final int TTCC_ERR = 255;
    public static final int TTCC_MXIN = 64;
    public static final byte TTCLXMULTI = 1;
    public static final byte TTCLXMCONV = 2;
    public TTCTypeRep types;
    public Communication net;
    public TTCConversion conv;
    protected InputStream inBuffer;
    protected OutputStream outBuffer;
    byte[] resBuffer = null;
    byte[] newBuffer = null;
    byte[] finalBuffer = null;
    byte[] blackHoleBuf = new byte[255];
    byte[] tmpBuf = null;
    int[] retLen = new int[1];

    public MAREngine(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            DBError.check_error(433);
        }
        this.net = communication;
        try {
            this.inBuffer = communication.getInputStream();
            this.outBuffer = communication.getOutputStream();
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new TTCTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    protected void addPtr(byte by) throws IOException {
        if ((this.types.rep[3] & 1) > 0) {
            this.outBuffer.write(by);
        } else {
            byte[] byArray = new byte[4];
            byte by2 = this.value2Buffer(by, byArray, (byte)3);
            this.outBuffer.write(byArray, 0, by2);
        }
    }

    private long buffer2Value(byte[] byArray, byte by) throws SQLException, IOException {
        int n = 0;
        long l = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            try {
                while (true) {
                    try {
                        n = this.inBuffer.read();
                    }
                    catch (BreakNetException breakNetException) {
                        this.net.sendReset();
                        continue;
                    }
                    break;
                }
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if ((n & 0x80) > 0) {
                n &= 0x7F;
                bl = true;
            }
            if (n < 0) {
                DBError.check_error(410);
            }
            if (n == 0) {
                return 0L;
            }
            if (by == 1 && n > 2 || by == 2 && n > 4) {
                DBError.check_error(412);
            }
        } else if (by == 1) {
            n = 2;
        } else if (by == 2) {
            n = 4;
        }
        byArray = new byte[n];
        try {
            while (true) {
                try {
                    if (this.inBuffer.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            short s = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - n2] & 0xFF) : (short)(byArray[n2] & 0xFF);
            l |= (long)(s << 8 * (byArray.length - 1 - n2));
            ++n2;
        }
        l &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l *= -1L;
        }
        return l;
    }

    private long buffer2Value(byte[] byArray, byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        int n = 0;
        long l = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            n = byteArrayInputStream.read();
            if ((n & 0x80) > 0) {
                n &= 0x7F;
                bl = true;
            }
            if (n < 0) {
                DBError.check_error(410);
            }
            if (n == 0) {
                return 0L;
            }
            if (by == 1 && n > 2 || by == 2 && n > 4) {
                DBError.check_error(412);
            }
        } else if (by == 1) {
            n = 2;
        } else if (by == 2) {
            n = 4;
        }
        if (byteArrayInputStream.read(byArray = new byte[n]) < 0) {
            DBError.check_error(410);
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            short s = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - n2] & 0xFF) : (short)(byArray[n2] & 0xFF);
            l |= (long)(s << 8 * (byArray.length - 1 - n2));
            ++n2;
        }
        l &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l *= -1L;
        }
        return l;
    }

    public boolean escapeSequenceNull(int n) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 253: {
                DBError.check_error(401);
            }
            case 255: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public byte[] getNBytes(int n) throws SQLException, IOException {
        byte[] byArray = new byte[n];
        try {
            while (true) {
                try {
                    if (this.inBuffer.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return byArray;
    }

    public int getNBytes(byte[] byArray, int n, int n2) throws SQLException, IOException {
        int n3 = 0;
        try {
            while (true) {
                try {
                    n3 = this.inBuffer.read(byArray, n, n2);
                    if (n3 < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return n3;
    }

    public void initBuffers() {
    }

    protected void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outBuffer.write(byArray);
        }
    }

    protected void marshalB1Array(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length > 0) {
            this.outBuffer.write(byArray, n, n2);
        }
    }

    protected void marshalCHR(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, byArray.length);
            } else {
                this.outBuffer.write(byArray);
            }
        }
    }

    protected void marshalCLR(byte[] byArray, int n) throws IOException {
        if (n > 64) {
            int n2;
            int n3 = 0;
            this.outBuffer.write(-2);
            do {
                int n4;
                n2 = (n4 = n - n3) > 64 ? 64 : n4;
                this.outBuffer.write((byte)(n2 & 0xFF));
                this.outBuffer.write(byArray, n3, n2);
            } while ((n3 += n2) < n);
            this.outBuffer.write(0);
        } else {
            this.outBuffer.write((byte)(n & 0xFF));
            this.outBuffer.write(byArray);
        }
    }

    public void marshalDALC(byte[] byArray) throws SQLException, IOException {
        if (byArray == null || byArray.length < 1) {
            this.outBuffer.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    public void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    public void marshalO2U(boolean bl) throws IOException {
        if (bl) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    public void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    protected void marshalSB1(byte by) throws IOException {
        this.outBuffer.write(by);
    }

    protected void marshalSB2(short s) throws IOException {
        byte[] byArray = new byte[2];
        byte by = this.value2Buffer(s, byArray, (byte)1);
        this.outBuffer.write(byArray, 0, by);
    }

    protected void marshalSB4(int n) throws IOException {
        byte[] byArray = new byte[4];
        byte by = this.value2Buffer(n, byArray, (byte)2);
        this.outBuffer.write(byArray, 0, by);
    }

    protected void marshalSWORD(int n) throws IOException {
        this.marshalSB4(n);
    }

    protected void marshalUB1(short s) throws IOException {
        this.outBuffer.write((byte)(s & 0xFF));
    }

    protected void marshalUB2(int n) throws IOException {
        this.marshalSB2((short)(n & 0xFFFF));
    }

    protected void marshalUB4(long l) throws IOException {
        this.marshalSB4((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void marshalUB4Array(long[] lArray) throws IOException {
        int n = 0;
        while (n < lArray.length) {
            this.marshalSB4((int)(lArray[n] & 0xFFFFFFFFFFFFFFFFL));
            ++n;
        }
    }

    protected void marshalUWORD(long l) throws IOException {
        this.marshalSB4((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    public int processIndicator(boolean bl, int n) throws SQLException, IOException {
        short s = this.unmarshalSB2();
        int n2 = 0;
        if (!bl) {
            n2 = s == 0 ? n : (s == -2 || s > 0 ? (int)s : 65536 + s);
        }
        return n2;
    }

    protected void reverseArray(byte[] byArray, byte by) {
        int n = 0;
        while (n < by / 2) {
            byte by2 = byArray[n];
            byArray[n] = byArray[by - 1 - n];
            byArray[by - 1 - n] = by2;
            ++n;
        }
    }

    private int unmarshalBuffer(byte[] byArray, int n, int n2) throws SQLException, IOException {
        if (byArray.length < n + n2) {
            this.unmarshalNBytes(byArray, n, byArray.length - n);
            this.unmarshalNBytes(this.blackHoleBuf, 0, n + n2 - byArray.length);
            n = -1;
        } else {
            this.unmarshalNBytes(byArray, n, n2);
            n += n2;
        }
        return n;
    }

    public byte[] unmarshalCHR(int n) throws SQLException, IOException {
        if (this.types.isConvNeeded()) {
            int[] nArray = new int[1];
            this.resBuffer = this.unmarshalCLR(n, nArray);
            this.tmpBuf = new byte[nArray[0]];
            System.arraycopy(this.resBuffer, 0, this.tmpBuf, 0, nArray[0]);
            this.resBuffer = this.tmpBuf;
        } else {
            this.resBuffer = this.getNBytes(n);
        }
        return this.resBuffer;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] unmarshalCLR(int var1_1, int[] var2_2) throws SQLException, IOException {
        block6: {
            block7: {
                block5: {
                    var3_3 = 0;
                    var4_4 = 0;
                    var5_5 = this.unmarshalUB1();
                    if (var5_5 < 0) {
                        DBError.check_error(401);
                    }
                    if (var5_5 == 0) {
                        var2_2[0] = 0;
                        return new byte[0];
                    }
                    this.tmpBuf = new byte[var1_1 * this.conv.getNLSRATIO()];
                    if (!this.escapeSequenceNull(var5_5)) break block5;
                    var2_2[0] = 0;
                    break block6;
                }
                if (var5_5 == 254) ** GOTO lbl23
                var4_4 = this.unmarshalBuffer(this.tmpBuf, var4_4, var5_5);
                break block7;
lbl-1000:
                // 1 sources

                {
                    if (var3_3 == 254 && this.types.isServerConversion()) continue;
                    if (var4_4 == -1) {
                        this.unmarshalBuffer(this.blackHoleBuf, 0, var3_3);
                        continue;
                    }
                    var4_4 = this.unmarshalBuffer(this.tmpBuf, var4_4, var3_3);
lbl23:
                    // 4 sources

                    ** while ((var3_3 = this.unmarshalUB1()) > 0)
                }
            }
            if (var2_2 != null) {
                var2_2[0] = var4_4 != -1 ? var4_4 : this.tmpBuf.length;
            }
        }
        return this.tmpBuf;
    }

    public void unmarshalCLR(TTCItem tTCItem, int[] nArray) throws SQLException, IOException {
        short s = 0;
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        s = this.unmarshalUB1();
        if (s < 0) {
            DBError.check_error(401);
        }
        if (s == 0) {
            return;
        }
        if (this.escapeSequenceNull(s)) {
            nArray[0] = 0;
            return;
        }
        if (s != 254) {
            n = this.unmarshalBuffer(tTCItem.byte_value, n, s);
        } else {
            n2 = -1;
            block5: while (n2 == -1 || (s = this.unmarshalUB1()) > 0) {
                if (s == 254) {
                    switch (n2) {
                        case -1: {
                            n2 = 1;
                            continue block5;
                        }
                        case 1: {
                            n2 = 0;
                            break;
                        }
                        case 0: {
                            if (bl) {
                                n2 = 0;
                                break;
                            }
                            n2 = 0;
                            continue block5;
                        }
                    }
                }
                if (n == -1) {
                    this.unmarshalBuffer(this.blackHoleBuf, 0, s);
                } else {
                    n = this.unmarshalBuffer(tTCItem.byte_value, n, s);
                }
                n2 = 0;
                if (s <= 252) continue;
                bl = true;
            }
        }
        if (nArray != null) {
            nArray[0] = n != -1 ? n : tTCItem.byte_value.length;
        }
    }

    public byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short s = 0;
        short s2 = 0;
        this.finalBuffer = null;
        Vector<byte[]> vector = new Vector<byte[]>(10, 10);
        short s3 = this.unmarshalUB1();
        if (s3 < 0) {
            DBError.check_error(401);
        }
        if (s3 == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(s3)) {
            if (s3 == 254) {
                while ((s = this.unmarshalUB1()) > 0) {
                    if (s == 254 && this.types.isServerConversion()) continue;
                    s2 = (short)(s2 + s);
                    this.tmpBuf = new byte[s];
                    this.unmarshalBuffer(this.tmpBuf, 0, s);
                    vector.addElement(this.tmpBuf);
                }
            } else {
                s2 = s3;
                this.tmpBuf = new byte[s3];
                this.unmarshalBuffer(this.tmpBuf, 0, s3);
                vector.addElement(this.tmpBuf);
            }
            this.finalBuffer = new byte[s2];
            int n = 0;
            while (vector.size() > 0) {
                int n2 = ((byte[])vector.elementAt(0)).length;
                System.arraycopy(vector.elementAt(0), 0, this.finalBuffer, n, n2);
                n += n2;
                vector.removeElementAt(0);
            }
        } else {
            this.finalBuffer = null;
        }
        return this.finalBuffer;
    }

    public byte[] unmarshalDALC() throws SQLException, IOException {
        long l = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, this.retLen)) == null) {
                DBError.check_error(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        long l = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, nArray)) == null) {
                DBError.check_error(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public byte[] unmarshalNBytes(int n) throws SQLException, IOException {
        byte[] byArray = new byte[n];
        try {
            while (true) {
                try {
                    if (this.inBuffer.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return byArray;
    }

    public int unmarshalNBytes(byte[] byArray, int n, int n2) throws SQLException, IOException {
        int n3 = 0;
        while (n3 < n2) {
            n3 += this.getNBytes(byArray, n + n3, n2 - n3);
        }
        return n3;
    }

    public int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        return this.unmarshalSB4(byArray);
    }

    public byte unmarshalSB1() throws SQLException, IOException {
        return (byte)this.unmarshalUB1();
    }

    public short unmarshalSB2() throws SQLException, IOException {
        return (short)this.unmarshalUB2();
    }

    public int unmarshalSB4() throws SQLException, IOException {
        return (int)this.unmarshalUB4();
    }

    public int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        byte[] byArray2 = new byte[4];
        long l = this.buffer2Value(byArray2, (byte)2, new ByteArrayInputStream(byArray));
        return (int)l;
    }

    public int unmarshalSWORD() throws SQLException, IOException {
        return (int)this.unmarshalUB4();
    }

    public byte[] unmarshalTEXT(int n) throws SQLException, IOException {
        int n2 = 0;
        byte[] byArray = new byte[n];
        while (n2 < n) {
            try {
                while (true) {
                    try {
                        if (this.inBuffer.read(byArray, n2, 1) < 0) {
                            DBError.check_error(410);
                        }
                    }
                    catch (BreakNetException breakNetException) {
                        this.net.sendReset();
                        continue;
                    }
                    break;
                }
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if (byArray[n2++] == 0) break;
        }
        byte[] byArray2 = new byte[--n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public short unmarshalUB1() throws SQLException, IOException {
        short s = 0;
        try {
            while (true) {
                try {
                    s = (short)this.inBuffer.read();
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        if (s < 0) {
            DBError.check_error(410);
        }
        return s;
    }

    public int unmarshalUB2() throws SQLException, IOException {
        byte[] byArray = new byte[2];
        int n = (int)this.buffer2Value(byArray, (byte)1);
        return n & 0xFFFF;
    }

    public long unmarshalUB4() throws SQLException, IOException {
        byte[] byArray = new byte[4];
        long l = this.buffer2Value(byArray, (byte)2);
        return l;
    }

    public long unmarshalUWORD() throws SQLException, IOException {
        return this.unmarshalUB4();
    }

    protected byte value2Buffer(int n, byte[] byArray, byte by) throws IOException {
        boolean bl = true;
        byte by2 = 0;
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            byArray[by2] = (byte)(n >>> 8 * n2 & 0xFF);
            if ((this.types.rep[by] & 1) > 0) {
                if (!bl || byArray[by2] != 0) {
                    bl = false;
                    by2 = (byte)(by2 + 1);
                }
            } else {
                by2 = (byte)(by2 + 1);
            }
            --n2;
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outBuffer.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }
}

