/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;

public class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    OracleConnection connection;
    OracleStatement statement;
    int m_beginColumnIndex;

    public OracleResultSetMetaData(OracleConnection oracleConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        this.m_beginColumnIndex = 0;
    }

    OracleResultSetMetaData(OracleConnection oracleConnection, OracleStatement oracleStatement, int n) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        this.m_beginColumnIndex = n;
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public String getColumnClassName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        int n3 = this.statement.getDBDescription()[n2].type;
        switch (n3) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return "java.lang.String";
            }
            case 2: 
            case 6: {
                return "java.math.BigDecimal";
            }
            case 23: 
            case 24: {
                return "byte[]";
            }
            case 12: {
                return "java.sql.Timestamp";
            }
            case 104: {
                return "oracle.sql.ROWID";
            }
            case 113: {
                return "oracle.sql.BLOB";
            }
            case 112: {
                return "oracle.sql.CLOB";
            }
            case 114: {
                return "oracle.sql.BFILE";
            }
            case 102: {
                return "oracle.jdbc.driver.OracleResultSet";
            }
            case 109: {
                Class clazz;
                if (this.getColumnType(n) == 2003) {
                    return "oracle.sql.ARRAY";
                }
                Map map = this.connection.getTypeMap();
                if (map != null && (clazz = (Class)map.get(((OracleNamedType)this.statement.getDBDescription()[n2].otype).getFullName())) != null) {
                    return clazz.getName();
                }
                return "oracle.sql.STRUCT";
            }
            case 111: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public int getColumnCount() throws SQLException {
        return this.statement.getDBDescription().length - this.m_beginColumnIndex;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].max_length;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].name;
    }

    public int getColumnType(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        int n3 = this.statement.getDBDescription()[n2].type;
        switch (n3) {
            case 96: {
                return 1;
            }
            case 1: {
                return 12;
            }
            case 8: {
                return -1;
            }
            case 2: 
            case 6: {
                return 2;
            }
            case 23: {
                return -3;
            }
            case 24: {
                return -4;
            }
            case 104: {
                return -8;
            }
            case 102: {
                return -10;
            }
            case 12: {
                return 93;
            }
            case 113: {
                return 2004;
            }
            case 112: {
                return 2005;
            }
            case 114: {
                return -13;
            }
            case 109: {
                OracleNamedType oracleNamedType = (OracleNamedType)this.statement.getDBDescription()[n2].otype;
                Object object = this.connection.getDescriptor(oracleNamedType.getFullName());
                if (object != null) {
                    if (object instanceof ArrayDescriptor) {
                        return 2003;
                    }
                    return 2002;
                }
                Statement statement = this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery("select typecode from all_types where owner = '" + oracleNamedType.getSchemaName() + "' and type_name = '" + oracleNamedType.getSimpleName() + "'");
                resultSet.next();
                if (resultSet.getString(1).equals("COLLECTION")) {
                    return 2003;
                }
                return 2002;
            }
            case 111: {
                return 2006;
            }
        }
        return 1111;
    }

    public String getColumnTypeName(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR2";
            }
            case -1: {
                return "LONG";
            }
            case -3: {
                return "RAW";
            }
            case -4: {
                return "LONG RAW";
            }
            case 2: {
                return "NUMBER";
            }
            case 93: {
                return "DATE";
            }
            case -8: {
                return "ROWID";
            }
            case -10: {
                return "REFCURSOR";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: {
                int n3 = this.getValidColumnIndex(n);
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.statement.getDBDescription()[n3].otype;
                return oracleTypeADT.getFullName();
            }
            case 2006: {
                int n4 = this.getValidColumnIndex(n);
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.statement.getDBDescription()[n4].otype;
                return oracleTypeADT.getFullName();
            }
        }
        return null;
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        int n3 = this.statement.getDBDescription()[n2].type;
        switch (n3) {
            case 112: 
            case 113: {
                return Integer.parseInt(OracleDatabaseMetaData.getLobPrecision());
            }
            case 8: 
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 96: {
                return this.statement.getDBDescription()[n2].max_length;
            }
        }
        return this.statement.getDBDescription()[n2].precision;
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].scale;
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public String getTableName(int n) throws SQLException {
        return "";
    }

    private int getValidColumnIndex(int n) throws SQLException {
        int n2 = n + this.m_beginColumnIndex - 1;
        if (n2 < 0 || n2 >= this.statement.getDBDescription().length) {
            DBError.check_error(3, "getValidColumnIndex");
        }
        return n2;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        return n2 == 1 || n2 == 12 || n2 == -1;
    }

    public boolean isCurrency(int n) throws SQLException {
        return this.getColumnType(n) == 2;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.statement.getDBDescription()[n2].nullable ? 1 : 0;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        return (n2 == -4 || n2 == -1 || n2 == 2004 || n2 == 2005 || n2 == -13 || n2 == 2002 || n2 == 2003 || n2 == 2006 || n2 == -10) ^ true;
    }

    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    public boolean isWritable(int n) throws SQLException {
        return true;
    }
}

