/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    private int min_binary_stream_size;
    private int min_ascii_stream_size;
    boolean check_bind_types = true;
    DBDataSet m_binds;
    boolean m_scrollRsetTypeSolved;
    boolean has_ref_cursors = false;
    protected static final int BSTYLE_UNKNOWN = 0;
    protected static final int BSTYLE_ORACLE = 1;
    protected static final int BSTYLE_JDBC = 2;
    protected int m_batchStyle = 0;

    public OraclePreparedStatement(OracleConnection oracleConnection, String string, int n, int n2) throws SQLException {
        this(oracleConnection, string, n, n2, 1003, 1007);
    }

    public OraclePreparedStatement(OracleConnection oracleConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(oracleConnection, n, n2, n3, n4);
        if (OracleLog.TRACE) {
            OracleLog.print(oracleConnection, 1, 16, 16, "OraclePreparedStatement.OraclePreparedStatement(conn, sql, batchValue, rowPrefetchValue)");
        }
        this.need_to_parse = true;
        this.has_ref_cursors = false;
        this.prepare_for_new_result();
        this.sql_query = string;
        this.m_originalSql = string;
        this.clear_params = true;
        this.m_binds = null;
        this.m_scrollRsetTypeSolved = false;
        this.m_stmtType = 1;
        this.binds_in = this.connection.db_access.createDBDataSet(oracleConnection, this, n, 1);
        this.parseSqlKind();
        if (oracleConnection.db_access.getVersionNumber() >= 8000) {
            this.min_binary_stream_size = 2000;
            this.min_ascii_stream_size = 4000;
        } else {
            this.min_binary_stream_size = 255;
            this.min_ascii_stream_size = 2000;
        }
    }

    public synchronized void addBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.addBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Add batch: m_currentRank=" + this.m_currentRank);
        }
        if (OracleLog.TRACE && this.m_batchStyle == 0) {
            OracleLog.print(this.connection, 1, 16, 32, "First detected Jdbc-style batching");
        }
        this.setJdbcBatchStyle();
        this.binds_in.rowCompleted(-1);
        if (this.binds_in.hasStreamType()) {
            DBError.throwSqlException(90, "streams type cannot be used in batching");
        }
        this.checkBindsInAndOut();
        ++this.m_currentRank;
    }

    public synchronized void addBatch(String string) throws SQLException {
        DBError.throwSqlException(23);
    }

    protected void checkBindTypes(boolean bl, int n, int n2) throws SQLException {
        if (!this.check_bind_types) {
            return;
        }
        int n3 = bl ? this.binds_in.checkBindTypes(this.binds_out, n, n2) : this.binds_out.checkBindTypes(this.binds_in, n, n2);
        if (n3 == -1) {
            this.sendBatch();
            this.need_to_parse = true;
            this.clearDefines();
        }
    }

    protected final void checkIfJdbcBatchExists() throws SQLException {
        if (this.doesJdbcBatchExist()) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    void checkPlsqlIndexTableBindTypes(boolean bl, int n, int n2, int n3, int n4) throws SQLException {
        switch (n3) {
            default: {
                DBError.throwSqlException(97);
            }
            case 1: 
            case 2: 
            case 6: 
            case 96: 
        }
        if (!this.check_bind_types) {
            return;
        }
        DBDataSet dBDataSet = bl ? this.binds_in : this.binds_out;
        int n5 = dBDataSet.checkPlsqlIndexTableBindTypes(this.binds_out, n, n2, n4, n3);
        if (n5 == -1) {
            this.sendBatch();
            this.need_to_parse = true;
            this.clearDefines();
        }
    }

    private void cleanup() {
        if (this.connection.m_stmtClearMetaData && this.binds_in != null) {
            this.binds_in.cleanup();
        }
        this.clear_params = true;
    }

    public synchronized void clearBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.clearBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Clear batch: m_currentRank=" + this.m_currentRank);
        }
        this.setJdbcBatchStyle();
        this.cleanupForBatching();
    }

    public synchronized void clearParameters() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.clearParameters()");
        }
        this.clear_params = true;
        if (this.binds_in != null) {
            this.binds_in.clearItems();
        }
    }

    public synchronized void close() throws SQLException {
        this.privateClose(null);
    }

    public synchronized void closeWithKey(String string) throws SQLException {
        this.privateClose(string);
    }

    public synchronized void defineParameterType(int n, int n2, int n3) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.defineParameterType(param_index=" + n + ", type=" + n2 + ", max_size=" + n3 + ")");
        }
        if (n3 < 0) {
            DBError.throwSqlException(53);
        }
        if (n < 1) {
            DBError.throwSqlException(3);
        }
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 6;
                break;
            }
            case 999: {
                n2 = 999;
                break;
            }
            case 1: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 1;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                n2 = 12;
                break;
            }
            case -3: 
            case -2: {
                n2 = 23;
                break;
            }
            case -8: {
                n2 = 104;
                break;
            }
            case 2004: {
                n2 = 113;
                break;
            }
            case 2005: {
                n2 = 112;
                break;
            }
            case -13: {
                n2 = 114;
                break;
            }
            case -10: {
                n2 = 102;
                break;
            }
            default: {
                DBError.throwSqlException(23);
            }
        }
        this.binds_in.setType(n - 1, n2, n3);
    }

    private int doScrollPstmtExecuteUpdate() throws SQLException {
        this.scrollStmt_cleanup(false);
        this.parseSqlKind();
        if (this.sql_kind != 0) {
            this.new_row_prefetch = this.default_row_prefetch;
            this.prepare_for_new_result();
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            return this.valid_rows;
        }
        boolean bl = true;
        String string = null;
        if (!this.m_needToAddIdentifier) {
            this.new_row_prefetch = this.default_row_prefetch;
            this.prepare_for_new_result();
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            try {
                this.m_revisedSql = ResultSetUtil.addIdentifierToSql(this.m_originalSql);
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.new_row_prefetch = this.default_row_prefetch;
                this.prepare_for_new_result();
                this.sql_query = this.m_revisedSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(1);
                }
                this.prepare_for_new_result();
                this.get_data_for_columns(this.batch);
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
            }
            catch (SQLException sQLException) {
                bl = false;
                string = sQLException.getMessage();
                this.m_binds = this.binds_in;
            }
            if (bl) {
                this.m_realRsetType = this.m_userRsetType;
            } else {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.new_row_prefetch = this.default_row_prefetch;
                this.prepare_for_new_result();
                this.sql_query = this.m_originalSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(-1);
                }
                this.prepare_for_new_result();
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                bl = true;
            }
        }
        if (this.current_result_set == null || !bl) {
            DBError.check_error(1, "Unable to create result set");
        } else {
            if (this.m_userRsetType != this.m_realRsetType) {
                this.m_warning = DBError.addSqlWarning(this.m_warning, 91, string);
            }
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
        }
        this.m_scrollRsetTypeSolved = true;
        return this.valid_rows;
    }

    private boolean doesJdbcBatchExist() {
        return this.m_currentRank > 0 && this.m_batchStyle == 2;
    }

    void end_of_result_set() throws SQLException {
        this.prepare_for_new_result();
    }

    public synchronized boolean execute() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.execute()");
        }
        this.checkIfJdbcBatchExists();
        this.executeUpdate();
        DBAccess cfr_ignored_0 = this.connection.db_access;
        return this.sql_kind == 0;
    }

    public synchronized int[] executeBatch() throws SQLException {
        int n = 0;
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.executeBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Execute batch: m_currentRank=" + this.m_currentRank);
        }
        this.setJdbcBatchStyle();
        if (this.m_currentRank == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.m_currentRank];
        this.ensureOpen();
        this.new_row_prefetch = this.default_row_prefetch;
        this.prepare_for_new_result();
        if (this.sql_string_changed) {
            this.parseSqlKind();
        }
        if (this.sql_kind == 0) {
            DBError.throwBatchUpdateException(80, 0, null);
        }
        try {
            this.need_to_parse = true;
            this.doExecuteOther(true);
        }
        finally {
            Object var4_3 = null;
            this.cleanupForBatching();
        }
        if (this.valid_rows < 0) {
            n = 0;
            while (n < nArray.length) {
                nArray[n] = -3;
                ++n;
            }
            DBError.throwBatchUpdateException(81, 0, nArray);
        }
        n = 0;
        while (n < nArray.length) {
            nArray[n] = -2;
            ++n;
        }
        return nArray;
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.executeQuery()");
        }
        this.executeUpdate();
        if (this.isRegularResultSet()) {
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            return this.current_result_set;
        }
        if (this.m_scrollRset == null) {
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_scrollRset = this.current_result_set;
        }
        return this.m_scrollRset;
    }

    public synchronized int executeUpdate() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.executeUpdate()");
        }
        this.checkIfJdbcBatchExists();
        this.ensureOpen();
        if (this.has_ref_cursors) {
            this.need_to_parse = true;
        }
        if (this.isRegularResultSet()) {
            this.new_row_prefetch = this.default_row_prefetch;
            this.prepare_for_new_result();
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            return this.valid_rows;
        }
        if (this.m_scrollRsetTypeSolved) {
            this.new_row_prefetch = this.default_row_prefetch;
            this.prepare_for_new_result();
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
            return this.valid_rows;
        }
        return this.doScrollPstmtExecuteUpdate();
    }

    public DBDataSet getBinds() {
        return this.m_binds;
    }

    public final int getExecuteBatch() {
        return this.batch;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    private void get_data_for_columns(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.get_data_for_columns()");
        }
        this.binds_in.rowCompleted(this.m_currentRank);
        if (this.binds_out != null) {
            this.binds_out.rowCompleted(this.m_currentRank);
        }
    }

    private boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    private void printByteArray(byte[] byArray) {
        if (byArray == null) {
            System.out.println("<Null byte array!>");
        } else {
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = byArray[n2] & 0xFF;
                if (n3 < 16) {
                    System.out.print("0" + Integer.toHexString(n3) + " ");
                } else {
                    System.out.print(String.valueOf(Integer.toHexString(n3)) + " ");
                }
                ++n2;
            }
            System.out.println();
        }
    }

    private void privateClose(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.close()");
        }
        if (this.closed) {
            return;
        }
        if (this.doesJdbcBatchExist()) {
            this.clearBatch();
        } else {
            this.sendBatch();
        }
        if (this.connection.isStmtCacheEnabled() && this.m_cacheState != OracleStatement.CLOSED && this.m_cacheState != OracleStatement.NON_CACHED) {
            this.connection.cacheStatement(this);
            if (string != null) {
                this.m_key = string;
                this.m_createState = 2;
                return;
            }
            this.m_createState = 1;
        } else {
            super.close();
        }
        if (string == null) {
            this.cleanup();
        }
    }

    void scrollStmt_cleanup(boolean bl) throws SQLException {
        this.m_binds = null;
        super.scrollStmt_cleanup(bl);
    }

    public synchronized int sendBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.sendBatch()");
            OracleLog.print(this.connection, 1, 16, 32, "Send batch: batch=" + this.batch + ", m_currentRank=" + this.m_currentRank);
        }
        if (this.isJdbcBatchStyle()) {
            return 0;
        }
        this.ensureOpen();
        if (this.m_currentRank <= 0) {
            return this.valid_rows;
        }
        int n = this.batch;
        try {
            --this.m_currentRank;
            if (this.batch != this.m_currentRank) {
                this.batch = this.m_currentRank;
                this.need_to_parse = true;
            }
            this.doExecuteWithTimeout();
        }
        finally {
            Object var3_2 = null;
            if (this.batch != n) {
                this.batch = n;
                this.need_to_parse = true;
            }
        }
        return this.valid_rows;
    }

    public synchronized void setARRAY(int n, ARRAY aRRAY) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setARRAYr(paramIndex=" + n + ", array)");
        }
        if (aRRAY == null) {
            DBError.throwSqlException(68);
        }
        if (aRRAY.getDescriptor() == null) {
            DBError.throwSqlException(61);
        }
        int n2 = n - 1;
        this.checkBindTypes(true, n2, 109);
        byte[] byArray = aRRAY.toBytes();
        this.binds_in.setADTBindItem(n2, this.m_currentRank, 109, byArray, aRRAY.getDescriptor().getOracleTypeCOLLECTION());
    }

    public synchronized void setArray(int n, Array array) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setArray(paramIndex=" + n + ", array)");
        }
        this.setARRAY(n, (ARRAY)array);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setAsciiStream(paramIndex=" + n + ", istream, length=" + n2 + ")");
        }
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3 = n - 1;
            int n4 = 0;
            n4 = this.connection.conversion.isUcs2CharSet() ? this.min_ascii_stream_size / 2 : this.min_ascii_stream_size;
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 1 || n2 <= n4 || !this.isRegularResultSet()) {
                try {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray, 0, n2);
                    byte[] byArray2 = this.connection.conversion.asciiBytesToCHARBytes(byArray);
                    this.setItem(n3, 1, byArray2);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                InputStream inputStream2 = this.connection.conversion.ConvertStream(inputStream, 5, n2);
                this.setStreamItem(n3, 8, inputStream2, n2);
            }
        } else {
            this.setString(n, null);
        }
    }

    public synchronized void setBFILE(int n, BFILE bFILE) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBFILE(paramIndex=" + n + ", bfile)");
        }
        this.setDatum(n - 1, 114, bFILE);
    }

    public synchronized void setBLOB(int n, BLOB bLOB) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBLOB(paramIndex=" + n + ", lob)");
        }
        this.setDatum(n - 1, 113, bLOB);
    }

    public synchronized void setBfile(int n, BFILE bFILE) throws SQLException {
        this.setBFILE(n, bFILE);
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBigDecimal(paramIndex=" + n + ", x=" + bigDecimal + ")");
        }
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.BigDecimalToNumberBytes(bigDecimal);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBinaryStream(paramIndex=" + n + ", istream, length=" + n2 + ")");
        }
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3 = n - 1;
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 1 || n2 <= this.min_binary_stream_size || !this.isRegularResultSet()) {
                try {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray, 0, n2);
                    this.setItem(n3, 23, byArray);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n3, 24, inputStream, n2);
            }
        } else {
            this.setBytes(n, null);
        }
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        this.setBLOB(n, (BLOB)blob);
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBoolean(paramIndex=" + n + ", x=" + bl + ")");
        }
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.BooleanToNumberBytes(bl);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setByte(paramIndex=" + n + ", x=" + by + ")");
        }
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.ByteToNumberBytes(by);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setBytes(paramIndex=" + n + ", bytes)");
        }
        int n2 = n - 1;
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.setItem(n2, 23, byArray2);
        } else {
            this.setItem(n2, 23, null);
        }
    }

    public synchronized void setCHAR(int n, CHAR cHAR) throws SQLException {
        if (OracleLog.TRACE) {
            String string = null;
            string = cHAR == null ? "=null" : "(charset=" + String.valueOf(cHAR.getCharacterSet().getOracleId()) + ")";
            OracleLog.print(1, 16, 1, "OraclePreparedStatement.setCHAR(paramIdx=" + n + ", CHAR" + string + ")");
        }
        int n2 = 96;
        if (cHAR != null) {
            short s = (short)cHAR.getCharacterSet().getOracleId();
            n2 = 96;
            if (OracleLog.TRACE) {
                OracleLog.print(1, 8, "OraclePreparedStatement.setCHAR() may not be able to handle charset of " + s);
            }
        }
        this.setDatum(n - 1, n2, cHAR);
    }

    public synchronized void setCLOB(int n, CLOB cLOB) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setCLOB(paramIndex=" + n + ", clob)");
        }
        this.setDatum(n - 1, 112, cLOB);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setCharacterStream(paramIndex=" + n + ", reader, length=" + n2 + ")");
        }
        this.set_execute_batch(1);
        if (reader != null) {
            int n3 = n - 1;
            InputStream inputStream = this.connection.conversion.ConvertStream(reader, 7, n2);
            int n4 = this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio() / this.connection.conversion.getMaxCharbyteSize();
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 1 || n2 <= n4 || !this.isRegularResultSet()) {
                try {
                    int n5;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n5 = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                    }
                    this.setItem(n3, 1, byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n3, 8, inputStream, n2 * this.connection.conversion.getMaxCharbyteSize());
            }
        } else {
            this.setString(n, null);
        }
    }

    public void setCheckBindTypes(boolean bl) {
        this.check_bind_types = bl;
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        this.setCLOB(n, (CLOB)clob);
    }

    public synchronized void setCursor(int n, ResultSet resultSet) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setCursor(paramIndex=" + n + ", rs)");
        }
        int n2 = n - 1;
        DBAccess dBAccess = this.connection.db_access;
        byte[] byArray = null;
        try {
            byArray = dBAccess.DBStatementToRefCursorBytes(((OracleResultSetImpl)resultSet).statement.dbstmt);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.setItem(n2, 102, byArray);
    }

    public synchronized void setCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setCustomDataum(paramIndex=" + n + ", customDatum)");
        }
        Datum datum = customDatum.toDatum(this.connection);
        this.setOracleObject(n, datum);
    }

    public synchronized void setDATE(int n, DATE dATE) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setDATE(paramIndex=" + n + ", date=" + dATE + ")");
        }
        this.setDatum(n - 1, 12, dATE);
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setDate(paramIndex=" + n + ", date)");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.DateToDateBytes(date);
        this.setItem(n2, 12, byArray);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDATE(n, date == null ? null : new DATE(date, calendar));
    }

    private void setDatum(int n, int n2, Datum datum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(1, 16, "OraclePreparedStatement.setDatum(index=" + n + ", type=" + n2 + ", datum)");
        }
        if (datum == null) {
            this.setItem(n, n2, null);
        } else {
            this.setItem(n, n2, datum.getBytes());
        }
    }

    public synchronized void setDisableStmtCaching(boolean bl) {
        if (bl) {
            this.m_cacheState = OracleStatement.NON_CACHED;
        }
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setDouble(paramIndex=" + n + ", x=" + d + ")");
        }
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.DoubleToNumberBytes(d);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setExecuteBatch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setExecuteBatch(batchValue=" + n + ")");
        }
        this.setOracleBatchStyle();
        this.set_execute_batch(n);
    }

    public synchronized void setFixedCHAR(int n, String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setFixedCHAR(paramIndex=" + n + ", x=" + string + ")");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.StringToCharBytes(string);
        this.setItem(n2, 999, byArray);
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setFloat(paramIndex=" + n + ", x=" + f + ")");
        }
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.FloatToNumberBytes(f);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setInt(paramIndex=" + n + ", x=" + n2 + ")");
        }
        int n3 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.IntToNumberBytes(n2);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setInternalBytes(int n, byte[] byArray, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setInternalBytes(paramIndex=" + n + ", bytes, dbtype=" + n2);
        }
        int n3 = n - 1;
        this.setItem(n3, n2, byArray);
    }

    protected void setItem(int n, int n2, byte[] byArray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setItem(index=" + n + ", type=" + n2 + ", array)");
        }
        this.checkBindTypes(true, n, n2);
        if (this.binds_in.setBytesBindItem(n, this.m_currentRank, n2, byArray)) {
            this.need_to_parse = true;
        }
    }

    protected final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            DBError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setLong(paramIndex=" + n + ", x=" + l + ")");
        }
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.LongToNumberBytes(l);
        this.setItem(n2, 6, byArray);
    }

    public synchronized void setNUMBER(int n, NUMBER nUMBER) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setNUMBER(paramIndex=" + n + ", num)");
        }
        this.setDatum(n - 1, 6, nUMBER);
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setNull(paramIndex=" + n + ", sqlType=" + n2 + ")");
        }
        if (n2 == 2002 || n2 == 2003 || n2 == 2006) {
            DBError.throwSqlException(4, "sqlType=" + n2);
        }
        int n3 = n - 1;
        int n4 = this.get_internal_type(n2);
        this.checkBindTypes(true, n3, n4);
        switch (n4) {
            case 8: {
                n4 = 1;
                break;
            }
            case 24: {
                n4 = 23;
                break;
            }
        }
        this.binds_in.setNullBindItem(n3, this.m_currentRank, n4);
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setNull(paramIndex=" + n + ", sqlType=" + n2 + ", sqlName=" + string + ")");
        }
        if (n2 == 2002 || n2 == 2003 || n2 == 2006) {
            int n3 = this.get_internal_type(n2);
            OracleTypeADT oracleTypeADT = null;
            int n4 = n - 1;
            this.checkBindTypes(true, n4, n3);
            if (n2 == 2002 || n2 == 2006) {
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, this.connection);
                oracleTypeADT = structDescriptor.getOracleTypeADT();
            } else if (n2 == 2003) {
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, this.connection);
                oracleTypeADT = arrayDescriptor.getOracleTypeCOLLECTION();
            }
            this.binds_in.setNullADTBindItem(n4, this.m_currentRank, n3, oracleTypeADT);
        } else {
            this.setNull(n, n2);
        }
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setObject(paramIndex=" + n + ", object)");
        }
        if (object instanceof CustomDatum) {
            this.setCustomDatum(n, (CustomDatum)object);
        } else {
            int n2 = this.sqlTypeForObject(object);
            this.setObject(n, object, n2, 0);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setObject(paramIndex=" + n + ", object, targetSqlType=" + n2 + ", scale=" + n3 + ")");
        }
        switch (n2) {
            case 1: {
                if (object instanceof CHAR) {
                    this.setCHAR(n, (CHAR)object);
                    break;
                }
                this.setString(n, (String)object);
                break;
            }
            case 12: {
                this.setString(n, (String)object);
                break;
            }
            case -1: {
                this.setString(n, (String)object);
                break;
            }
            case 2: {
                if (object instanceof NUMBER) {
                    this.setNUMBER(n, (NUMBER)object);
                    break;
                }
                if (object instanceof Byte) {
                    this.setByte(n, (Byte)object);
                    break;
                }
                if (object instanceof Short) {
                    this.setShort(n, (Short)object);
                    break;
                }
                if (object instanceof Integer) {
                    this.setInt(n, (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setLong(n, (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setFloat(n, ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setDouble(n, (Double)object);
                    break;
                }
                this.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case 3: {
                this.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case -7: {
                this.setBoolean(n, (Boolean)object);
                break;
            }
            case -6: {
                this.setByte(n, (byte)((Integer)object).intValue());
                break;
            }
            case 5: {
                this.setShort(n, (short)((Integer)object).intValue());
                break;
            }
            case 4: {
                this.setInt(n, (Integer)object);
                break;
            }
            case -5: {
                this.setLong(n, (Long)object);
                break;
            }
            case 7: {
                this.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case 6: {
                this.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case 8: {
                this.setDouble(n, (Double)object);
                break;
            }
            case -2: {
                if (object instanceof RAW) {
                    this.setRAW(n, (RAW)object);
                    break;
                }
                this.setBytes(n, (byte[])object);
                break;
            }
            case -3: {
                this.setBytes(n, (byte[])object);
                break;
            }
            case -4: {
                this.setBytes(n, (byte[])object);
                break;
            }
            case 91: {
                if (object instanceof DATE) {
                    this.setDATE(n, (DATE)object);
                    break;
                }
                this.setDate(n, (Date)object);
                break;
            }
            case 92: {
                this.setTime(n, (Time)object);
                break;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                break;
            }
            case -8: {
                this.setROWID(n, (ROWID)object);
                break;
            }
            case 2004: {
                this.setBLOB(n, (BLOB)object);
                break;
            }
            case 2005: {
                this.setCLOB(n, (CLOB)object);
                break;
            }
            case -13: {
                this.setBFILE(n, (BFILE)object);
                break;
            }
            case -10: {
                this.setCursor(n, (OracleResultSet)object);
                break;
            }
            case 2002: {
                this.setSTRUCT(n, STRUCT.toSTRUCT(object, this.connection));
                break;
            }
            case 2003: {
                this.setARRAY(n, (ARRAY)object);
                break;
            }
            case 2006: {
                this.setREF(n, (REF)object);
                break;
            }
            default: {
                DBError.throwSqlException(4);
            }
        }
    }

    protected final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            DBError.throwSqlException(90, "operation cannot be mixed with JDBC-2.0-style batching");
        } else if (this.m_batchStyle == 0 && OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 32, "First detected Oracle-style batching");
        }
        this.m_batchStyle = 1;
    }

    public synchronized void setOracleObject(int n, Datum datum) throws SQLException {
        this.setObject(n, datum);
    }

    public synchronized void setPlsqlIndexTable(int n, Object object, int n2, int n3, int n4, int n5) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OracleCallableStatement.setPlsqlIndexTable(paramIndex=" + n + ", arrayData=" + object + " , maxLen=" + n2 + " , curLen=" + n3 + " , elemSqlType=" + n4 + " , " + n5 + ")");
        }
        if (n2 < 0 || n3 < 0 || n2 < n3) {
            DBError.throwSqlException(68, "maxLen < 0, curLen < 0 or maxLen < curLen ");
        }
        int n6 = this.get_internal_type(n4);
        this.checkPlsqlIndexTableBindTypes(true, n - 1, n2, n6, n5);
        Datum[] datumArray = null;
        switch (n6) {
            case 1: 
            case 96: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.connection);
                datumArray = oracleTypeCHAR.toDatumArray(object, this.connection, 1L, n3);
                break;
            }
            case 2: 
            case 6: {
                datumArray = OracleTypeNUMBER.toNUMBERArray(object, this.connection, 1L, n3);
                break;
            }
            default: {
                DBError.throwSqlException(97);
                return;
            }
        }
        this.need_to_parse = this.binds_in.setPlsqlIndexTableItem(n - 1, this.m_currentRank, datumArray, n2, n3, n6, n5);
    }

    public synchronized void setRAW(int n, RAW rAW) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setRAW(paramIndex=" + n + ", raq)");
        }
        this.setDatum(n - 1, 23, rAW);
    }

    public synchronized void setREF(int n, REF rEF) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setREF(paramIndex=" + n + ", ref)");
        }
        if (rEF == null) {
            DBError.throwSqlException(68);
        }
        if (rEF.getDescriptor() == null) {
            DBError.throwSqlException(52);
        }
        int n2 = n - 1;
        this.checkBindTypes(true, n2, 111);
        byte[] byArray = rEF.getBytes();
        this.binds_in.setADTBindItem(n2, this.m_currentRank, 111, byArray, rEF.getDescriptor().getOracleTypeADT());
    }

    public synchronized void setROWID(int n, ROWID rOWID) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setROWID(paramIndex=" + n + ", rowid)");
        }
        this.setDatum(n - 1, 104, rOWID);
    }

    public synchronized void setRef(int n, Ref ref) throws SQLException {
        this.setREF(n, (REF)ref);
    }

    public void setRefType(int n, REF rEF) throws SQLException {
        this.setREF(n, rEF);
    }

    public synchronized void setSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setSTRUCT(paramIndex=" + n + ", struct)");
        }
        int n2 = n - 1;
        if (sTRUCT == null) {
            DBError.throwSqlException(68);
        }
        if (sTRUCT.getDescriptor() == null) {
            DBError.throwSqlException(61);
        }
        this.checkBindTypes(true, n2, 109);
        byte[] byArray = sTRUCT.toBytes();
        this.binds_in.setADTBindItem(n2, this.m_currentRank, 109, byArray, sTRUCT.getDescriptor().getOracleTypeADT());
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setShort(paramIndex=" + n + ", x=" + s + ")");
        }
        int n2 = n - 1;
        DBConversion cfr_ignored_0 = this.connection.conversion;
        byte[] byArray = DBConversion.ShortToNumberBytes(s);
        this.setItem(n2, 6, byArray);
    }

    protected void setStreamItem(int n, int n2, InputStream inputStream, int n3) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setStreamItem(index=" + n + ", type=" + n2 + ", istream, size=" + n3 + ")");
        }
        if (n3 < 0) {
            DBError.throwSqlException(43);
        }
        this.checkBindTypes(true, n, n2);
        this.binds_in.setStreamBindItem(n, this.m_currentRank, n2, inputStream, n3);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setString(paramIndex=" + n + ", x=" + string + ")");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.StringToCharBytes(string);
        this.setItem(n2, 1, byArray);
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setTime(paramIndex=" + n + ", time)");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.TimeToDateBytes(time);
        this.setItem(n2, 12, byArray);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setDATE(n, time == null ? null : new DATE(time, calendar));
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setTimestamp(paramIndex=" + n + ", timestamp)");
        }
        int n2 = n - 1;
        byte[] byArray = this.connection.conversion.TimestampToDateBytes(timestamp);
        this.setItem(n2, 12, byArray);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setDATE(n, timestamp == null ? null : new DATE(timestamp, calendar));
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 1, "OraclePreparedStatement.setUnicodeStream(paramIndex=" + n + ", istream, length=" + n2 + ")");
        }
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n3 = n - 1;
            InputStream inputStream2 = this.connection.conversion.ConvertStream(inputStream, 4, n2);
            int n4 = 2 * (this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio()) / this.connection.conversion.getMaxCharbyteSize();
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 1 || n2 <= n4 || !this.isRegularResultSet()) {
                try {
                    int n5;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n5 = inputStream2.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                    }
                    this.setItem(n3, 1, byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n3, 8, inputStream2, n2 * this.connection.conversion.getMaxCharbyteSize());
            }
        } else {
            this.setString(n, null);
        }
    }

    private synchronized void set_execute_batch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this.connection, 1, 16, 16, "OraclePreparedStatement.setExecuteBatch(batchValue=" + n + "): batch=" + this.batch);
        }
        if (n <= 0) {
            DBError.throwSqlException(42);
        }
        if (n == this.batch) {
            return;
        }
        this.batch = n;
        if (this.m_currentRank > 0) {
            this.sendBatch();
        }
        this.binds_in.setBatchSize(n);
        this.need_to_parse = true;
    }

    int sqlTypeForObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Datum)) {
            if (object instanceof String) {
                return 12;
            }
            if (object instanceof BigDecimal) {
                return 2;
            }
            if (object instanceof Boolean) {
                return -7;
            }
            if (object instanceof Integer) {
                return 4;
            }
            if (object instanceof Long) {
                return -5;
            }
            if (object instanceof Float) {
                return 6;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof byte[]) {
                return -3;
            }
            if (object instanceof Date) {
                return 91;
            }
            if (object instanceof Time) {
                return 92;
            }
            if (object instanceof Timestamp) {
                return 93;
            }
            if (object instanceof SQLData) {
                return 2002;
            }
            if (object instanceof CustomDatum) {
                return 2002;
            }
        } else {
            if (object instanceof BLOB) {
                return 2004;
            }
            if (object instanceof CLOB) {
                return 2005;
            }
            if (object instanceof BFILE) {
                return -13;
            }
            if (object instanceof ROWID) {
                return -8;
            }
            if (object instanceof NUMBER) {
                return 2;
            }
            if (object instanceof DATE) {
                return 91;
            }
            if (object instanceof REF) {
                return 2006;
            }
            if (object instanceof CHAR) {
                return 1;
            }
            if (object instanceof RAW) {
                return -2;
            }
            if (object instanceof ARRAY) {
                return 2003;
            }
            if (object instanceof STRUCT) {
                return 2002;
            }
        }
        return 1111;
    }
}

