/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.ClientDataSupport;
import oracle.jdbc.driver.LRUStmtCache;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.oci.OCIAppFailoverCbk;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobDBAccessImpl;

public class OracleConnection
implements oracle.jdbc.internal.OracleConnection,
ClientDataSupport {
    public static final boolean DEBUG = false;
    private static String dll_string = "dll";
    private String url;
    private String user;
    private String password;
    private String database;
    private boolean auto_commit;
    private String protocol;
    public DBAccess db_access;
    public DBConversion conversion;
    public LobDBAccessImpl lob_dbaccess;
    public boolean XA_wants_error;
    public boolean UsingXA;
    private byte[] fdo;
    private Boolean big_endian;
    Hashtable statement_table;
    boolean closed;
    int default_batch;
    int default_row_prefetch;
    boolean report_remarks;
    boolean include_synonyms = false;
    boolean restrict_getTables = false;
    int new_row_prefetch;
    private int trans_level;
    Map map;
    Hashtable descriptorCache;
    OracleStatement statement_holding_line;
    oracle.jdbc.OracleDatabaseMetaData m_dbMetaData = null;
    private boolean physicalStatus;
    private boolean logicalHandle;
    private OraclePooledConnection m_opc = null;
    private OracleConnection m_opc_oc = null;
    static int DEFAULT_ROW_PREFETCH = 10;
    private static OracleSql s_osql = null;
    SQLWarning m_warning = null;
    private int m_stmtCacheSize = 0;
    private LRUStmtCache m_stmtCache = null;
    boolean m_stmtClearMetaData = false;
    boolean m_defaultAutoRefetch = true;
    static final String COMPATIBLE_TO_816_PROPERTY = "jdbc.backward_compatible_to_816";
    Boolean m_816Compatible = null;
    private static boolean m_traceEnabled = false;
    static final int BINARYSTREAM = 0;
    static final int ASCIISTREAM = 1;
    static final int UNICODESTREAM = 2;
    static final int EOJ_NON = 0;
    static final int EOJ_B_TO_A = 1;
    static final int EOJ_B_TO_U = 2;
    static final int EOJ_A_TO_U = 3;
    static final int EOJ_8_TO_A = 4;
    static final int EOJ_8_TO_U = 5;
    static final int EOJ_U_TO_A = 6;
    static final int ASCII_CHARSET = 0;
    static final int NLS_CHARSET = 1;
    public static final int CHAR_TO_ASCII = 0;
    public static final int CHAR_TO_UNICODE = 1;
    public static final int RAW_TO_ASCII = 2;
    public static final int RAW_TO_UNICODE = 3;
    public static final int UNICODE_TO_CHAR = 4;
    public static final int ASCII_TO_CHAR = 5;
    public static final int NONE = 6;
    public static final int JAVACHAR_TO_CHAR = 7;
    public static final int RAW_TO_JAVACHAR = 8;
    public static final int CHAR_TO_JAVACHAR = 9;
    private Hashtable m_clientData;

    public OracleConnection(DBAccess dBAccess, String string, String string2, String string3, String string4, Properties properties) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.OracleConnection(access, ur=\"" + string + "\", us=\"" + string2 + "\", p=\"" + string3 + "\", db=\"" + string4 + "\", info)");
        }
        String string5 = null;
        if (properties != null) {
            string5 = (String)((Hashtable)properties).get("protocol");
        }
        this.initialize(string, string2, string5, dBAccess, null);
        this.logicalHandle = false;
        try {
            this.needLine();
            this.conversion = this.db_access.logon(string2, string3, string4, properties);
            this.m_warning = this.db_access.getWarnings();
            this.default_row_prefetch = this.db_access.getDefaultPrefetch();
            this.setAutoCommit(true);
            this.db_access.initNls(this);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    public OracleConnection(OraclePooledConnection oraclePooledConnection, OracleConnection oracleConnection, boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.OracleConnection(par, pc, autoCommit=" + bl + ")");
        }
        this.initialize(oracleConnection.url, oracleConnection.user, oracleConnection.protocol, oracleConnection.db_access, oracleConnection.descriptorCache);
        this.logicalHandle = true;
        this.m_opc = oraclePooledConnection;
        this.m_opc_oc = oracleConnection;
        this.conversion = oracleConnection.conversion;
        if (oracleConnection.isStmtCacheEnabled()) {
            this.m_stmtCacheSize = oracleConnection.m_stmtCacheSize;
            this.m_stmtCache = oracleConnection.m_stmtCache;
            this.m_stmtClearMetaData = oracleConnection.m_stmtClearMetaData;
            if (this.m_stmtCacheSize == 0 && this.m_stmtCache != null) {
                this.m_stmtCache.close();
                this.m_stmtCache = null;
            }
        }
        this.setAutoCommit(bl);
    }

    synchronized void add_statement(Statement statement) {
        this.statement_table.put(statement, statement);
    }

    public synchronized void archive(int n, int n2, String string) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.archive(n, n2, string);
    }

    synchronized void cacheStatement(OracleStatement oracleStatement) throws SQLException {
        if (this.m_stmtCache != null) {
            this.m_stmtCache.add(oracleStatement);
        }
    }

    private void checkPhyiscalStatus() throws SQLException {
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
    }

    private void cleanup() {
        this.fdo = null;
        this.db_access = null;
        this.conversion = null;
        this.statement_table = null;
        this.descriptorCache = null;
        this.map = null;
        this.statement_holding_line = null;
        this.m_opc = null;
        s_osql = null;
    }

    public void clearWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.clearWarnings()");
        }
        this.m_warning = null;
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.close()");
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.close_statements();
        if (this.logicalHandle) {
            this.logicalClose();
            return;
        }
        try {
            this.XA_wants_error = false;
            this.needLine();
            this.db_access.logoff();
            this.cleanup();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    public synchronized void close_statements() throws SQLException {
        if (this.m_stmtCacheSize > 0 && !this.logicalHandle) {
            this.m_stmtCacheSize = 0;
            this.m_stmtClearMetaData = true;
            this.m_stmtCache.close();
            this.m_stmtCache = null;
        } else {
            OracleStatement oracleStatement;
            Enumeration enumeration = this.statement_table.elements();
            while (enumeration.hasMoreElements()) {
                oracleStatement = (OracleStatement)enumeration.nextElement();
                if (oracleStatement == null || !oracleStatement.serverCursor) continue;
                oracleStatement.close();
                this.remove_statement(oracleStatement);
                oracleStatement = null;
            }
            enumeration = this.statement_table.elements();
            while (enumeration.hasMoreElements()) {
                oracleStatement = (OracleStatement)enumeration.nextElement();
                if (oracleStatement == null) continue;
                oracleStatement.close();
                oracleStatement = null;
            }
        }
    }

    public synchronized void commit() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.commit()");
        }
        this.checkPhyiscalStatus();
        if (this.XA_wants_error || this.UsingXA) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration.hasMoreElements()) {
            OracleStatement oracleStatement = (OracleStatement)enumeration.nextElement();
            oracleStatement.sendBatch();
        }
        try {
            this.needLine();
            this.db_access.commit();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.privateCreateStatement(-1, -1, null);
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        return this.privateCreateStatement(n, n2, null);
    }

    public synchronized Statement createStatementWithKey(String string) throws SQLException {
        if (string != null && this.m_stmtCacheSize <= 0) {
            DBError.throwSqlException(95);
        }
        if (string == null) {
            return null;
        }
        return this.privateCreateStatement(-1, -1, string);
    }

    public boolean getAutoClose() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getAutoClose()");
        }
        return true;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getAutoCommit() returned " + this.auto_commit);
        }
        return this.auto_commit;
    }

    public synchronized boolean getBigEndian() throws SQLException {
        if (this.big_endian == null) {
            int[] nArray = Util.toJavaUnsignedBytes(this.getFDO(true));
            int n = nArray[6 + nArray[5] + nArray[6] + 5];
            int n2 = n & 0x10;
            if (n2 < 0) {
                n2 += 256;
            }
            this.big_endian = n2 > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.big_endian;
    }

    public String getCatalog() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getCatalog()");
        }
        return null;
    }

    public synchronized Object getClientData(Object object) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.getClientData(key)");
            OracleLog.print(this, 1, 8, 32, "key: " + object);
        }
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.get(object);
    }

    public Properties getDBAccessProperties() throws SQLException {
        if (this.db_access == null) {
            return null;
        }
        return this.db_access.getDBAccessProperties();
    }

    public String getDatabaseProductVersion() throws SQLException {
        int[] nArray = new int[1];
        try {
            this.needLine();
            byte[] byArray = this.db_access.getVersion();
            return this.conversion.CharBytesToString(byArray, byArray.length);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public short getDbCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getDbCharSet();
    }

    public boolean getDefaultAutoRefetch() throws SQLException {
        return this.m_defaultAutoRefetch;
    }

    public synchronized int getDefaultExecuteBatch() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getDefaultExecuteBatch() returned " + this.default_batch);
        }
        return this.default_batch;
    }

    public synchronized int getDefaultRowPrefetch() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getDefaultRowPrefetch() returned " + this.default_row_prefetch);
        }
        return this.default_row_prefetch;
    }

    public synchronized Object getDescriptor(String string) {
        Object var2_2 = null;
        if (string != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(string);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, 16, 64, 32, "OracleConnection.getDescriptor (" + string + ") return " + var2_2);
        }
        return var2_2;
    }

    public synchronized byte[] getFDO(boolean bl) throws SQLException {
        if (this.fdo == null && bl) {
            CallableStatement callableStatement = null;
            try {
                this.checkPhyiscalStatus();
                callableStatement = this.prepareCall("begin ? := dbms_pickler.get_format (?); end;");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.registerOutParameter(2, -4);
                callableStatement.execute();
                this.fdo = callableStatement.getBytes(2);
            }
            finally {
                Object var4_3 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
            }
        }
        return this.fdo;
    }

    public boolean getIncludeSynonyms() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getIncludeSynonyms() returned " + this.include_synonyms);
        }
        return this.include_synonyms;
    }

    public synchronized Object getJavaObject(String string) throws SQLException {
        Object var2_2 = null;
        try {
            if (string != null && this.map != null) {
                Class clazz = (Class)this.map.get(string);
                var2_2 = clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return var2_2;
    }

    public short getJdbcCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getAccessCharSet();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getMetaData()");
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new OracleDatabaseMetaData(this);
        }
        return this.m_dbMetaData;
    }

    public String getProtocolType() {
        return this.protocol;
    }

    public synchronized boolean getRemarksReporting() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getRemarksReporting()");
        }
        return this.report_remarks;
    }

    public boolean getReportRemarks() {
        return this.report_remarks;
    }

    public boolean getRestrictGetTables() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getRestrictGetTables() returned " + this.restrict_getTables);
        }
        return this.restrict_getTables;
    }

    public synchronized String getSQLType(Object object) throws SQLException {
        if (object != null && this.map != null) {
            String string = object.getClass().getName();
            return (String)this.map.get(string);
        }
        return null;
    }

    public synchronized int getStmtCacheSize() {
        return this.m_stmtCacheSize;
    }

    public synchronized short getStructAttrCsId() throws SQLException {
        return this.getDbCsId();
    }

    public int getTransactionIsolation() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getTransactionIsolation() returned " + this.trans_level);
        }
        return this.trans_level;
    }

    public synchronized Map getTypeMap() {
        return this.map;
    }

    public String getURL() {
        return this.url;
    }

    public synchronized String getUserName() throws SQLException {
        if (this.user == null) {
            this.initUserName();
        }
        return this.user;
    }

    public synchronized boolean getUsingXAFlag() {
        return this.UsingXA;
    }

    public short getVersionNumber() throws SQLException {
        return this.db_access.getVersionNumber();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.getWarnings()");
        }
        return this.m_warning;
    }

    public synchronized boolean getXAErrorFlag() {
        return this.XA_wants_error;
    }

    public synchronized void holdLine(OracleStatement oracleStatement) {
        this.statement_holding_line = oracleStatement;
    }

    private void initClientDataSupport() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.initClientDataSupport()");
        }
        this.m_clientData = null;
    }

    public synchronized void initUserName() throws SQLException {
        if (this.user != null) {
            return;
        }
        this.checkPhyiscalStatus();
        Statement statement = this.createStatement();
        ((OracleStatement)statement).setRowPrefetch(1);
        try {
            ResultSet resultSet = statement.executeQuery("select USER from dual");
            if (resultSet.next()) {
                this.user = resultSet.getString(1);
            }
            resultSet.close();
            resultSet = null;
        }
        finally {
            Object var3_3 = null;
            statement.close();
            statement = null;
        }
    }

    private void initialize(String string, String string2, String string3, DBAccess dBAccess, Hashtable hashtable) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.initialize(ur=\"" + string + "\", us=\"" + string2 + "\", access)");
        }
        this.initClientDataSupport();
        this.m_stmtCacheSize = 0;
        this.m_stmtCache = null;
        this.m_stmtClearMetaData = false;
        this.url = string;
        this.user = string2 != null ? string2.toUpperCase() : string2;
        this.db_access = dBAccess;
        this.protocol = string3;
        this.physicalStatus = true;
        this.default_row_prefetch = DEFAULT_ROW_PREFETCH;
        this.default_batch = 1;
        this.new_row_prefetch = 0;
        this.statement_table = new Hashtable(10);
        this.descriptorCache = hashtable != null ? hashtable : new Hashtable(10);
        this.map = new Hashtable(10);
        this.closed = false;
        this.trans_level = 2;
        this.XA_wants_error = false;
        this.UsingXA = false;
        this.fdo = null;
        this.big_endian = null;
    }

    public synchronized boolean isClosed() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.isClosed() returned " + this.closed);
        }
        return this.closed;
    }

    public boolean isCompatibleTo816() throws SQLException {
        block2: {
            boolean bl = false;
            if (this.m_816Compatible != null) break block2;
            try {
                String string = System.getProperty(COMPATIBLE_TO_816_PROPERTY);
                this.m_816Compatible = new Boolean(string != null);
            }
            catch (SecurityException securityException) {
                this.m_816Compatible = new Boolean(bl);
            }
        }
        return this.m_816Compatible;
    }

    public boolean isReadOnly() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.isReadOnly()");
        }
        return false;
    }

    synchronized boolean isStmtCacheEnabled() {
        return this.m_stmtCacheSize > 0;
    }

    public synchronized void logicalClose() throws SQLException {
        if (this.m_opc != null && this.physicalStatus) {
            this.m_opc.logicalClose();
        }
        this.setPhysicalStatus(false);
    }

    public String nativeSQL(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 128, 16, "OracleConnection.nativeSQL(sql)");
            OracleLog.print(this, 1, 128, 32, "Input SQL:  \"" + string + "\"");
        }
        if (s_osql == null) {
            s_osql = new OracleSql();
        }
        String string2 = s_osql.parse(string);
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 128, 32, "Output SQL: \"" + string2 + "\"");
        }
        return string2;
    }

    public synchronized void needLine() throws SQLException {
        if (this.XA_wants_error) {
            DBError.throwSqlException(63);
        }
        if (this.statement_holding_line != null) {
            this.statement_holding_line.freeLine();
        }
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        return this.privatePrepareCall(string, null, -1, -1);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.privatePrepareCall(string, null, n, n2);
    }

    public synchronized CallableStatement prepareCallWithKey(String string) throws SQLException {
        if (string != null && this.m_stmtCacheSize <= 0) {
            DBError.throwSqlException(95);
        }
        if (string == null) {
            return null;
        }
        return this.privatePrepareCall(null, string, -1, -1);
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        return this.privatePrepareStatement(string, null, -1, -1);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.privatePrepareStatement(string, null, n, n2);
    }

    public synchronized PreparedStatement prepareStatementWithKey(String string) throws SQLException {
        if (string != null && this.m_stmtCacheSize <= 0) {
            DBError.throwSqlException(95);
        }
        if (string == null) {
            return null;
        }
        return this.privatePrepareStatement(null, string, -1, -1);
    }

    public void printState() {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.printState()");
        }
        try {
            short s = this.getJdbcCsId();
            OracleLog.print(this, 1, 8, 32, "Jdbc character set id is   " + s);
            short s2 = this.getDbCsId();
            OracleLog.print(this, 1, 8, 32, "Db character set id is     " + s2);
            short s3 = this.getStructAttrCsId();
            OracleLog.print(this, 1, 8, 32, "STRUCT character set id is " + s3);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private Statement privateCreateStatement(int n, int n2, String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.createStatement(resultSetType=" + n + ", resultSetConcurrency=" + n2 + ")");
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleStatement oracleStatement = null;
        int n3 = OracleStatement.DEFAULT_RSET_TYPE;
        if (n != -1 || n2 != -1) {
            n3 = ResultSetUtil.getRsetTypeCode(n, n2);
        }
        if (this.m_stmtCacheSize > 0 && string != null) {
            oracleStatement = this.m_stmtCache.lookup(string, 0, n3);
            if (oracleStatement != null) {
                oracleStatement.m_key = null;
            }
            return oracleStatement;
        }
        oracleStatement = n != -1 || n2 != -1 ? new OracleStatement(this, 1, this.default_row_prefetch, n, n2) : new OracleStatement(this, 1, this.default_row_prefetch);
        return oracleStatement;
    }

    private CallableStatement privatePrepareCall(String string, String string2, int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.prepareCall(sql)");
            OracleLog.print(this, 1, 8, 32, "SQL: \"" + string + "\"");
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleCallableStatement oracleCallableStatement = null;
        int n3 = OracleStatement.DEFAULT_RSET_TYPE;
        if (n != -1 || n2 != -1) {
            n3 = ResultSetUtil.getRsetTypeCode(n, n2);
        }
        if (this.m_stmtCacheSize > 0) {
            if (string2 != null) {
                oracleCallableStatement = (OracleCallableStatement)this.m_stmtCache.lookup(string2, 2, n3);
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.m_key = null;
                }
                return oracleCallableStatement;
            }
            oracleCallableStatement = (OracleCallableStatement)this.m_stmtCache.lookup(string, 2, n3);
            if (oracleCallableStatement != null) {
                oracleCallableStatement.initializeStateAndData(this.default_batch, this.default_row_prefetch, this.m_defaultAutoRefetch, false);
                if (this.m_stmtClearMetaData) {
                    oracleCallableStatement.initializeMetaData();
                }
            }
        }
        if (oracleCallableStatement == null) {
            oracleCallableStatement = n != -1 || n2 != -1 ? new OracleCallableStatement(this, string, 1, this.default_row_prefetch, n, n2) : new OracleCallableStatement(this, string, 1, this.default_row_prefetch);
        }
        return oracleCallableStatement;
    }

    private PreparedStatement privatePrepareStatement(String string, String string2, int n, int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.prepareStatement(sql)");
            OracleLog.print(this, 1, 8, 32, "SQL: \"" + string + "\"");
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        int n3 = OracleStatement.DEFAULT_RSET_TYPE;
        if (n != -1 || n2 != -1) {
            n3 = ResultSetUtil.getRsetTypeCode(n, n2);
        }
        if (this.m_stmtCacheSize > 0) {
            if (string2 != null) {
                oraclePreparedStatement = (OraclePreparedStatement)this.m_stmtCache.lookup(string2, 1, n3);
                if (oraclePreparedStatement != null) {
                    oraclePreparedStatement.m_key = null;
                }
                return oraclePreparedStatement;
            }
            oraclePreparedStatement = (OraclePreparedStatement)this.m_stmtCache.lookup(string, 1, n3);
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.initializeStateAndData(this.default_batch, this.default_row_prefetch, this.m_defaultAutoRefetch, false);
                if (this.m_stmtClearMetaData) {
                    oraclePreparedStatement.initializeMetaData();
                }
            }
        }
        if (oraclePreparedStatement == null) {
            oraclePreparedStatement = n != -1 || n2 != -1 ? new OraclePreparedStatement(this, string, this.default_batch, this.default_row_prefetch, n, n2) : new OraclePreparedStatement(this, string, this.default_batch, this.default_row_prefetch);
        }
        return oraclePreparedStatement;
    }

    public synchronized void putDescriptor(String string, Object object) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, 16, 64, 32, "OracleConnection.putDescriptor (" + string + ", " + object + ")");
        }
        if (string != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(string, object);
        }
    }

    public synchronized void registerSQLType(String string, Class clazz) throws SQLException {
        if (string == null || clazz == null) {
            DBError.throwSqlException(68);
        }
        if (this.map == null) {
            this.map = new Hashtable(10);
        }
        this.map.put(string, clazz);
        this.map.put(clazz.getName(), string);
    }

    public synchronized void registerSQLType(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DBError.throwSqlException(68);
        }
        try {
            this.registerSQLType(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            DBError.throwSqlException(1, "Class not found: " + string2);
        }
    }

    public synchronized void registerTAFCallback(OCIAppFailoverCbk oCIAppFailoverCbk, Object object) {
        if (this.db_access != null) {
            this.db_access.registerTAFCallback(this, oCIAppFailoverCbk, object);
        }
    }

    public synchronized void releaseLine() {
        this.statement_holding_line = null;
    }

    public synchronized void removeAllDescriptor() {
        if (OracleLog.TRACE) {
            OracleLog.print(null, 16, 64, 32, "OracleConnection.removeAllDescriptor ()");
        }
        if (this.descriptorCache != null) {
            this.descriptorCache.clear();
        }
    }

    public synchronized Object removeClientData(Object object) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.removeClientData(key)");
            OracleLog.print(this, 1, 8, 32, "key: " + object);
        }
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.remove(object);
    }

    public synchronized void removeDecriptor(String string) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, 16, 64, 32, "OracleConnection.removeDescriptor (" + string + ")");
        }
        if (string != null && this.descriptorCache != null) {
            this.descriptorCache.remove(string);
        }
    }

    synchronized void remove_statement(Statement statement) {
        this.statement_table.remove(statement);
    }

    public synchronized void rollback() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.rollback()");
        }
        this.checkPhyiscalStatus();
        if (this.XA_wants_error || this.UsingXA) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        try {
            this.needLine();
            this.db_access.rollback();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    public synchronized void setAutoClose(boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setAutoClose(autoClose=" + bl + ")");
        }
        if (!bl) {
            DBError.throwSqlException(31);
        }
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setAutoCommit(autoCommit=" + bl + ")");
        }
        this.checkPhyiscalStatus();
        if (this.XA_wants_error || this.UsingXA && bl) {
            DBError.throwSqlException(69);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        try {
            this.needLine();
            this.db_access.setAutoCommit(bl);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.auto_commit = bl;
    }

    public void setCatalog(String string) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setCatalog(catalog=\"" + string + "\")");
        }
    }

    public synchronized Object setClientData(Object object, Object object2) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 16, "OracleConnection.setClientData(key, value)");
            OracleLog.print(this, 1, 8, 32, "key:   " + object);
            OracleLog.print(this, 1, 8, 32, "value: " + object2);
        }
        if (this.m_clientData == null) {
            this.m_clientData = new Hashtable();
        }
        return this.m_clientData.put(object, object2);
    }

    public void setDefaultAutoRefetch(boolean bl) throws SQLException {
        this.m_defaultAutoRefetch = bl;
    }

    public synchronized void setDefaultExecuteBatch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setDefaultExecuteBatch(batch=" + n + ")");
        }
        if (n <= 0) {
            DBError.throwSqlException(42);
        }
        this.default_batch = n;
    }

    public synchronized void setDefaultRowPrefetch(int n) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setDefaultRowPrefetch(value=" + n + ")");
        }
        if (n <= 0) {
            DBError.throwSqlException(20);
        }
        this.default_row_prefetch = n;
    }

    public synchronized void setFDO(byte[] byArray) throws SQLException {
        this.fdo = byArray;
    }

    public void setIncludeSynonyms(boolean bl) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setIncludeSynonyms(synonyms=" + bl + ")");
        }
        this.include_synonyms = bl;
    }

    public synchronized void setPhysicalStatus(boolean bl) {
        this.physicalStatus = bl;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setReadOnly(readOnly=" + bl + ")");
        }
        if (bl) {
            DBError.throwSqlException(29);
        }
    }

    public synchronized void setRemarksReporting(boolean bl) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setRemarksReporting(reportRemarks=" + bl + ")");
        }
        this.report_remarks = bl;
    }

    public void setRestrictGetTables(boolean bl) {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setRestrictGetTables(restrict=" + bl + ")");
        }
        this.restrict_getTables = bl;
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStmtCacheSize(n, false);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        if (this.logicalHandle) {
            DBError.throwSqlException(96);
        }
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        this.m_stmtCacheSize = n;
        if (n == 0 && this.m_stmtCache != null) {
            this.m_stmtCache.close();
            this.m_stmtCache = null;
            return;
        }
        if (this.m_stmtCache == null) {
            this.m_stmtCache = new LRUStmtCache(n);
        } else {
            this.m_stmtCache.setCacheSize(n);
        }
        this.m_stmtClearMetaData = bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setTransactionIsolation(int var1_1) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 8, 1, "OracleConnection.setTransactionIsolation(level=" + var1_1 + ")");
        }
        this.checkPhyiscalStatus();
        var2_2 = (OracleStatement)this.createStatement();
        try {
            switch (var1_1) {
                case 2: {
                    var2_2.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                    this.trans_level = 2;
                    ** break;
                }
                case 8: {
                    var2_2.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                    this.trans_level = 8;
                    ** break;
                }
            }
            DBError.throwSqlException(30);
        }
        catch (Throwable var3_5) {
            var4_4 = null;
            var2_2.close();
            throw var3_5;
        }
lbl24:
        // 3 sources

        var4_3 = null;
        var2_2.close();
    }

    public synchronized void setTypeMap(Map map) {
        this.map = map;
    }

    public synchronized void setUsingXAFlag(boolean bl) {
        this.UsingXA = bl;
    }

    public synchronized void setXAErrorFlag(boolean bl) {
        this.XA_wants_error = bl;
    }

    public synchronized void shutdown(int n) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.shutdown(n);
    }

    public synchronized void startup(String string, int n) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.startup(string, n);
    }

    public void trace(String string) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            if (m_traceEnabled) {
                OracleLog.setLogStream(null);
            }
            m_traceEnabled = false;
        } else {
            if (!m_traceEnabled) {
                OracleLog.setLogStream(printStream);
            }
            OracleLog.print(1, 32, string);
            m_traceEnabled = true;
        }
    }
}

