/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util.parserwrappers;

import java.io.IOException;
import java.io.Reader;
import org.freehep.xml.util.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesDOMParser
extends DOMParser {
    private int level = 0;

    public Document parse(Reader in, String fileName) throws DOMParser.XMLException {
        return this.parse(in, fileName, null);
    }

    public Document parse(Reader in, final String fileName, EntityResolver resolver) throws DOMParser.XMLException {
        try {
            org.apache.xerces.parsers.DOMParser parser = new org.apache.xerces.parsers.DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) {
                    System.err.println(fileName + ": Warning at line " + exception.getLineNumber() + ": " + exception);
                    if (XercesDOMParser.this.level < 1) {
                        XercesDOMParser.this.level = 1;
                    }
                }

                public void error(SAXParseException exception) {
                    System.err.println(fileName + ": Error at line " + exception.getLineNumber() + ": " + exception);
                    if (XercesDOMParser.this.level < 2) {
                        XercesDOMParser.this.level = 2;
                    }
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    System.err.println(fileName + ": Fatal error at line " + exception.getLineNumber() + ": " + exception);
                    if (XercesDOMParser.this.level < 3) {
                        XercesDOMParser.this.level = 3;
                    }
                    throw exception;
                }
            });
            if (resolver != null) {
                parser.setEntityResolver(resolver);
            }
            parser.parse(new InputSource(in));
            if (this.level > 1) {
                throw new SAXException("Error during XML file parsing");
            }
            return parser.getDocument();
        }
        catch (SAXException x) {
            throw new DOMParser.XMLException("Syntax error parsing XML file", x);
        }
        catch (IOException x) {
            throw new DOMParser.XMLException("IO error parsing XML file", x);
        }
    }
}

