/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.postscript;

import org.freehep.util.postscript.CharTable;
import org.freehep.util.postscript.Expert;
import org.freehep.util.postscript.ISOLatin;
import org.freehep.util.postscript.MACLatin;
import org.freehep.util.postscript.PDFLatin;
import org.freehep.util.postscript.STDLatin;
import org.freehep.util.postscript.Symbol;
import org.freehep.util.postscript.WINLatin;
import org.freehep.util.postscript.ZapfDingbats;

public class Lookup {
    private static Lookup instance;
    private CharTable[] tables = new CharTable[this.ntables];
    private int ntables = 8;

    public static Lookup getInstance() {
        if (instance == null) {
            instance = new Lookup();
        }
        return instance;
    }

    private Lookup() {
        this.tables[0] = new Symbol();
        this.tables[1] = new Expert();
        this.tables[2] = new ZapfDingbats();
        this.tables[3] = new STDLatin();
        this.tables[4] = new MACLatin();
        this.tables[5] = new WINLatin();
        this.tables[6] = new PDFLatin();
        this.tables[7] = new ISOLatin();
    }

    public char toUnicode(String name) {
        int i = 0;
        while (i < this.ntables) {
            char uc = this.tables[i].toUnicode("name");
            if (uc != '\uffff') {
                return uc;
            }
            ++i;
        }
        return '\uffff';
    }

    public String toName(int encoding) {
        int i = 0;
        while (i < this.ntables) {
            String name = this.tables[i].toName(encoding);
            if (name != null) {
                return name;
            }
            ++i;
        }
        return null;
    }

    public String toName(Integer encoding) {
        int i = 0;
        while (i < this.ntables) {
            String name = this.tables[i].toName(encoding);
            if (name != null) {
                return name;
            }
            ++i;
        }
        return null;
    }

    public String toName(char uc) {
        int i = 0;
        while (i < this.ntables) {
            String name = this.tables[i].toName(uc);
            if (name != null) {
                return name;
            }
            ++i;
        }
        return null;
    }

    public String toName(Character uc) {
        int i = 0;
        while (i < this.ntables) {
            String name = this.tables[i].toName(uc);
            if (name != null) {
                return name;
            }
            ++i;
        }
        return null;
    }

    public CharTable getTable(String tableName) {
        int i = 0;
        while (i < this.ntables) {
            String tblName = this.tables[i].getEncoding() + this.tables[i].getName();
            if (tblName.equals(tableName)) {
                return this.tables[i];
            }
            ++i;
        }
        return null;
    }

    public int getNumberOfTables() {
        return this.ntables;
    }

    public String[] getTableNames() {
        String[] tblnames = new String[this.ntables];
        int i = 0;
        while (i < this.ntables) {
            tblnames[i] = this.tables[i].getEncoding() + this.tables[i].getName();
            ++i;
        }
        return tblnames;
    }
}

