/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.pdf;

import java.text.DecimalFormat;
import java.util.Calendar;
import org.freehep.util.pdf.PDFConstants;

public class PDFUtil
implements PDFConstants {
    private PDFUtil() {
    }

    public static String escape(String string) {
        StringBuffer escape = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    break;
                }
                default: {
                    escape.append(c);
                }
            }
            ++i;
        }
        return escape.toString();
    }

    public static String date(Calendar date) {
        String tz;
        int offset = date.get(15) + date.get(16);
        if (offset == 0) {
            tz = "Z";
        } else {
            DecimalFormat fmt = new DecimalFormat("00");
            int tzh = Math.abs(offset / 3600000);
            int tzm = Math.abs(offset % 3600000);
            tz = offset > 0 ? "+" + fmt.format(tzh) + "'" + fmt.format(tzm) + "'" : "-" + fmt.format(tzh) + "'" + fmt.format(tzm) + "'";
        }
        return "(" + PDFConstants.dateFormat.format(date.getTime()) + tz + ")";
    }
}

