/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.pdf;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.ASCIIHexOutputStream;
import org.freehep.util.io.CountedByteOutputStream;
import org.freehep.util.io.FinishableOutputStream;
import org.freehep.util.io.FlateOutputStream;
import org.freehep.util.pdf.PDF;
import org.freehep.util.pdf.PDFByteWriter;
import org.freehep.util.pdf.PDFConstants;
import org.freehep.util.pdf.PDFDictionary;
import org.freehep.util.pdf.PDFName;
import org.freehep.util.pdf.PDFObject;
import org.freehep.util.pdf.PDFUtil;

public class PDFStream
extends PDFDictionary
implements PDFConstants {
    private String name;
    private boolean ok;
    private PDFObject object;
    private boolean dictionaryOpen;
    private String[] encode;
    private OutputStream[] stream;
    private CountedByteOutputStream byteCountStream;
    private int gStates = 0;
    private boolean textOpen = false;
    private boolean fontWasSet = false;
    private boolean imageOpen = false;
    private OutputStream[] imageStream;
    private boolean compatibilityOpen = false;

    PDFStream(PDF pdf, PDFByteWriter writer, String name, PDFObject parent, String[] encode) throws IOException {
        super(pdf, writer);
        this.name = name;
        this.object = parent;
        if (this.object == null) {
            System.err.println("PDFWriter: 'PDFStream' cannot have a null parent");
        }
        this.ok = true;
        this.dictionaryOpen = true;
        this.encode = encode;
    }

    private void write(int b) throws IOException {
        if (this.dictionaryOpen) {
            Object[] filters = PDFStream.decodeFilters(this.encode);
            if (filters != null) {
                this.entry("Filter", filters);
            }
            super.close();
            this.dictionaryOpen = false;
            this.out.printPlain("stream\n");
            this.byteCountStream = new CountedByteOutputStream(this.out);
            this.stream = PDFStream.openFilters(this.byteCountStream, this.encode);
        }
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFStream' was closed");
        }
        this.stream[0].write(b);
    }

    private static PDFName[] decodeFilters(String[] encode) {
        PDFName[] filters = null;
        if (encode != null && encode.length != 0) {
            filters = new PDFName[encode.length];
            int i = 0;
            while (i < filters.length) {
                filters[i] = new PDFName(encode[encode.length - i - 1] + "Decode");
                ++i;
            }
        }
        return filters;
    }

    private static OutputStream[] openFilters(OutputStream s, String[] filters) {
        OutputStream[] os;
        if (filters != null && filters.length != 0) {
            os = new OutputStream[filters.length + 1];
            os[os.length - 1] = s;
            int i = os.length - 2;
            while (i >= 0) {
                if (filters[i].equals("ASCIIHex")) {
                    os[i] = new ASCIIHexOutputStream(os[i + 1]);
                } else if (filters[i].equals("ASCII85")) {
                    os[i] = new ASCII85OutputStream(os[i + 1]);
                } else if (filters[i].equals("Flate")) {
                    os[i] = new FlateOutputStream(os[i + 1]);
                } else {
                    System.err.println("PDFWriter: unknown stream filter: " + filters[i]);
                }
                --i;
            }
        } else {
            os = new OutputStream[]{s};
        }
        return os;
    }

    private static void closeFilters(OutputStream[] s) throws IOException {
        int i = 0;
        while (i < s.length - 1) {
            s[i].flush();
            if (s[i] instanceof FinishableOutputStream) {
                ((FinishableOutputStream)((Object)s[i])).finish();
            }
            ++i;
        }
        s[s.length - 1].flush();
    }

    private void write(String s) throws IOException {
        byte[] b = s.getBytes("ISO-8859-1");
        int i = 0;
        while (i < b.length) {
            this.write(b[i]);
            ++i;
        }
    }

    void close() throws IOException {
        PDFStream.closeFilters(this.stream);
        this.stream = null;
        this.out.printPlain("\nendstream");
        this.out.println();
        this.object.close();
        this.ok = false;
    }

    String getName() {
        return this.name;
    }

    public int getLength() {
        return this.byteCountStream.getCount();
    }

    public void print(String s) throws IOException {
        this.write(s);
    }

    public void println(String s) throws IOException {
        this.write(s);
        this.write(PDFConstants.EOL);
    }

    public void comment(String comment) throws IOException {
        this.println("% " + comment);
    }

    public void save() throws IOException {
        this.println("q");
        ++this.gStates;
    }

    public void restore() throws IOException {
        if (this.gStates <= 0) {
            System.err.println("PDFStream: unbalanced saves()/restores()");
        }
        --this.gStates;
        this.println("Q");
    }

    public void matrix(double a, double b, double c, double d, double e, double f) throws IOException {
        this.println(a + " " + b + " " + c + " " + d + " " + e + " " + f + " cm");
    }

    public void width(double width) throws IOException {
        this.println(width + " w");
    }

    public void cap(int capStyle) throws IOException {
        this.println(capStyle + " J");
    }

    public void join(int joinStyle) throws IOException {
        this.println(joinStyle + " j");
    }

    public void mitterLimit(double limit) throws IOException {
        this.println(limit + " M");
    }

    public void dash(int[] dash, double phase) throws IOException {
        this.print("[");
        int i = 0;
        while (i < dash.length) {
            this.print(" " + dash[i]);
            ++i;
        }
        this.println("] " + phase + " d");
    }

    public void dash(double[] dash, double phase) throws IOException {
        this.print("[");
        int i = 0;
        while (i < dash.length) {
            this.print(" " + dash[i]);
            ++i;
        }
        this.println("] " + phase + " d");
    }

    public void flatness(double flatness) throws IOException {
        this.println(flatness + " i");
    }

    public void state(PDFName stateDictionary) throws IOException {
        this.println(stateDictionary + " gs");
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.println(x1 + " " + y1 + " " + x2 + " " + y2 + " " + x3 + " " + y3 + " c");
    }

    public void cubicV(double x2, double y2, double x3, double y3) throws IOException {
        this.println(x2 + " " + y2 + " " + x3 + " " + y3 + " v");
    }

    public void cubicY(double x1, double y1, double x3, double y3) throws IOException {
        this.println(x1 + " " + y1 + " " + x3 + " " + y3 + " y");
    }

    public void move(double x, double y) throws IOException {
        this.println(x + " " + y + " m");
    }

    public void line(double x, double y) throws IOException {
        this.println(x + " " + y + " l");
    }

    public void closePath() throws IOException {
        this.println("h");
    }

    public void rectangle(double x, double y, double width, double height) throws IOException {
        this.println(x + " " + y + " " + width + " " + height + " re");
    }

    public void stroke() throws IOException {
        this.println("S");
    }

    public void closeAndStroke() throws IOException {
        this.println("s");
    }

    public void fill() throws IOException {
        this.println("f");
    }

    public void fillEvenOdd() throws IOException {
        this.println("f*");
    }

    public void fillAndStroke() throws IOException {
        this.println("B");
    }

    public void fillEvenOddAndStroke() throws IOException {
        this.println("B*");
    }

    public void closeFillAndStroke() throws IOException {
        this.println("b");
    }

    public void closeFillEvenOddAndStroke() throws IOException {
        this.println("b*");
    }

    public void endPath() throws IOException {
        this.println("n");
    }

    public void clip() throws IOException {
        this.println("W");
    }

    public void clipEvenOdd() throws IOException {
        this.println("W*");
    }

    public void beginText() throws IOException {
        if (this.textOpen) {
            System.err.println("PDFStream: nested beginText() not allowed.");
        }
        this.println("BT");
        this.textOpen = true;
    }

    public void endText() throws IOException {
        if (!this.textOpen) {
            System.err.println("PDFStream: unbalanced use of beginText()/endText().");
        }
        this.println("ET");
        this.textOpen = false;
    }

    public void charSpace(double charSpace) throws IOException {
        this.println(charSpace + " Tc");
    }

    public void wordSpace(double wordSpace) throws IOException {
        this.println(wordSpace + " Tw");
    }

    public void scale(double scale) throws IOException {
        this.println(scale + " Tz");
    }

    public void leading(double leading) throws IOException {
        this.println(leading + " TL");
    }

    public void font(PDFName fontName, double size) throws IOException {
        this.println(fontName + " " + size + " Tf");
        this.fontWasSet = true;
    }

    public void rendering(int mode) throws IOException {
        this.println(mode + " Tr");
    }

    public void rise(double rise) throws IOException {
        this.println(rise + " Ts");
    }

    public void text(double x, double y) throws IOException {
        this.println(x + " " + y + " Td");
    }

    public void textLeading(double x, double y) throws IOException {
        this.println(x + " " + y + " TD");
    }

    public void textMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        this.println(a + " " + b + " " + c + " " + d + " " + e + " " + f + " Tm");
    }

    public void textLine() throws IOException {
        this.println("T*");
    }

    public void show(String text) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println("(" + PDFUtil.escape(text) + ") Tj");
    }

    public void showLine(String text) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println("(" + PDFUtil.escape(text) + ") '");
    }

    public void showLine(double wordSpace, double charSpace, String text) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println(wordSpace + " " + charSpace + " (" + PDFUtil.escape(text) + ") \"");
    }

    public void show(Object[] array) throws IOException {
        this.print("[");
        int i = 0;
        while (i < array.length) {
            Object object = array[i];
            if (object instanceof String) {
                this.print(" (" + PDFUtil.escape(object.toString()) + ")");
            } else if (object instanceof Integer) {
                this.print(" " + (Integer)object);
            } else if (object instanceof Double) {
                this.print(" " + (Double)object);
            } else {
                System.err.println("PDFStream: input array of operator TJ may only contain objects of type 'String', 'Integer' or 'Double'");
            }
            ++i;
        }
        this.println("] TJ");
    }

    public void glyph(double wx, double wy) throws IOException {
        this.println(wx + " " + wy + " d0");
    }

    public void glyph(double wx, double wy, double llx, double lly, double urx, double ury) throws IOException {
        this.println(wx + " " + wy + " " + llx + " " + lly + " " + urx + " " + ury + " d1");
    }

    public void colorSpace(PDFName colorSpace) throws IOException {
        this.println(colorSpace + " cs");
    }

    public void colorSpaceStroke(PDFName colorSpace) throws IOException {
        this.println(colorSpace + " CS");
    }

    public void colorSpace(double[] color) throws IOException {
        int i = 0;
        while (i < color.length) {
            this.print(" " + color[i]);
            ++i;
        }
        this.println(" scn");
    }

    public void colorSpaceStroke(double[] color) throws IOException {
        int i = 0;
        while (i < color.length) {
            this.print(" " + color[i]);
            ++i;
        }
        this.println(" SCN");
    }

    public void colorSpace(double[] color, PDFName name) throws IOException {
        if (color != null) {
            int i = 0;
            while (i < color.length) {
                this.print(color[i] + " ");
                ++i;
            }
        }
        this.println(name + " scn");
    }

    public void colorSpaceStroke(double[] color, PDFName name) throws IOException {
        if (color != null) {
            int i = 0;
            while (i < color.length) {
                this.print(color[i] + " ");
                ++i;
            }
        }
        this.println(name + " SCN");
    }

    public void colorSpace(double g) throws IOException {
        this.println(g + " g");
    }

    public void colorSpaceStroke(double g) throws IOException {
        this.println(g + " G");
    }

    public void colorSpace(double r, double g, double b) throws IOException {
        this.println(r + " " + g + " " + b + " rg");
    }

    public void colorSpaceStroke(double r, double g, double b) throws IOException {
        this.println(r + " " + g + " " + b + " RG");
    }

    public void colorSpace(double c, double m, double y, double k) throws IOException {
        this.println(c + " " + m + " " + y + " " + k + " k");
    }

    public void colorSpaceStroke(double c, double m, double y, double k) throws IOException {
        this.println(c + " " + m + " " + y + " " + k + " K");
    }

    public void shade(PDFName name) throws IOException {
        this.println(name + " sh");
    }

    public void image(Image image, int width, int height) throws IOException {
        int[] pixels = PDFStream.getPixels(image, width, height);
        if (pixels != null) {
            this.entry("Width", width);
            this.entry("Height", height);
            this.entry("ColorSpace", this.pdf.name("DeviceRGB"));
            this.entry("BitsPerComponent", 8);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int pixel = pixels[i * width + j];
                    int alpha = pixel >> 24 & 0xFF;
                    this.write(pixel >> 16 & 0xFF);
                    this.write(pixel >> 8 & 0xFF);
                    this.write(pixel & 0xFF);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void imageMask(Image image, int width, int height) throws IOException {
        int[] pixels = PDFStream.getPixels(image, width, height);
        if (pixels != null) {
            this.entry("Width", width);
            this.entry("Height", height);
            this.entry("BitsPerComponent", 8);
            this.entry("ColorSpace", this.pdf.name("DeviceGray"));
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int pixel = pixels[i * width + j];
                    int alpha = pixel >> 24 & 0xFF;
                    this.write(alpha);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void inlineImage(Image image, int width, int height) throws IOException {
        this.inlineImage(image, width, height, null, false);
    }

    public void inlineImage(Image image, int width, int height, String[] encode) throws IOException {
        this.inlineImage(image, width, height, encode, false);
    }

    public void inlineImage(Image image, int width, int height, String[] encode, boolean transparancy) throws IOException {
        int[] pixels = PDFStream.getPixels(image, width, height);
        if (pixels != null) {
            this.beginImage();
            this.imageInfo("Width", width);
            this.imageInfo("Height", height);
            this.imageInfo("ColorSpace", this.pdf.name("DeviceRGB"));
            this.imageInfo("BitsPerComponent", 8);
            OutputStream s = this.openImageData(encode);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int pixel = pixels[i * width + j];
                    int alpha = pixel >> 24 & 0xFF;
                    s.write(pixel >> 16 & 0xFF);
                    s.write(pixel >> 8 & 0xFF);
                    s.write(pixel & 0xFF);
                    ++j;
                }
                ++i;
            }
            this.closeImageData();
        }
    }

    private static int[] getPixels(Image image, int width, int height) {
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            boolean success = grabber.grabPixels();
            if (!success) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException ie) {
            System.err.println("PDFWriter: Could not grab pixels of an image");
            return null;
        }
        return pixels;
    }

    public void beginImage() throws IOException {
        if (this.imageOpen) {
            System.err.println("PDFStream: nested beginImage() not allowed.");
        }
        this.println("BI");
        this.imageOpen = true;
    }

    public void imageInfo(String key, int number) throws IOException {
        if (!this.imageOpen) {
            System.err.println("PDFStream: cannot use imageInfo() outside Image.");
        }
        this.println("/" + key + " " + number);
    }

    public void imageInfo(String key, PDFName name) throws IOException {
        if (!this.imageOpen) {
            System.err.println("PDFStream: cannot use imageInfo() outside Image.");
        }
        this.println("/" + key + " " + name);
    }

    public void imageInfo(String key, Object[] array) throws IOException {
        if (!this.imageOpen) {
            System.err.println("PDFStream: cannot use imageInfo() outside Image.");
        }
        this.print("/" + key + " [");
        int i = 0;
        while (i < array.length) {
            this.print(" " + array[i]);
            ++i;
        }
        this.println("]");
    }

    public void imageData(byte[] data) throws IOException {
        OutputStream os = this.openImageData(null);
        int i = 0;
        while (i < data.length) {
            os.write(data[i]);
            ++i;
        }
    }

    public OutputStream openImageData(String[] encode) throws IOException {
        Object[] filters;
        if (!this.imageOpen) {
            System.err.println("PDFStream: cannot use imageData() outside Image.");
        }
        if ((filters = PDFStream.decodeFilters(encode)) != null) {
            this.imageInfo("Filter", filters);
        }
        this.print("ID\n");
        this.imageStream = PDFStream.openFilters(this.stream[0], encode);
        return this.imageStream[0];
    }

    public void closeImageData() throws IOException {
        PDFStream.closeFilters(this.imageStream);
        this.imageStream = null;
        this.println("\nEI");
        this.imageOpen = false;
    }

    public void xObject(PDFName name) throws IOException {
        this.println(name + " Do");
    }

    public void beginCompatibility() throws IOException {
        if (this.compatibilityOpen) {
            System.err.println("PDFStream: nested use of Compatibility sections not allowed.");
        }
        this.println("BX");
        this.compatibilityOpen = true;
    }

    public void endCompatibility() throws IOException {
        if (!this.compatibilityOpen) {
            System.err.println("PDFStream: unbalanced use of begin/endCompatibilty().");
        }
        this.println("EX");
        this.compatibilityOpen = false;
    }
}

