/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.pdf;

import java.awt.Image;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.freehep.util.pdf.PDFDictionary;
import org.freehep.util.pdf.PDFName;
import org.freehep.util.pdf.PDFStream;
import org.freehep.util.pdf.PDFWriter;

public class PDFImageDelayQueue {
    private static int currentNumber = 0;
    private List imageList;
    private PDFWriter pdf;

    public PDFImageDelayQueue(PDFWriter pdf) {
        this.pdf = pdf;
        this.imageList = new LinkedList();
    }

    public PDFName delayImage(Image image, int w, int h, boolean mask) {
        Entry e = new Entry(image, w, h, mask);
        this.imageList.add(e);
        return this.pdf.name(e.name);
    }

    public void processAll() throws IOException {
        ListIterator i = this.imageList.listIterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            PDFStream img = this.pdf.openStream(e.name, new String[]{"Flate", "ASCII85"});
            img.entry("Subtype", this.pdf.name("Image"));
            if (e.mask) {
                img.entry("SMask", this.pdf.ref(e.maskName));
            }
            img.image(e.image, e.w, e.h);
            this.pdf.close(img);
            if (!e.mask) continue;
            PDFStream mask = this.pdf.openStream(e.maskName, new String[]{"Flate", "ASCII85"});
            mask.entry("Subtype", this.pdf.name("Image"));
            mask.imageMask(e.image, e.w, e.h);
            this.pdf.close(mask);
        }
    }

    public void addXObjects(PDFDictionary xObjects) throws IOException {
        ListIterator i = this.imageList.listIterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            xObjects.entry(e.name, this.pdf.ref(e.name));
            if (!e.mask) continue;
            xObjects.entry(e.maskName, this.pdf.ref(e.maskName));
        }
    }

    private class Entry {
        private Image image;
        private boolean mask;
        private String name;
        private String maskName;
        private int w;
        private int h;

        private Entry(Image image, int w, int h, boolean mask) {
            this.image = image;
            this.mask = mask;
            this.w = w;
            this.h = h;
            this.name = "Img" + currentNumber++;
            if (mask) {
                this.maskName = this.name + "Mask";
            }
        }
    }
}

