/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.pdf;

import java.io.IOException;
import java.util.Calendar;
import org.freehep.util.pdf.PDF;
import org.freehep.util.pdf.PDFByteWriter;
import org.freehep.util.pdf.PDFConstants;
import org.freehep.util.pdf.PDFName;
import org.freehep.util.pdf.PDFObject;
import org.freehep.util.pdf.PDFRef;
import org.freehep.util.pdf.PDFUtil;

public class PDFDictionary
implements PDFConstants {
    private String open = null;
    protected PDFByteWriter out;
    private boolean ok;
    private PDFObject object;
    protected PDF pdf;

    PDFDictionary(PDF pdf, PDFByteWriter writer) throws IOException {
        this(pdf, writer, null);
    }

    PDFDictionary(PDF pdf, PDFByteWriter writer, PDFObject parent) throws IOException {
        this.pdf = pdf;
        this.object = parent;
        this.out = writer;
        this.out.println("<< ");
        this.out.indent();
        this.ok = true;
    }

    void close() throws IOException {
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.out.outdent();
        this.out.println(">>");
        if (this.object != null) {
            this.object.close();
        }
        this.ok = false;
    }

    public void entry(String key, String string) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + key + " (" + PDFUtil.escape(string) + ")");
    }

    public void entry(String key, PDFName name) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + key + " " + name);
    }

    public void entry(String key, int number) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + key + " " + number);
    }

    public void entry(String key, double number) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + key + " " + number);
    }

    public void entry(String key, boolean bool) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + key + " " + (bool ? "true" : "false"));
    }

    public void entry(String key, PDFRef ref) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + key + " " + ref);
    }

    public void entry(String key, Calendar date) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + key + " " + PDFUtil.date(date));
    }

    public void entry(String key, Object[] objs) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.print("/" + key + " [");
        int i = 0;
        while (i < objs.length) {
            if (i != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(objs[i]);
            ++i;
        }
        this.out.printPlain("]");
        this.out.println();
    }

    public void entry(String key, int[] numbers) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.print("/" + key + " [");
        int i = 0;
        while (i < numbers.length) {
            if (i != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(numbers[i]);
            ++i;
        }
        this.out.printPlain("]");
        this.out.println();
    }

    public void entry(String key, double[] numbers) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.print("/" + key + " [");
        int i = 0;
        while (i < numbers.length) {
            if (i != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(numbers[i]);
            ++i;
        }
        this.out.printPlain("]");
        this.out.println();
    }

    public void entry(String key, boolean[] bool) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.print("/" + key + " [");
        int i = 0;
        while (i < bool.length) {
            if (i != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(bool[i] ? "true" : "false");
            ++i;
        }
        this.out.printPlain("]");
        this.out.println();
    }

    public PDFDictionary openDictionary(String name) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFDictionary: " + name;
        this.out.println("/" + name);
        PDFDictionary dictionary = new PDFDictionary(this.pdf, this.out);
        return dictionary;
    }

    public void close(PDFDictionary dictionary) throws IOException {
        dictionary.close();
        this.open = null;
    }
}

