/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.parameterdatabase;

import java.util.LinkedList;

public class ParameterKey {
    private Object object;
    private String name;
    private boolean isValid;
    private static int inventoryLimit = 10000;
    private static LinkedList inventory = new LinkedList();

    protected ParameterKey(Object object, String name) {
        this.object = object;
        this.name = name;
        this.isValid = true;
    }

    public static ParameterKey createParameterKey(Object object, String name) {
        if (object == null || name == null) {
            throw new IllegalArgumentException();
        }
        ParameterKey newKey = null;
        LinkedList linkedList = inventory;
        synchronized (linkedList) {
            if (!inventory.isEmpty()) {
                newKey = (ParameterKey)inventory.removeFirst();
                newKey.object = object;
                newKey.name = name;
                newKey.isValid = true;
            }
        }
        if (newKey == null) {
            newKey = new ParameterKey(object, name);
        }
        return newKey;
    }

    public Object getObject() {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        return this.object;
    }

    public String getName() {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        return this.name;
    }

    protected void recycle() {
        this.isValid = false;
        this.object = null;
        this.name = null;
    }

    public boolean equals(Object otherKey) {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        if (!(otherKey instanceof ParameterKey)) {
            return false;
        }
        ParameterKey other = (ParameterKey)otherKey;
        if (!other.isValid) {
            throw new IllegalStateException();
        }
        return this.object.equals(other.object) && this.name.equals(other.name);
    }

    public int hashCode() {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        return this.object.hashCode() ^ this.name.hashCode();
    }

    public void finalize() throws Throwable {
        LinkedList linkedList = inventory;
        synchronized (linkedList) {
            if (inventory.size() < inventoryLimit) {
                this.recycle();
                inventory.add(this);
                throw new Throwable();
            }
        }
    }
}

