/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.parameterdatabase;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.freehep.swing.CellOrientatedTable;
import org.freehep.util.parameterdatabase.ClassIterator;
import org.freehep.util.parameterdatabase.DatabaseListener;
import org.freehep.util.parameterdatabase.ParameterDatabase;
import org.freehep.util.parameterdatabase.editor.DoubleRangeEditor;
import org.freehep.util.parameterdatabase.editor.SelectorEditor;

public class DatabaseTable
implements TableModel,
DatabaseListener {
    private JComponent table;
    private Object key = null;
    private boolean local;
    private ClassIterator classIterator = null;
    private String[] names = null;
    ParameterDatabase database;
    protected LinkedList tableModelListeners = new LinkedList();
    static /* synthetic */ Class class$org$freehep$util$parameterdatabase$selector$Selector;
    static /* synthetic */ Class class$org$freehep$util$parameterdatabase$types$DoubleRange;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public DatabaseTable(ParameterDatabase database) {
        this(database, true);
    }

    public DatabaseTable(ParameterDatabase database, boolean local) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        this.local = local;
        this.database = database;
        this.table = this.makeForm();
    }

    public JComponent getForm() {
        return this.table;
    }

    public void setKeyObject(Object key) {
        if (this.key != key) {
            this.key = key;
            if (key != null) {
                this.classIterator = new ClassIterator(key);
                this.names = this.database.getCurrentParameterSet(this.classIterator);
            } else {
                this.classIterator = null;
                this.names = null;
            }
            this.fireTableChanged();
        }
    }

    public void databaseUpdated() {
        this.fireTableChanged();
    }

    public void fireTableChanged() {
        TableModelEvent event = new TableModelEvent(this);
        Iterator iterator = this.tableModelListeners.iterator();
        while (iterator.hasNext()) {
            TableModelListener listener = (TableModelListener)iterator.next();
            listener.tableChanged(event);
        }
    }

    private JComponent makeForm() {
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        CellOrientatedTable table = new CellOrientatedTable(this);
        table.setDefaultEditor(class$org$freehep$util$parameterdatabase$selector$Selector == null ? (class$org$freehep$util$parameterdatabase$selector$Selector = DatabaseTable.class$("org.freehep.util.parameterdatabase.selector.Selector")) : class$org$freehep$util$parameterdatabase$selector$Selector, new SelectorEditor());
        table.setDefaultEditor(class$org$freehep$util$parameterdatabase$types$DoubleRange == null ? (class$org$freehep$util$parameterdatabase$types$DoubleRange = DatabaseTable.class$("org.freehep.util.parameterdatabase.types.DoubleRange")) : class$org$freehep$util$parameterdatabase$types$DoubleRange, new DoubleRangeEditor());
        JScrollPane scroll = new JScrollPane(table);
        main.add((Component)scroll, "Center");
        return main;
    }

    public void addTableModelListener(TableModelListener listener) {
        if (listener != null) {
            this.tableModelListeners.add(listener);
        }
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.tableModelListeners.remove(listener);
    }

    public Class getColumnClass(int columnIndex) {
        Class columnClass;
        if (!this.local) {
            ++columnIndex;
        }
        switch (columnIndex) {
            case 0: {
                columnClass = class$java$lang$Boolean == null ? (class$java$lang$Boolean = DatabaseTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                break;
            }
            case 1: {
                columnClass = class$java$lang$String == null ? (class$java$lang$String = DatabaseTable.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 2: {
                columnClass = class$java$lang$Object == null ? (class$java$lang$Object = DatabaseTable.class$("java.lang.Object")) : class$java$lang$Object;
                break;
            }
            default: {
                columnClass = null;
            }
        }
        return columnClass;
    }

    public int getColumnCount() {
        return this.local ? 3 : 2;
    }

    public String getColumnName(int columnIndex) {
        String columnName;
        if (!this.local) {
            ++columnIndex;
        }
        switch (columnIndex) {
            case 0: {
                columnName = "Local";
                break;
            }
            case 1: {
                columnName = "Parameter";
                break;
            }
            case 2: {
                columnName = "Value";
                break;
            }
            default: {
                columnName = null;
            }
        }
        return columnName;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.local) {
            return columnIndex == 0 || columnIndex == 2;
        }
        return columnIndex == 1;
    }

    public int getRowCount() {
        return this.names != null ? this.names.length : 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.local) {
            ++columnIndex;
        }
        if (columnIndex == 0) {
            this.classIterator.reset();
            String name = this.names[rowIndex];
            if (this.database.isParameterLocal(name, this.classIterator)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (columnIndex == 1) {
            return this.names[rowIndex];
        }
        if (columnIndex == 2) {
            this.classIterator.reset();
            String name = this.names[rowIndex];
            return this.database.getParameter(name, this.classIterator);
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int cIndex = columnIndex;
        if (!this.local) {
            ++cIndex;
        }
        if (cIndex == 0 && aValue instanceof Boolean) {
            String name;
            boolean makeLocal = (Boolean)aValue;
            if (makeLocal) {
                name = this.names[rowIndex];
                Object value = this.getValueAt(rowIndex, 2);
                if (value != null) {
                    Object firstObject = null;
                    this.classIterator.reset();
                    if (this.classIterator.hasNext()) {
                        firstObject = this.classIterator.next();
                    }
                    PropertyChangeListener listener = null;
                    if (firstObject instanceof PropertyChangeListener) {
                        listener = (PropertyChangeListener)firstObject;
                    }
                    this.classIterator.reset();
                    this.database.addParameter(name, value, this.classIterator, listener);
                }
            } else {
                name = this.names[rowIndex];
                this.classIterator.reset();
                this.database.removeParameter(name, this.classIterator);
            }
        }
        if (cIndex == 2) {
            String name = this.names[rowIndex];
            Object object = this.getValueAt(rowIndex, columnIndex);
            Class<?> c = object.getClass();
            if (c.equals(aValue.getClass())) {
                this.classIterator.reset();
                this.database.setParameter(name, aValue, this.classIterator);
            } else if (aValue instanceof String) {
                String value = (String)aValue;
                if (object != null) {
                    Object[] parameters = new Object[]{value};
                    Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DatabaseTable.class$("java.lang.String")) : class$java$lang$String};
                    try {
                        Class<?> objectClass = object.getClass();
                        Constructor<?> constructor = objectClass.getConstructor(parameterTypes);
                        Object newValue = constructor.newInstance(parameters);
                        this.classIterator.reset();
                        this.database.setParameter(name, newValue, this.classIterator);
                    }
                    catch (NoSuchMethodException nsme) {
                        nsme.printStackTrace();
                    }
                    catch (InstantiationException ie) {
                        ie.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

