/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.objectbrowser.reflector;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.freehep.util.objectbrowser.BrowserBroker;
import org.freehep.util.objectbrowser.DocBrowser;
import org.freehep.util.objectbrowser.DocModelNode;
import org.freehep.util.objectbrowser.HierarchyModelNode;
import org.freehep.util.objectbrowser.ModelContext;
import org.freehep.util.objectbrowser.ObjectRep;
import org.freehep.util.objectbrowser.Property;
import org.freehep.util.objectbrowser.PropertyBrowser;
import org.freehep.util.objectbrowser.PropertyGroup;
import org.freehep.util.objectbrowser.PropertyModelNode;
import org.freehep.util.objectbrowser.SelectionEvent;
import org.freehep.util.objectbrowser.StringPropertyValue;
import org.freehep.util.objectbrowser.TreeBrowser;

class ObjectPanel
extends JPanel {
    private JSplitPane splitPane = new JSplitPane(1);
    private JSplitPane splitPane2 = new JSplitPane(0);
    private BrowserBroker broker;
    private HierarchyModelNode _hierarchy;

    public ObjectPanel() {
        ObjectRep o = new ObjectRep();
        this._hierarchy = new HierarchyModelNode("Top Level");
        o.add(new ModelContext(this._hierarchy));
        DocModelNode d = new DocModelNode("OB");
        o.add(new ModelContext(d));
        this.broker = new BrowserBroker();
        TreeBrowser tbrowser = new TreeBrowser(this.broker, this._hierarchy);
        tbrowser.component().setMinimumSize(new Dimension(100, 50));
        tbrowser.component().setPreferredSize(new Dimension(100, 100));
        tbrowser.component().setFont(new Font("SansSerif", 0, 10));
        PropertyBrowser pbrowser = new PropertyBrowser(this.broker, null);
        pbrowser.component().setPreferredSize(new Dimension(300, 300));
        pbrowser.component().setFont(new Font("SansSerif", 0, 10));
        DocBrowser dbrowser = new DocBrowser(this.broker, null);
        dbrowser.component().setFont(new Font("SansSerif", 0, 10));
        this.splitPane2.add(pbrowser.component());
        this.splitPane2.add(dbrowser.component());
        this.splitPane.add(tbrowser.component());
        this.splitPane.add(this.splitPane2);
        this.setLayout(new BorderLayout());
        this.add("Center", this.splitPane);
        this.broker.sendSelectionEvent(new SelectionEvent(this._hierarchy.context()));
    }

    public void add(Object object) {
        this.add(object, true, false);
    }

    public void add(Object object, boolean doesFields, boolean doesMethods) {
        int i;
        if (object instanceof Collection) {
            this.addCollection((Collection)object, doesFields, doesMethods);
            return;
        }
        String oName = object.getClass().getName();
        oName = oName.substring(oName.lastIndexOf(".") + 1);
        ObjectRep o = new ObjectRep();
        HierarchyModelNode h = new HierarchyModelNode(oName);
        o.add(new ModelContext(h));
        DocModelNode d = new DocModelNode(object.toString());
        o.add(new ModelContext(d));
        PropertyModelNode pr = new PropertyModelNode();
        o.add(new ModelContext(pr));
        if (doesFields) {
            PropertyGroup gFields = new PropertyGroup("Fields");
            pr.addGroup(gFields);
            AccessibleObject[] fields = object.getClass().getFields();
            AccessibleObject.setAccessible(fields, true);
            i = 0;
            while (i < Array.getLength(fields)) {
                if (((Field)fields[i]).getDeclaringClass() != object.getClass()) {
                    try {
                        gFields.addProperty(new Property(gFields, "(" + Modifier.toString(((Field)fields[i]).getModifiers()) + " " + ((Field)fields[i]).getType().getName() + ") " + ((Field)fields[i]).getDeclaringClass().getName() + "." + ((Field)fields[i]).getName(), new StringPropertyValue(((Field)fields[i]).get(object).toString())));
                    }
                    catch (IllegalAccessException e) {
                        System.err.println("ERROR(OBRep): can't get " + oName + "." + ((Field)fields[i]).getName());
                    }
                }
                ++i;
            }
            fields = object.getClass().getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            int i2 = 0;
            while (i2 < Array.getLength(fields)) {
                try {
                    gFields.addProperty(new Property(gFields, "(" + Modifier.toString(((Field)fields[i2]).getModifiers()) + " " + ((Field)fields[i2]).getType().getName() + ") " + ((Field)fields[i2]).getName(), new StringPropertyValue(((Field)fields[i2]).get(object).toString())));
                }
                catch (IllegalAccessException e) {
                    System.err.println("ERROR(OBRep): can't get " + oName + "." + ((Field)fields[i2]).getName());
                }
                ++i2;
            }
        }
        if (doesMethods) {
            PropertyGroup gMethods = new PropertyGroup("Methods()");
            pr.addGroup(gMethods);
            AccessibleObject[] methods = object.getClass().getMethods();
            AccessibleObject.setAccessible(methods, true);
            i = 0;
            while (i < Array.getLength(methods)) {
                if (((Method)methods[i]).getDeclaringClass() != object.getClass() && !((Method)methods[i]).getName().equals("toString")) {
                    if (Array.getLength(((Method)methods[i]).getParameterTypes()) == 0 && !((Method)methods[i]).getReturnType().getName().equals("void")) {
                        try {
                            gMethods.addProperty(new Property(gMethods, "(" + Modifier.toString(((Method)methods[i]).getModifiers()) + " " + ((Method)methods[i]).getReturnType().getName() + ") " + ((Method)methods[i]).getDeclaringClass().getName() + "." + ((Method)methods[i]).getName(), new StringPropertyValue(((Method)methods[i]).invoke(object, new Object[0]).toString())));
                        }
                        catch (IllegalAccessException e) {
                            System.err.println("ERROR(OBRep): can't invoke " + oName + "." + ((Method)methods[i]).getName() + "()");
                        }
                        catch (InvocationTargetException e) {
                            System.err.println("ERROR(OBRep): can't invoke " + oName + "." + ((Method)methods[i]).getName() + "()");
                        }
                    } else {
                        gMethods.addProperty(new Property(gMethods, "(" + Modifier.toString(((Method)methods[i]).getModifiers()) + " " + ((Method)methods[i]).getReturnType().getName() + ") " + ((Method)methods[i]).getName(), new StringPropertyValue("NA")));
                    }
                }
                ++i;
            }
            methods = object.getClass().getDeclaredMethods();
            AccessibleObject.setAccessible(methods, true);
            int i3 = 0;
            while (i3 < Array.getLength(methods)) {
                if (!((Method)methods[i3]).getName().equals("toString")) {
                    if (Array.getLength(((Method)methods[i3]).getParameterTypes()) == 0 && !((Method)methods[i3]).getReturnType().getName().equals("void")) {
                        try {
                            gMethods.addProperty(new Property(gMethods, "(" + Modifier.toString(((Method)methods[i3]).getModifiers()) + " " + Modifier.toString(((Method)methods[i3]).getModifiers()) + " " + ((Method)methods[i3]).getReturnType().getName() + ") " + ((Method)methods[i3]).getName(), new StringPropertyValue(((Method)methods[i3]).invoke(object, new Object[0]).toString())));
                        }
                        catch (IllegalAccessException e) {
                            System.err.println("ERROR(OBRep): can't invoke " + oName + "." + ((Method)methods[i3]).getName() + "()");
                        }
                        catch (InvocationTargetException e) {
                            System.err.println("ERROR(OBRep): can't invoke " + oName + "." + ((Method)methods[i3]).getName() + "()");
                        }
                    } else {
                        gMethods.addProperty(new Property(gMethods, "(" + ((Method)methods[i3]).getReturnType().getName() + ") " + ((Method)methods[i3]).getName(), new StringPropertyValue("NA")));
                    }
                }
                ++i3;
            }
        }
        this._hierarchy.add(h);
    }

    private void addCollection(Collection collection, boolean doesFields, boolean doesMethods) {
        String cName = collection.getClass().getName();
        cName = cName.substring(cName.lastIndexOf(".") + 1);
        HierarchyModelNode hTemp = this._hierarchy;
        this._hierarchy = new HierarchyModelNode(cName);
        hTemp.add(this._hierarchy);
        ObjectRep o = new ObjectRep();
        o.add(new ModelContext(this._hierarchy));
        DocModelNode d = new DocModelNode(collection.toString());
        o.add(new ModelContext(d));
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.add(it.next(), doesFields, doesMethods);
        }
        this._hierarchy = hTemp;
    }
}

