/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.objectbrowser;

import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.freehep.util.objectbrowser.Browser;
import org.freehep.util.objectbrowser.BrowserBroker;
import org.freehep.util.objectbrowser.HierarchyModelNode;
import org.freehep.util.objectbrowser.ModelContext;
import org.freehep.util.objectbrowser.SelectionEvent;

public class TreeBrowser
implements Browser {
    private BrowserBroker m_broker;
    private JTree m_tree;
    private JScrollPane m_treeView;
    private ModelContext m_last_context;

    public TreeBrowser(BrowserBroker broker, HierarchyModelNode model) {
        this.m_broker = broker;
        broker.addSelectionListener(this);
        this.m_last_context = model.context();
        this.m_tree = new JTree(model);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(new ImageIcon(ClassLoader.getSystemResource("org/freehep/util/objectbrowser/images/object.gif")));
        renderer.setClosedIcon(new ImageIcon(ClassLoader.getSystemResource("org/freehep/util/objectbrowser/images/foldcollapsed.gif")));
        renderer.setOpenIcon(new ImageIcon(ClassLoader.getSystemResource("org/freehep/util/objectbrowser/images/foldexpanded.gif")));
        this.m_tree.setCellRenderer(renderer);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                HierarchyModelNode node = (HierarchyModelNode)e.getPath().getLastPathComponent();
                TreeBrowser.this.m_last_context = node.context();
                TreeBrowser.this.m_broker.sendSelectionEvent(new SelectionEvent(TreeBrowser.this.m_last_context));
            }
        });
        this.m_treeView = new JScrollPane(this.m_tree);
    }

    public void selectionChanged(SelectionEvent event) {
        if (event.context() != this.m_last_context) {
            ModelContext c = event.context();
            HierarchyModelNode node = null;
            while (c.previous() != null) {
                c = c.previous();
            }
            while (c != null && node == null) {
                try {
                    node = (HierarchyModelNode)c.model();
                }
                catch (Exception e) {
                    // empty catch block
                }
                c = c.next();
            }
        }
    }

    public JScrollPane component() {
        return this.m_treeView;
    }
}

