/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.objectbrowser;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.freehep.util.objectbrowser.AbstractTreeTableModel;
import org.freehep.util.objectbrowser.Browser;
import org.freehep.util.objectbrowser.BrowserBroker;
import org.freehep.util.objectbrowser.JTreeTable;
import org.freehep.util.objectbrowser.ModelContext;
import org.freehep.util.objectbrowser.Property;
import org.freehep.util.objectbrowser.PropertyCatSort;
import org.freehep.util.objectbrowser.PropertyGroup;
import org.freehep.util.objectbrowser.PropertyModelNode;
import org.freehep.util.objectbrowser.PropertyRenderer;
import org.freehep.util.objectbrowser.PropertySorter;
import org.freehep.util.objectbrowser.PropertyValue;
import org.freehep.util.objectbrowser.SelectionEvent;
import org.freehep.util.objectbrowser.TreeTableModel;

public class PropertyBrowser
implements Browser {
    private BrowserBroker m_broker;
    private PropertyModelNode m_model;
    private JTabbedPane m_tab_pane;
    private JTreeTable m_cat_table;
    private PropertyTableModel m_cat_model;
    private PropertyRenderer m_renderer;

    public PropertyBrowser(BrowserBroker broker, PropertyModelNode model) {
        this.m_broker = broker;
        broker.addSelectionListener(this);
        this.m_model = model != null ? model : new PropertyModelNode();
        this.m_tab_pane = new JTabbedPane(1);
        this.m_cat_model = new PropertyTableModel(this.m_model, new PropertyCatSort());
        this.m_cat_table = new JTreeTable(this.m_cat_model);
        this.m_cat_table.getTree().setRootVisible(false);
        this.m_cat_table.getTree().setCellRenderer(new DefaultTreeCellRenderer(){

            public Icon getLeafIcon() {
                return null;
            }

            public Icon getClosedIcon() {
                return new ImageIcon(ClassLoader.getSystemResource("org/freehep/util/objectbrowser/images/closed.gif"));
            }

            public Icon getOpenIcon() {
                return new ImageIcon(ClassLoader.getSystemResource("org/freehep/util/objectbrowser/images/open.gif"));
            }
        });
        this.m_tab_pane.addTab("Categorized", null, new JScrollPane(this.m_cat_table), "Cat");
        this.m_renderer = new PropertyRenderer();
        this.m_renderer.setToolTipText("Event properties.");
        this.m_cat_table.getColumnModel().getColumn(1).setCellRenderer(this.m_renderer);
    }

    public void selectionChanged(SelectionEvent event) {
        ModelContext oldContext;
        ModelContext newContext = event.context();
        ModelContext modelContext = oldContext = this.m_model != null ? this.m_model.context() : null;
        if (newContext != oldContext) {
            ModelContext c = event.context();
            PropertyModelNode node = null;
            while (c.previous() != null) {
                c = c.previous();
            }
            while (c != null && node == null) {
                try {
                    node = (PropertyModelNode)c.model();
                }
                catch (Exception e) {
                    // empty catch block
                }
                c = c.next();
            }
            this.m_model = node != null ? node : new PropertyModelNode();
            this.m_cat_model.regenerate();
        }
    }

    public JComponent component() {
        return this.m_tab_pane;
    }

    private class PropertyTableModel
    extends AbstractTreeTableModel
    implements TreeTableModel {
        private PropertySorter m_sorter;
        private PropertyModelNode m_sorted;
        static /* synthetic */ Class class$org$freehep$util$objectbrowser$TreeTableModel;
        static /* synthetic */ Class class$org$freehep$util$objectbrowser$PropertyValue;

        public PropertyTableModel(PropertyModelNode model, PropertySorter sorter) {
            super(model);
            this.m_sorter = sorter;
            this.regenerate();
        }

        public void regenerate() {
            this.m_sorted = null;
            if (PropertyBrowser.this.m_model != null) {
                this.m_sorted = this.m_sorter.sort(PropertyBrowser.this.m_model);
                Object[] path = new Object[]{PropertyBrowser.this.m_model};
                this.fireTreeStructureChanged(this, path, null, null);
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return PropertyBrowser.this.m_model != null ? this.m_sorted.getNbProperties() : 0;
        }

        public Object getValueAt(Object node, int column) {
            switch (column) {
                case 0: {
                    if (node instanceof PropertyGroup) {
                        return ((PropertyGroup)node).getName();
                    }
                    if (!(node instanceof Property)) break;
                    return ((Property)node).getName();
                }
                case 1: {
                    if (node instanceof PropertyGroup) {
                        return new String();
                    }
                    if (!(node instanceof Property)) break;
                    return ((Property)node).getValue();
                }
            }
            return new String("!ERRROR!");
        }

        public String getColumnName(int column) {
            return column == 0 ? "Name" : "Value";
        }

        public Class getColumnClass(int col) {
            Class clazz = col == 0 ? (class$org$freehep$util$objectbrowser$TreeTableModel == null ? (class$org$freehep$util$objectbrowser$TreeTableModel = PropertyTableModel.class$("org.freehep.util.objectbrowser.TreeTableModel")) : class$org$freehep$util$objectbrowser$TreeTableModel) : (class$org$freehep$util$objectbrowser$PropertyValue == null ? (class$org$freehep$util$objectbrowser$PropertyValue = PropertyTableModel.class$("org.freehep.util.objectbrowser.PropertyValue")) : class$org$freehep$util$objectbrowser$PropertyValue);
            return clazz;
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object aValue, int row, int column) {
            int grpindex = row;
            int k = 0;
            while (grpindex > this.m_sorted.propertyGroup(k).getSize()) {
                grpindex -= this.m_sorted.propertyGroup(k).getSize();
                ++k;
            }
            Property property = this.m_sorted.propertyGroup(k).getProperty(grpindex);
            PropertyValue value = (PropertyValue)aValue;
            property.setValue(value);
        }

        public Object getRoot() {
            return PropertyBrowser.this.m_model;
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof PropertyModelNode) {
                return ((PropertyModelNode)parent).propertyGroup(index);
            }
            if (parent instanceof PropertyGroup) {
                return ((PropertyGroup)parent).getProperty(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent instanceof PropertyModelNode) {
                return ((PropertyModelNode)parent).sizeGroup();
            }
            if (parent instanceof PropertyGroup) {
                return ((PropertyGroup)parent).getSize();
            }
            return 0;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

