/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.objectbrowser;

import javax.swing.JLabel;
import org.freehep.util.objectbrowser.Browser;
import org.freehep.util.objectbrowser.BrowserBroker;
import org.freehep.util.objectbrowser.DocModelNode;
import org.freehep.util.objectbrowser.ModelContext;
import org.freehep.util.objectbrowser.SelectionEvent;

public class DocBrowser
implements Browser {
    private BrowserBroker m_broker;
    private JLabel m_label;
    private ModelContext m_last_context;

    public DocBrowser(BrowserBroker broker, DocModelNode model) {
        this.m_broker = broker;
        broker.addSelectionListener(this);
        this.m_last_context = model != null ? model.context() : null;
        this.m_label = new JLabel();
    }

    public void selectionChanged(SelectionEvent event) {
        if (event.context() != this.m_last_context) {
            ModelContext c = event.context();
            DocModelNode node = null;
            while (c.previous() != null) {
                c = c.previous();
            }
            while (c != null && node == null) {
                try {
                    node = (DocModelNode)c.model();
                }
                catch (Exception e) {
                    // empty catch block
                }
                c = c.next();
            }
            if (node != null) {
                this.m_label.setText(node.getString());
            } else {
                this.m_label.setText("");
            }
        }
    }

    public JLabel component() {
        return this.m_label;
    }
}

