/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.BooleanCommandTarget;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandTarget;
import org.freehep.util.commanddispatcher.SimpleCommandTarget;

public class CommandSourceAdapter
implements CommandSource,
ActionListener,
BooleanCommandState,
Observer {
    private CommandTarget m_target;
    private AbstractButton m_button;
    private boolean m_bool;

    public CommandSourceAdapter(AbstractButton button) {
        this.m_button = button;
        this.m_button.addActionListener(this);
        this.m_button.setEnabled(false);
        this.m_bool = this.m_button instanceof JCheckBoxMenuItem || this.m_button instanceof JRadioButtonMenuItem || this.m_button instanceof JToggleButton;
    }

    public String getCommand() {
        return this.m_button.getActionCommand();
    }

    public boolean setTarget(CommandTarget target) {
        if (this.m_bool && target instanceof SimpleCommandTarget) {
            return false;
        }
        if (!this.m_bool && target instanceof BooleanCommandTarget) {
            return false;
        }
        this.m_target = target;
        this.m_target.enable(this);
        return true;
    }

    public void clearTarget() {
        this.m_target = null;
        this.setEnabled(false);
    }

    public CommandTarget getTarget() {
        return this.m_target;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.m_bool) {
            ((BooleanCommandTarget)this.m_target).invoke(this.m_button.isSelected());
        } else {
            ((SimpleCommandTarget)this.m_target).invoke();
        }
    }

    public void setEnabled(boolean state) {
        this.m_button.setEnabled(state);
    }

    public void setSelected(boolean selected) {
        this.m_button.setSelected(selected);
    }

    public void update(Observable o, Object arg) {
        this.m_target.enable(this);
    }
}

