/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class StackedLayout
implements LayoutManager {
    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    protected Dimension getLayoutSize(Container parent, boolean isPreferred) {
        int n = parent.getComponentCount();
        Dimension returnSize = new Dimension();
        int i = 0;
        while (i < n) {
            Component c = parent.getComponent(i);
            if (c != null) {
                Dimension componentSize = isPreferred ? c.getPreferredSize() : c.getMinimumSize();
                returnSize.width = Math.max(returnSize.width, componentSize.width);
                returnSize.height = Math.max(returnSize.height, componentSize.height);
            }
            ++i;
        }
        Insets insets = parent.getInsets();
        returnSize.width += insets.left + insets.right;
        returnSize.height += insets.top + insets.bottom;
        return returnSize;
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int n = parent.getComponentCount();
            if (n > 0) {
                Dimension size = parent.getSize();
                int width = size.width - (insets.left + insets.right);
                int height = size.height - (insets.top + insets.bottom);
                int i = 0;
                while (i < n) {
                    Component c = parent.getComponent(i);
                    c.setBounds(insets.left, insets.top, width, height);
                    ++i;
                }
            }
        }
    }
}

