/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class FlowScrollLayout
extends FlowLayout
implements ComponentListener,
LayoutManager2 {
    private JScrollPane scroller = null;
    private boolean uniformHeight;
    private boolean firstTime = true;

    public FlowScrollLayout() {
        this(null);
    }

    public FlowScrollLayout(JScrollPane scrollPane) {
        this(scrollPane, false);
    }

    public FlowScrollLayout(JScrollPane scrollPane, boolean uniformHeight) {
        this.setScrollPane(scrollPane);
        this.uniformHeight = uniformHeight;
    }

    public void setScrollPane(JScrollPane scrollPane) {
        if (scrollPane != this.scroller) {
            if (this.scroller != null) {
                this.scroller.removeComponentListener(this);
            }
            this.scroller = scrollPane;
            if (this.scroller != null) {
                this.scroller.addComponentListener(this);
            }
        }
    }

    public void setUniformHeight(boolean on) {
        if (this.uniformHeight != on) {
            this.uniformHeight = on;
            if (this.scroller != null) {
                this.scroller.doLayout();
            }
        }
    }

    public boolean isUniformHeight() {
        return this.uniformHeight;
    }

    protected Dimension computeDesiredSize() {
        JViewport viewport = this.scroller.getViewport();
        Dimension extent = viewport.getExtentSize();
        Component child = viewport.getView();
        if (child instanceof Container) {
            Container container = (Container)child;
            Insets insets = container.getInsets();
            int vgap = this.getVgap();
            int hgap = this.getHgap();
            int maxAllowedWidth = extent.width - (insets.left + insets.right + hgap * 2);
            int numComponents = container.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int rowh = 0;
            int maxRowWidth = 0;
            int start = 0;
            int i = 0;
            while (i < numComponents) {
                Component comp = container.getComponent(i);
                if (comp.isVisible()) {
                    Dimension dim = comp.getPreferredSize();
                    if (x == 0 || x + dim.width <= maxAllowedWidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += dim.width;
                        rowh = Math.max(rowh, dim.height);
                    } else {
                        if (this.uniformHeight) {
                            FlowScrollLayout.setHeights(container, rowh, start, i);
                        }
                        if (x > maxRowWidth - hgap) {
                            maxRowWidth = x + hgap;
                        }
                        x = dim.width;
                        y += vgap + rowh;
                        rowh = dim.height;
                        start = i;
                    }
                }
                ++i;
            }
            if (this.uniformHeight) {
                FlowScrollLayout.setHeights(container, rowh, start, numComponents);
            }
            if (x > maxRowWidth - hgap) {
                maxRowWidth = x + hgap;
            }
            return new Dimension(maxRowWidth, y += vgap + rowh + insets.bottom);
        }
        Dimension prefSize = child.getPreferredSize();
        return new Dimension(extent.width, prefSize.height);
    }

    public static void setHeights(Container container, int height, int startIndex, int endIndex) {
        int i = startIndex;
        while (i < endIndex) {
            Component comp = container.getComponent(i);
            if (comp instanceof JComponent) {
                FlowScrollLayout.setPreferredHeight((JComponent)comp, height);
            }
            ++i;
        }
    }

    public static void setPreferredHeight(JComponent comp, int height) {
        Dimension prefSize = comp.getPreferredSize();
        prefSize.height = height;
        comp.setPreferredSize(prefSize);
    }

    protected void updateLayout() {
        if (this.scroller != null) {
            JViewport viewport = this.scroller.getViewport();
            Dimension viewSize = viewport.getViewSize();
            Dimension extentSize = viewport.getExtentSize();
            Dimension desiredSize = this.computeDesiredSize();
            if (viewSize.width != extentSize.width || viewSize.height != desiredSize.height) {
                Dimension newSize = new Dimension(Math.max(desiredSize.width, extentSize.width), Math.max(desiredSize.height, extentSize.height));
                Component child = viewport.getView();
                if (child instanceof JComponent) {
                    ((JComponent)child).setPreferredSize(newSize);
                }
                viewport.setViewSize(newSize);
                if (!this.firstTime) {
                    child.doLayout();
                    this.scroller.doLayout();
                }
            }
        }
    }

    public void layoutContainer(Container c) {
        if (this.firstTime) {
            this.updateLayout();
            this.firstTime = false;
        }
        super.layoutContainer(c);
    }

    public void componentResized(ComponentEvent e) {
        this.updateLayout();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void invalidateLayout(Container target) {
        if (!this.firstTime) {
            this.updateLayout();
        }
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }
}

