/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jaco;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.freehep.jaco.generator.Generator;
import org.freehep.jaco.generator.JNIStub;
import org.freehep.jaco.generator.JNIStubImplementation;
import org.freehep.jaco.generator.JavaInterface;
import org.freehep.jaco.generator.JavaProxy;
import org.freehep.jaco.rtti.IClass;
import org.freehep.jaco.rtti.ParseException;
import org.freehep.jaco.rtti.RTTI;
import org.freehep.jaco.rtti.cpp.CPlusPlusParser;
import org.freehep.jaco.rtti.java.JavaParser;
import org.freehep.util.commandline.CommandLine;
import org.freehep.util.commandline.CommandLineException;

public class Jaco {
    private static String jacoVersion = "0.2";
    private static String jaco = "Java Access to C++ Objects (version " + jacoVersion + ")";
    private static RTTI rtti = new RTTI();
    private static Generator javaInterface = new JavaInterface();
    private static Generator javaProxy = new JavaProxy();
    private static Generator jniStub = new JNIStub();
    private static Generator jniStubImplementation = new JNIStubImplementation();

    public static RTTI getRTTI() {
        return rtti;
    }

    public static Generator getJavaInterface() {
        return javaInterface;
    }

    public static Generator getJavaProxy() {
        return javaProxy;
    }

    public static Generator getJNIStub() {
        return jniStub;
    }

    public static Generator getJNIStubImplementation() {
        return jniStubImplementation;
    }

    public static void main(String[] args) {
        String packagePrefix;
        CommandLine cl = new CommandLine("jaco", jaco, 1);
        cl.addBailOutOption("help", "h", "Show this help page");
        cl.addBailOutOption("version", "v", "Show product version");
        cl.addOption("rtti", "r", "Print RTTI to stdout");
        cl.addOption("nogenerate", "n", "Do not generate any code");
        cl.addOption("directory", "d", "output dir", "Output into directory instead of current directory");
        cl.addOption("package", "p", "package name", "Generate java code using package name");
        cl.addOption("force", "f", "Force overwriting of output files");
        cl.addMultiOption("I", "directory", "Add directory to include search path");
        cl.addOption("cplusplus", "c", "edition", "Set edition of the C++ grammar [1..3]");
        cl.addOption("ignore", "i", "Ignore errors from the parser");
        cl.addParameter("files...", "C++ header files");
        try {
            if (!cl.parse(args)) {
                if (cl.hasOption("help")) {
                    System.err.println(cl.getHelp());
                    System.exit(0);
                } else if (cl.hasOption("version")) {
                    System.err.println(jaco);
                    System.exit(0);
                }
                System.err.println("ERROR: unrecognized bail out option.");
                System.exit(1);
            }
        }
        catch (CommandLineException cle) {
            System.err.println("ERROR: " + cle.getMessage());
            System.err.println();
            System.err.println(cl.getHelp());
            System.exit(1);
        }
        String[] files = cl.getArguments();
        Vector includeDirs = cl.getMultiOption("I");
        int cplusplus = 2;
        try {
            cplusplus = Integer.parseInt(cl.getOption("cplusplus", "2"));
        }
        catch (NumberFormatException nfe) {
            System.err.println("Option 'cplusplus " + cl.getOption("cplusplus") + "' ignored, using " + cplusplus);
        }
        boolean ignore = cl.hasOption("ignore");
        int i = 0;
        while (i < files.length) {
            block22: {
                String filename = files[i];
                try {
                    CPlusPlusParser parser;
                    if (filename.endsWith(".java")) {
                        System.out.println("Parsing Java: " + filename);
                        parser = new JavaParser((InputStream)new FileInputStream(filename));
                    } else {
                        System.out.println("Parsing CPlusPlus: " + filename);
                        parser = new CPlusPlusParser(filename, includeDirs, cplusplus);
                    }
                    parser.parse();
                    parser.addGlobalClasses();
                }
                catch (FileNotFoundException e) {
                    System.err.println("ERROR: File " + filename + " not found.");
                    if (!ignore) {
                        System.exit(1);
                    }
                }
                catch (ParseException e) {
                    System.err.println("ERROR: Encountered errors during parse.");
                    System.err.println(e.getMessage());
                    if (!ignore) {
                        System.exit(1);
                    }
                }
                catch (Exception e) {
                    System.err.println("ERROR: " + e);
                    if (ignore) break block22;
                    System.exit(1);
                }
            }
            ++i;
        }
        String string = packagePrefix = cl.hasOption("package") ? cl.getOption("package") : "";
        if (cl.hasOption("rtti")) {
            System.out.println(Jaco.getRTTI().toString(packagePrefix));
        }
        if (cl.hasOption("nogenerate")) {
            System.out.println("No code generated.");
            System.exit(0);
        }
        boolean overwrite = cl.hasOption("force");
        try {
            String outDir = cl.hasOption("directory") ? cl.getOption("directory") : ".";
            StringBuffer s = new StringBuffer("");
            String[] names = Jaco.getRTTI().getClassNames();
            int i2 = 0;
            while (i2 < names.length) {
                IClass clazz = Jaco.getRTTI().getClass(names[i2]);
                Jaco.writeClass(clazz, packagePrefix, Jaco.getJavaInterface(), outDir, overwrite);
                Jaco.writeClass(clazz, packagePrefix, Jaco.getJavaProxy(), outDir, overwrite);
                Jaco.writeClass(clazz, packagePrefix, Jaco.getJNIStub(), outDir, overwrite);
                Jaco.writeClass(clazz, packagePrefix, Jaco.getJNIStubImplementation(), outDir, overwrite);
                ++i2;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            System.exit(1);
        }
        System.exit(0);
    }

    static void writeClass(IClass clazz, String packagePrefix, Generator generator, String outDir, boolean overwrite) throws IOException {
        generator.setClass(clazz, packagePrefix);
        File dir = new File(outDir + "/" + generator.directory());
        dir.mkdirs();
        File file = new File(dir, generator.filename());
        if (!overwrite && file.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            if (line == null || line.indexOf("JACO-GENERATED") < 0) {
                throw new IOException("Non JACO-GENERATED file exists '" + file + "', cannot overwrite, use -force option");
            }
            reader.close();
        }
        System.out.println("Generating: " + file);
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        generator.print(writer);
        writer.close();
    }
}

